/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.auxiliar;

import es.eucm.eadventure.common.auxiliar.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseFolders {
    private static String PROJECTS_FOLDER = "../Projects";
    private static String EXPORTS_FOLDER = "../Exports";
    private static String REPORTS_FOLDER = "../Reports";
    private static final String WEB_FOLDER = "web";
    private static final String WEB_TEMP_FOLDER = "web/temp";
    private static final String CONFIG_FILE_PATH_EDITOR = "config_editor.xml";
    private static final String CONFIG_FILE_PATH_ENGINE = "config_engine.xml";
    public static final String LANGUAGE_DIR_EDITOR = "i18n/editor";
    public static final String LANGUAGE_DIR_ENGINE = "i18n/engine";
    public static final String IMAGE_LOADING_DIR = "img/loading";
    private static HashMap<String, String> languageNames = new HashMap();
    public static final String LANGUAGE_UNKNOWN = "es_ES";
    public static final String LANGUAGE_SPANISH = "es_ES";
    public static final String LANGUAGE_ENGLISH = "en_EN";
    public static final String LANGUAGE_DEFAULT = "en_EN";

    public static final File projectsFolder() {
        return new File(PROJECTS_FOLDER);
    }

    public static final File exportsFolder() {
        return new File(EXPORTS_FOLDER);
    }

    public static final File reportsFolder() {
        return new File(REPORTS_FOLDER);
    }

    public static final java.io.File webFolder() {
        return new java.io.File(WEB_FOLDER);
    }

    public static final File webTempFolder() {
        return new File(WEB_TEMP_FOLDER);
    }

    public static final java.io.File[] forbiddenFolders() {
        return new java.io.File[]{ReleaseFolders.webFolder(), ReleaseFolders.webTempFolder()};
    }

    public static final String configFileEditorRelativePath() {
        return CONFIG_FILE_PATH_EDITOR;
    }

    public static final String configFileEngineRelativePath() {
        return CONFIG_FILE_PATH_ENGINE;
    }

    public static String getLanguageFilePath4Editor(boolean bl, String string) {
        String string2 = "i18n/editor/";
        if (bl) {
            string2 = string2 + string + ".xml";
        } else {
            string2 = LANGUAGE_DIR_ENGINE + java.io.File.separator;
            string2 = string2 + string + ".xml";
        }
        return string2;
    }

    public static String getLanguageFilePath4Engine(String string) {
        String string2 = "i18n/engine/";
        string2 = string2 + string + ".xml";
        return string2;
    }

    public static String getLanguageFromPath(String string) {
        if (string != null && string.endsWith(".xml")) {
            return string.substring(string.length() - 9, string.length() - 4);
        }
        return "en_EN";
    }

    public static final String getAboutFilePath(String string) {
        return "about-" + string + ".html";
    }

    public static final String getDefaultAboutFilePath() {
        return "about-en_EN.html";
    }

    public static final String getLanguageFilePath(String string) {
        return string + ".xml";
    }

    public static void setProjectsPath(String string) {
        PROJECTS_FOLDER = string;
    }

    public static void setExportsPath(String string) {
        EXPORTS_FOLDER = string;
    }

    public static void setReportsPath(String string) {
        REPORTS_FOLDER = string;
    }

    public static List<String> getLanguages(String string) {
        java.io.File file = new java.io.File("i18n" + java.io.File.separator + string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (java.io.File file2 : file.listFiles()) {
            if (!file2.getName().endsWith("xml")) continue;
            String string2 = file2.getName().substring(0, file2.getName().length() - 4);
            arrayList.add(string2);
            Properties properties = new Properties();
            try {
                properties.loadFromXML(new FileInputStream(file2));
                languageNames.put(string2, (String)properties.get("Language.Name"));
            }
            catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
                invalidPropertiesFormatException.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return arrayList;
    }

    public static String getLanguageName(String string) {
        return languageNames.get(string);
    }
}

