/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.auxiliar;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class ImageTransformer {
    private static ImageTransformer imageTransformer;

    private ImageTransformer() {
    }

    public static ImageTransformer getInstance() {
        if (imageTransformer == null) {
            imageTransformer = new ImageTransformer();
        }
        return imageTransformer;
    }

    public Image getScaledImage(Image image, float f, float f2) {
        BufferedImage bufferedImage = null;
        if (image != null) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(f, f2);
            affineTransform.translate((f - 1.0f) * (float)image.getWidth(null) / 2.0f, (f2 - 1.0f) * (float)image.getHeight(null) / 2.0f);
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
            graphics2D.drawImage(image, affineTransform, null);
            graphics2D.dispose();
        }
        return bufferedImage;
    }
}

