/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.comm.manager.commManager;

import es.eucm.eadventure.comm.AdventureApplet;
import es.eucm.eadventure.common.data.assessment.AssessmentProperty;
import es.eucm.eadventure.engine.adaptation.AdaptationEngine;
import es.eucm.eadventure.engine.core.control.Game;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class CommManagerGAMETEL
extends AdventureApplet {
    private static final long serialVersionUID = -2898258306208612357L;
    private HashMap<String, GametelCommData> dataToSend;
    private String returnURI;
    protected boolean connect;

    @Override
    public void readParameters() {
        super.readParameters();
        this.returnURI = this.getParameter("return-uri");
        if (this.userId == null || this.userId.equals("")) {
            this.userId = this.getParameter("user-id");
        }
    }

    @Override
    public boolean connect(HashMap<String, String> hashMap) {
        this.connect = this.userId != null && this.returnURI != null;
        return false;
    }

    @Override
    public int getCommType() {
        return 4;
    }

    @Override
    public boolean isConnected() {
        return this.connect;
    }

    private void sendData(String string, String string2) {
        String string3 = "userid=" + this.userId + "&" + string2 + "=" + string;
        StringBuffer stringBuffer = this.doPostCall(string3);
        System.out.println("[GAMETEL] POST: " + this.returnURI + "?" + string3 + (stringBuffer != null ? " RESPONSE RECEIVED: " + stringBuffer : " COMMUNICATION FAILED - NULL RESPONSE"));
    }

    private void sendStoredData() {
        if (this.dataToSend == null) {
            this.dataToSend = new HashMap();
        }
        this.dataToSend.put("total-time", new GametelCommData(String.valueOf(Game.getInstance().getTime()), false));
        String string = "userid=" + this.userId;
        for (String object : this.dataToSend.keySet()) {
            if (this.dataToSend.get(object).isSent() && !object.toLowerCase().startsWith("#global")) continue;
            string = string + "&" + object + "=" + this.dataToSend.get(object).getValue();
        }
        StringBuffer stringBuffer = this.doPostCall(string);
        if (stringBuffer != null) {
            for (String string2 : this.dataToSend.keySet()) {
                this.dataToSend.get(string2).setSent(true);
            }
        }
        System.out.println("[GAMETEL] POST: " + this.returnURI + "?" + string + (stringBuffer != null ? " RESPONSE RECEIVED: " + stringBuffer : " COMMUNICATION FAILED - NULL RESPONSE"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer doPostCall(String string) {
        HttpURLConnection httpURLConnection = null;
        StringBuffer stringBuffer = null;
        try {
            String string2;
            URL uRL = new URL(this.returnURI);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            httpURLConnection.setRequestProperty("Content-length", Integer.toString(string.getBytes().length));
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            dataOutputStream.writeBytes(string);
            dataOutputStream.flush();
            dataOutputStream.close();
            InputStream inputStream = httpURLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            stringBuffer = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append('\r');
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return stringBuffer;
    }

    @Override
    public void notifyRelevantState(List<AssessmentProperty> list) {
        if (this.dataToSend == null) {
            this.dataToSend = new HashMap();
        }
        for (AssessmentProperty assessmentProperty : list) {
            String string = assessmentProperty.getId();
            String string2 = assessmentProperty.getValue();
            if (string == null || string2 == null) continue;
            if (this.dataToSend.get(string) != null) {
                this.dataToSend.get(string).setValue(string2);
                continue;
            }
            this.dataToSend.put(string, new GametelCommData(string2, false));
        }
    }

    public void flush() {
        this.sendStoredData();
    }

    @Override
    public void connectionEstablished(String string) {
    }

    @Override
    public void connectionFailed(String string) {
    }

    @Override
    public void dataFromLMS(String string, String string2) {
    }

    @Override
    public void dataSendingFailed(String string) {
    }

    @Override
    public void dataSendingOK(String string) {
    }

    @Override
    public boolean disconnect(HashMap<String, String> hashMap) {
        return false;
    }

    @Override
    public void getAdaptedState(Set<String> set) {
    }

    @Override
    public HashMap<String, String> getInitialStates() {
        return null;
    }

    @Override
    public void sendHTMLReport(String string) {
    }

    @Override
    public void setAdaptationEngine(AdaptationEngine adaptationEngine) {
    }

    private class GametelCommData {
        private String value;
        private boolean sent;

        public GametelCommData(String string, boolean bl) {
            this.value = string;
            this.sent = bl;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public boolean isSent() {
            return this.sent;
        }

        public void setSent(boolean bl) {
            this.sent = bl;
        }
    }
}

