/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.demux.avi;

import java.io.IOException;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.IncompatibleSourceException;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.Track;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.FileTypeDescriptor;
import javax.media.protocol.Positionable;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import net.sourceforge.jffmpeg.GPLLicense;
import net.sourceforge.jffmpeg.demux.avi.Audio;
import net.sourceforge.jffmpeg.demux.avi.AviTrack;
import net.sourceforge.jffmpeg.demux.avi.Video;

public class AviDemux
implements Demultiplexer,
Positionable,
GPLLicense {
    private final int MAX_AUDIO_STREAMS = 1;
    private int numberOfAudioChannels = 0;
    private AviTrack[] track = new AviTrack[2];
    private byte[] idx = null;
    private PullSourceStream dataSource;
    private Seekable seekSource;
    long endOfHeader;
    private String streamVideoTag;

    public void close() {
    }

    public Object getControl(String string) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Time getDuration() {
        return new Time(5000000L);
    }

    public Time getMediaTime() {
        return new Time(5000000L);
    }

    public String getName() {
        return "AVI demux";
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return new ContentDescriptor[]{new FileTypeDescriptor("video.avit")};
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.track;
    }

    public boolean isPositionable() {
        return true;
    }

    public boolean isRandomAccess() {
        return true;
    }

    public void open() throws ResourceUnavailableException {
    }

    public void reset() {
    }

    public Time setPosition(Time time, int n) {
        return time;
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        if (dataSource instanceof PullDataSource) {
            PullSourceStream pullSourceStream;
            this.dataSource = pullSourceStream = ((PullDataSource)dataSource).getStreams()[0];
            if (pullSourceStream instanceof Seekable) {
                this.seekSource = (Seekable)pullSourceStream;
            }
            return;
        }
        throw new IncompatibleSourceException();
    }

    public void start() throws IOException {
        int n;
        String string = new String(this.readBuffer(4), "ASCII");
        this.readBuffer(4);
        String string2 = new String(this.readBuffer(4), "ASCII");
        if (!"RIFF".equalsIgnoreCase(string) || !"AVI ".equalsIgnoreCase(string2)) {
            throw new IOException("Not AVI file");
        }
        byte[] byArray = null;
        while (true) {
            String string3 = new String(this.readBuffer(4), "ASCII");
            n = this.readBytes(4) + 1 & 0xFFFFFFFE;
            if ("LIST".equalsIgnoreCase(string3)) {
                string3 = new String(this.readBuffer(4), "ASCII");
                n -= 4;
                if ("movi".equalsIgnoreCase(string3)) break;
                if ("hdrl".equalsIgnoreCase(string3)) {
                    byArray = this.readBuffer(n);
                }
                if ("idx1".equalsIgnoreCase(string3)) {
                    this.idx = this.readBuffer(n);
                }
                if (!"iddx".equalsIgnoreCase(string3)) continue;
                this.idx = this.readBuffer(n);
                continue;
            }
            this.readBuffer(n);
        }
        int n2 = 0;
        n = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            Object object;
            String string4 = new String(byArray, n3, 4);
            int n4 = AviDemux.str2ulong(byArray, n3 + 4);
            if ("LIST".equalsIgnoreCase(string4)) {
                n3 += 12;
                continue;
            }
            String string5 = new String(byArray, n3 + 8, 4);
            if ("strh".equalsIgnoreCase(string4)) {
                int n5;
                int n6;
                n = 0;
                if ("vids".equalsIgnoreCase(string5)) {
                    object = new String(byArray, n3 + 12, 4);
                    n6 = AviDemux.str2ulong(byArray, n3 + 28);
                    n5 = AviDemux.str2ulong(byArray, n3 + 32);
                    this.track[0] = new Video(this, n2++, (String)object, n6, n5);
                    this.streamVideoTag = ((Video)this.track[0]).getVideoTag();
                    n = 1;
                }
                if ("auds".equalsIgnoreCase(string5)) {
                    int n7 = AviDemux.str2ulong(byArray, n3 + 28);
                    n6 = AviDemux.str2ulong(byArray, n3 + 32);
                    n5 = AviDemux.str2ulong(byArray, n3 + 52);
                    this.track[1 + this.numberOfAudioChannels++] = new Audio(this, n2++, n7, n6, n5);
                    n = 2;
                }
            }
            if ("strf".equalsIgnoreCase(string4)) {
                if (n == 1) {
                    object = new byte[n4 - 4];
                    System.arraycopy(byArray, n3 + 4, object, 0, ((byte[])object).length);
                    this.track[0].setBih((byte[])object);
                }
                if (n == 2) {
                    object = new byte[n4 - 4];
                    System.arraycopy(byArray, n3 + 4, object, 0, ((byte[])object).length);
                    this.track[1 + this.numberOfAudioChannels - 1].setBih((byte[])object);
                }
            }
            n3 += n4 + 8;
        }
        this.endOfHeader = this.seekSource.tell();
    }

    public synchronized long readFrame(Buffer buffer, boolean bl, long l) throws IOException {
        boolean bl2;
        if (l < this.endOfHeader) {
            l = this.endOfHeader;
        }
        this.seekSource.seek(l);
        do {
            bl2 = this.getChunk(buffer);
            if ((buffer.getLength() & 1) != 1) continue;
            this.readBuffer(1);
        } while (bl2 != bl);
        return this.seekSource.tell();
    }

    private boolean getChunk(Buffer buffer) throws IOException {
        String string = new String(this.readBuffer(4), "ASCII").toUpperCase();
        int n = this.readBytes(4);
        while ("LIST".equals(string) || "RIFF".equals(string)) {
            this.readBuffer(4);
            string = new String(this.readBuffer(4), "ASCII").toUpperCase();
            n = this.readBytes(4);
        }
        String string2 = this.streamVideoTag.substring(0, 3);
        if (string.substring(0, 3).equalsIgnoreCase(string2) && (string.charAt(3) == 'B' || string.charAt(3) == 'C')) {
            buffer.setData((Object)this.readBuffer(n));
            buffer.setLength(n);
            return true;
        }
        int n2 = 0;
        if (n2 < this.numberOfAudioChannels) {
            buffer.setData((Object)this.readBuffer(n));
            buffer.setLength(n);
            return false;
        }
        throw new IOException("Not header " + string);
    }

    public static final int str2ulong(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    private final byte[] readBuffer(int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += n2) {
            n2 = this.dataSource.read(byArray, i, n - i);
            if (n2 >= 0) continue;
            throw new IOException("End of Stream");
        }
        return byArray;
    }

    private final int readByte() throws IOException {
        byte[] byArray = new byte[1];
        this.dataSource.read(byArray, 0, 1);
        return byArray[0];
    }

    private final int readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = this.dataSource.read(byArray, 0, n);
        if (n2 != byArray.length) {
            if (n2 < 0) {
                throw new IOException("End of Stream");
            }
            for (int i = n2; i < byArray.length; ++i) {
                byArray[i] = (byte)this.readByte();
            }
        }
        switch (n) {
            case 1: {
                return byArray[0] & 0xFF;
            }
            case 2: {
                return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
            }
            case 3: {
                return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16;
            }
            case 4: {
                return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
            }
        }
        throw new IOException("Illegal Read quantity");
    }

    public void stop() {
    }
}

