/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.loader.subparsers;

import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.data.chapter.conversation.Conversation;
import es.eucm.eadventure.common.data.chapter.conversation.GraphConversation;
import es.eucm.eadventure.common.data.chapter.conversation.TreeConversation;
import es.eucm.eadventure.common.data.chapter.conversation.line.ConversationLine;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.DialogueConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.OptionConversationNode;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import es.eucm.eadventure.common.loader.subparsers.EffectSubParser;
import es.eucm.eadventure.common.loader.subparsers.SubParser;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class TreeConversationSubParser
extends SubParser {
    private static final int SUBPARSING_NONE = 0;
    private static final int SUBPARSING_EFFECT = 1;
    private static final int STATE_NORMAL = 0;
    private static final int STATE_WAITING_OPTION = 1;
    private int subParsing = 0;
    private int state = 0;
    private Conversation conversation;
    private ConversationNode currentNode;
    private List<ConversationNode> pastOptionNodes;
    private Effects currentEffects;
    private SubParser effectSubParser;
    private String characterName;
    private String audioPath;
    private boolean random;
    private boolean keepShowing;
    private boolean showUserOption;
    private boolean preListening;
    private Boolean synthesizerVoice;

    public TreeConversationSubParser(Chapter chapter) {
        super(chapter);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.subParsing == 0) {
            if (string3.equals("tree-conversation")) {
                String string4 = "";
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("id")) continue;
                    string4 = attributes.getValue(i);
                }
                this.currentNode = new DialogueConversationNode();
                this.conversation = new TreeConversation(string4, this.currentNode);
                this.pastOptionNodes = new ArrayList<ConversationNode>();
            } else if (string3.equals("speak-char")) {
                this.characterName = "NPC";
                this.audioPath = "";
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("idTarget")) {
                        this.characterName = attributes.getValue(i);
                    }
                    if (attributes.getQName(i).equals("uri")) {
                        this.audioPath = attributes.getValue(i);
                    }
                    if (!attributes.getQName(i).equals("synthesize")) continue;
                    String string5 = attributes.getValue(i);
                    this.synthesizerVoice = string5.equals("yes") ? Boolean.valueOf(true) : Boolean.valueOf(false);
                }
            } else if (string3.equals("speak-player")) {
                this.audioPath = "";
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("uri")) {
                        this.audioPath = attributes.getValue(i);
                    }
                    if (!attributes.getQName(i).equals("synthesize")) continue;
                    String string6 = attributes.getValue(i);
                    this.synthesizerVoice = string6.equals("yes") ? Boolean.valueOf(true) : Boolean.valueOf(false);
                }
            } else if (string3.equals("response")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("random")) {
                        this.random = attributes.getValue(i).equals("yes");
                    }
                    if (attributes.getQName(i).equals("keepShowing")) {
                        this.keepShowing = attributes.getValue(i).equals("yes");
                    }
                    if (attributes.getQName(i).equals("showUserOption")) {
                        this.showUserOption = attributes.getValue(i).equals("yes");
                    }
                    if (!attributes.getQName(i).equals("preListening")) continue;
                    this.preListening = attributes.getValue(i).equals("yes");
                }
                OptionConversationNode optionConversationNode = new OptionConversationNode(this.random, this.keepShowing, this.showUserOption, this.preListening);
                this.currentNode.addChild(optionConversationNode);
                this.currentNode = optionConversationNode;
            } else if (string3.equals("option")) {
                this.state = 1;
            } else if (string3.equals("effect")) {
                this.currentEffects = new Effects();
                this.effectSubParser = new EffectSubParser(this.currentEffects, this.chapter);
                this.subParsing = 1;
            } else if (string3.equals("go-back")) {
                this.currentNode.addChild(this.pastOptionNodes.get(this.pastOptionNodes.size() - 1));
            }
        }
        if (this.subParsing == 1) {
            this.effectSubParser.startElement(string, string2, string3, attributes);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (this.subParsing == 0) {
            if (string3.equals("tree-conversation")) {
                this.chapter.addConversation(new GraphConversation((TreeConversation)this.conversation));
            } else if (string3.equals("speak-player")) {
                ConversationLine conversationLine = new ConversationLine("Player", new String(this.currentString).trim());
                if (this.audioPath != null && !this.audioPath.equals("")) {
                    conversationLine.setAudioPath(this.audioPath);
                }
                if (this.synthesizerVoice != null) {
                    conversationLine.setSynthesizerVoice(this.synthesizerVoice);
                }
                this.currentNode.addLine(conversationLine);
                if (this.state == 1) {
                    DialogueConversationNode dialogueConversationNode = new DialogueConversationNode();
                    this.currentNode.addChild(dialogueConversationNode);
                    this.pastOptionNodes.add(this.currentNode);
                    this.currentNode = dialogueConversationNode;
                    this.state = 0;
                }
            } else if (string3.equals("speak-char")) {
                ConversationLine conversationLine = new ConversationLine(this.characterName, new String(this.currentString).trim());
                if (this.audioPath != null && !this.audioPath.equals("")) {
                    conversationLine.setAudioPath(this.audioPath);
                }
                if (this.synthesizerVoice != null) {
                    conversationLine.setSynthesizerVoice(this.synthesizerVoice);
                }
                this.currentNode.addLine(conversationLine);
            } else if (string3.equals("option")) {
                this.currentNode = this.pastOptionNodes.remove(this.pastOptionNodes.size() - 1);
            }
            this.currentString = new StringBuffer();
        } else if (this.subParsing == 1) {
            this.effectSubParser.endElement(string, string2, string3);
            if (string3.equals("effect")) {
                this.currentNode.setEffects(this.currentEffects);
                this.subParsing = 0;
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.subParsing == 0) {
            super.characters(cArray, n, n2);
        } else if (this.subParsing == 1) {
            this.effectSubParser.characters(cArray, n, n2);
        }
    }
}

