/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.loader.subparsers;

import es.eucm.eadventure.common.data.animation.Animation;
import es.eucm.eadventure.common.data.animation.Frame;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.loader.subparsers.SubParser;
import org.xml.sax.Attributes;

public class FrameSubParser
extends SubParser {
    private Animation animation;
    private Frame frame;
    private Resources currentResources;

    public FrameSubParser(Animation animation) {
        super(null);
        this.animation = animation;
        this.frame = new Frame(animation.getImageLoaderFactory());
        animation.getFrames().add(this.frame);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        int n;
        if (string3.equals("frame")) {
            for (n = 0; n < attributes.getLength(); ++n) {
                if (attributes.getQName(n).equals("uri")) {
                    this.frame.setUri(attributes.getValue(n));
                }
                if (attributes.getQName(n).equals("type")) {
                    if (attributes.getValue(n).equals("image")) {
                        this.frame.setType(0);
                    }
                    if (attributes.getValue(n).equals("video")) {
                        this.frame.setType(1);
                    }
                }
                if (attributes.getQName(n).equals("time")) {
                    this.frame.setTime(Long.parseLong(attributes.getValue(n)));
                }
                if (attributes.getQName(n).equals("waitforclick")) {
                    this.frame.setWaitforclick(attributes.getValue(n).equals("yes"));
                }
                if (attributes.getQName(n).equals("soundUri")) {
                    this.frame.setSoundUri(attributes.getValue(n));
                }
                if (!attributes.getQName(n).equals("maxSoundTime")) continue;
                this.frame.setMaxSoundTime(Integer.parseInt(attributes.getValue(n)));
            }
        }
        if (string3.equals("resources")) {
            this.currentResources = new Resources();
            for (n = 0; n < attributes.getLength(); ++n) {
                if (!attributes.getQName(n).equals("name")) continue;
                this.currentResources.setName(attributes.getValue(n));
            }
        }
        if (string3.equals("asset")) {
            String string4 = "";
            String string5 = "";
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("type")) {
                    string4 = attributes.getValue(i);
                }
                if (!attributes.getQName(i).equals("uri")) continue;
                string5 = attributes.getValue(i);
            }
            this.currentResources.addAsset(string4, string5);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (string3.equals("resources")) {
            this.frame.addResources(this.currentResources);
        }
    }
}

