/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.loader.subparsers;

import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.effects.AbstractEffect;
import es.eucm.eadventure.common.data.chapter.effects.ActivateEffect;
import es.eucm.eadventure.common.data.chapter.effects.CancelActionEffect;
import es.eucm.eadventure.common.data.chapter.effects.ConsumeObjectEffect;
import es.eucm.eadventure.common.data.chapter.effects.DeactivateEffect;
import es.eucm.eadventure.common.data.chapter.effects.DecrementVarEffect;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import es.eucm.eadventure.common.data.chapter.effects.GenerateObjectEffect;
import es.eucm.eadventure.common.data.chapter.effects.HighlightItemEffect;
import es.eucm.eadventure.common.data.chapter.effects.IncrementVarEffect;
import es.eucm.eadventure.common.data.chapter.effects.MacroReferenceEffect;
import es.eucm.eadventure.common.data.chapter.effects.MoveNPCEffect;
import es.eucm.eadventure.common.data.chapter.effects.MoveObjectEffect;
import es.eucm.eadventure.common.data.chapter.effects.MovePlayerEffect;
import es.eucm.eadventure.common.data.chapter.effects.PlayAnimationEffect;
import es.eucm.eadventure.common.data.chapter.effects.PlaySoundEffect;
import es.eucm.eadventure.common.data.chapter.effects.RandomEffect;
import es.eucm.eadventure.common.data.chapter.effects.SetValueEffect;
import es.eucm.eadventure.common.data.chapter.effects.ShowTextEffect;
import es.eucm.eadventure.common.data.chapter.effects.SpeakCharEffect;
import es.eucm.eadventure.common.data.chapter.effects.SpeakPlayerEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerBookEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerConversationEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerCutsceneEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerLastSceneEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerSceneEffect;
import es.eucm.eadventure.common.data.chapter.effects.WaitTimeEffect;
import es.eucm.eadventure.common.loader.subparsers.ConditionSubParser;
import es.eucm.eadventure.common.loader.subparsers.SubParser;
import org.xml.sax.Attributes;

public class EffectSubParser
extends SubParser {
    private static final int SUBPARSING_NONE = 0;
    private static final int SUBPARSING_CONDITION = 1;
    private SubParser subParser;
    private int subParsing;
    private String currentCharIdTarget;
    private Effects effects;
    int x = 0;
    int y = 0;
    int frontColor = 0;
    int borderColor = 0;
    private boolean positiveBlockRead = false;
    private boolean readingRandomEffect = false;
    private RandomEffect randomEffect;
    private Conditions currentConditions;
    private AbstractEffect currentEffect;
    private AbstractEffect newEffect;

    public EffectSubParser(Effects effects, Chapter chapter) {
        super(chapter);
        this.effects = effects;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this.newEffect = null;
        if (string3.equals("cancel-action")) {
            this.newEffect = new CancelActionEffect();
        } else if (string3.equals("activate")) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals("flag")) continue;
                this.newEffect = new ActivateEffect(attributes.getValue(i));
                this.chapter.addFlag(attributes.getValue(i));
            }
        } else if (string3.equals("deactivate")) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals("flag")) continue;
                this.newEffect = new DeactivateEffect(attributes.getValue(i));
                this.chapter.addFlag(attributes.getValue(i));
            }
        } else if (string3.equals("set-value")) {
            String string4 = null;
            int n = 0;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("var")) {
                    string4 = attributes.getValue(i);
                    continue;
                }
                if (!attributes.getQName(i).equals("value")) continue;
                n = Integer.parseInt(attributes.getValue(i));
            }
            this.newEffect = new SetValueEffect(string4, n);
            this.chapter.addVar(string4);
        } else if (string3.equals("increment")) {
            String string5 = null;
            int n = 0;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("var")) {
                    string5 = attributes.getValue(i);
                    continue;
                }
                if (!attributes.getQName(i).equals("value")) continue;
                n = Integer.parseInt(attributes.getValue(i));
            }
            this.newEffect = new IncrementVarEffect(string5, n);
            this.chapter.addVar(string5);
        } else if (string3.equals("decrement")) {
            String string6 = null;
            int n = 0;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("var")) {
                    string6 = attributes.getValue(i);
                    continue;
                }
                if (!attributes.getQName(i).equals("value")) continue;
                n = Integer.parseInt(attributes.getValue(i));
            }
            this.newEffect = new DecrementVarEffect(string6, n);
            this.chapter.addVar(string6);
        } else if (string3.equals("macro-ref")) {
            String string7 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals("id")) continue;
                string7 = attributes.getValue(i);
            }
            this.newEffect = new MacroReferenceEffect(string7);
        } else if (string3.equals("consume-object")) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals("idTarget")) continue;
                this.newEffect = new ConsumeObjectEffect(attributes.getValue(i));
            }
        } else if (string3.equals("generate-object")) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals("idTarget")) continue;
                this.newEffect = new GenerateObjectEffect(attributes.getValue(i));
            }
        } else if (string3.equals("speak-char")) {
            this.currentCharIdTarget = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals("idTarget")) continue;
                this.currentCharIdTarget = attributes.getValue(i);
            }
        } else if (string3.equals("trigger-book")) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals("idTarget")) continue;
                this.newEffect = new TriggerBookEffect(attributes.getValue(i));
            }
        } else if (string3.equals("trigger-last-scene")) {
            this.newEffect = new TriggerLastSceneEffect();
        } else if (string3.equals("play-sound")) {
            String string8 = "";
            boolean bl = true;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("background")) {
                    bl = attributes.getValue(i).equals("yes");
                    continue;
                }
                if (!attributes.getQName(i).equals("uri")) continue;
                string8 = attributes.getValue(i);
            }
            this.newEffect = new PlaySoundEffect(bl, string8);
        } else if (string3.equals("trigger-conversation")) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals("idTarget")) continue;
                this.newEffect = new TriggerConversationEffect(attributes.getValue(i));
            }
        } else if (string3.equals("trigger-cutscene")) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals("idTarget")) continue;
                this.newEffect = new TriggerCutsceneEffect(attributes.getValue(i));
            }
        } else if (string3.equals("trigger-scene")) {
            String string9 = "";
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("idTarget")) {
                    string9 = attributes.getValue(i);
                    continue;
                }
                if (attributes.getQName(i).equals("x")) {
                    n = Integer.parseInt(attributes.getValue(i));
                    continue;
                }
                if (!attributes.getQName(i).equals("y")) continue;
                n2 = Integer.parseInt(attributes.getValue(i));
            }
            this.newEffect = new TriggerSceneEffect(string9, n, n2);
        } else if (string3.equals("play-animation")) {
            String string10 = "";
            int n = 0;
            int n3 = 0;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("uri")) {
                    string10 = attributes.getValue(i);
                    continue;
                }
                if (attributes.getQName(i).equals("x")) {
                    n = Integer.parseInt(attributes.getValue(i));
                    continue;
                }
                if (!attributes.getQName(i).equals("y")) continue;
                n3 = Integer.parseInt(attributes.getValue(i));
            }
            this.newEffect = new PlayAnimationEffect(string10, n, n3);
        } else if (string3.equals("move-player")) {
            int n = 0;
            int n4 = 0;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("x")) {
                    n = Integer.parseInt(attributes.getValue(i));
                    continue;
                }
                if (!attributes.getQName(i).equals("y")) continue;
                n4 = Integer.parseInt(attributes.getValue(i));
            }
            this.newEffect = new MovePlayerEffect(n, n4);
        } else if (string3.equals("move-npc")) {
            String string11 = "";
            int n = 0;
            int n5 = 0;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("idTarget")) {
                    string11 = attributes.getValue(i);
                    continue;
                }
                if (attributes.getQName(i).equals("x")) {
                    n = Integer.parseInt(attributes.getValue(i));
                    continue;
                }
                if (!attributes.getQName(i).equals("y")) continue;
                n5 = Integer.parseInt(attributes.getValue(i));
            }
            this.newEffect = new MoveNPCEffect(string11, n, n5);
        } else if (string3.equals("random-effect")) {
            int n = 0;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals("probability")) continue;
                n = Integer.parseInt(attributes.getValue(i));
            }
            this.randomEffect = new RandomEffect(n);
            this.newEffect = this.randomEffect;
            this.readingRandomEffect = true;
            this.positiveBlockRead = false;
        } else if (string3.equals("wait-time")) {
            int n = 0;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals("time")) continue;
                n = Integer.parseInt(attributes.getValue(i));
            }
            this.newEffect = new WaitTimeEffect(n);
        } else if (string3.equals("show-text")) {
            this.x = 0;
            this.y = 0;
            this.frontColor = 0;
            this.borderColor = 0;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("x")) {
                    this.x = Integer.parseInt(attributes.getValue(i));
                    continue;
                }
                if (attributes.getQName(i).equals("y")) {
                    this.y = Integer.parseInt(attributes.getValue(i));
                    continue;
                }
                if (attributes.getQName(i).equals("frontColor")) {
                    this.frontColor = Integer.parseInt(attributes.getValue(i));
                    continue;
                }
                if (!attributes.getQName(i).equals("borderColor")) continue;
                this.borderColor = Integer.parseInt(attributes.getValue(i));
            }
        } else if (string3.equals("highlight-item")) {
            int n = 0;
            boolean bl = false;
            String string12 = "";
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("idTarget")) {
                    string12 = attributes.getValue(i);
                }
                if (attributes.getQName(i).equals("animated")) {
                    boolean bl2 = bl = attributes.getValue(i).equals("yes");
                }
                if (!attributes.getQName(i).equals("type")) continue;
                if (attributes.getValue(i).equals("none")) {
                    n = 0;
                }
                if (attributes.getValue(i).equals("green")) {
                    n = 3;
                }
                if (attributes.getValue(i).equals("red")) {
                    n = 2;
                }
                if (attributes.getValue(i).equals("blue")) {
                    n = 1;
                }
                if (!attributes.getValue(i).equals("border")) continue;
                n = 4;
            }
            this.newEffect = new HighlightItemEffect(string12, n, bl);
        } else if (string3.equals("move-object")) {
            boolean bl = false;
            String string13 = "";
            int n = 0;
            int n6 = 0;
            float f = 1.0f;
            int n7 = 20;
            int n8 = 20;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("idTarget")) {
                    string13 = attributes.getValue(i);
                }
                if (attributes.getQName(i).equals("animated")) {
                    boolean bl3 = bl = attributes.getValue(i).equals("yes");
                }
                if (attributes.getQName(i).equals("x")) {
                    n = Integer.parseInt(attributes.getValue(i));
                }
                if (attributes.getQName(i).equals("y")) {
                    n6 = Integer.parseInt(attributes.getValue(i));
                }
                if (attributes.getQName(i).equals("scale")) {
                    f = Float.parseFloat(attributes.getValue(i));
                }
                if (attributes.getQName(i).equals("translateSpeed")) {
                    n7 = Integer.parseInt(attributes.getValue(i));
                }
                if (!attributes.getQName(i).equals("scaleSpeed")) continue;
                n8 = Integer.parseInt(attributes.getValue(i));
            }
            this.newEffect = new MoveObjectEffect(string13, n, n6, f, bl, n7, n8);
        } else if (string3.equals("condition")) {
            this.currentConditions = new Conditions();
            this.subParser = new ConditionSubParser(this.currentConditions, this.chapter);
            this.subParsing = 1;
        }
        if (!this.readingRandomEffect && this.newEffect != null) {
            this.effects.add(this.newEffect);
            this.currentEffect = this.newEffect;
        }
        if (this.readingRandomEffect) {
            if (this.newEffect != null && this.newEffect == this.randomEffect) {
                this.effects.add(this.newEffect);
            } else if (this.newEffect != null && !this.positiveBlockRead) {
                this.randomEffect.setPositiveEffect(this.newEffect);
                this.positiveBlockRead = true;
            } else if (this.newEffect != null && this.positiveBlockRead) {
                this.randomEffect.setNegativeEffect(this.newEffect);
                this.positiveBlockRead = false;
                this.readingRandomEffect = false;
                this.newEffect = this.randomEffect;
                this.randomEffect = null;
            }
            this.currentEffect = this.newEffect;
        }
        if (this.subParsing != 0) {
            this.subParser.startElement(string, string2, string3, attributes);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (this.subParsing == 0) {
            this.newEffect = null;
            if (string3.equals("speak-player")) {
                this.newEffect = new SpeakPlayerEffect(this.currentString.toString().trim());
            } else if (string3.equals("speak-char")) {
                this.newEffect = new SpeakCharEffect(this.currentCharIdTarget, this.currentString.toString().trim());
            } else if (string3.equals("show-text")) {
                this.newEffect = new ShowTextEffect(this.currentString.toString().trim(), this.x, this.y, this.frontColor, this.borderColor);
            }
            if (!this.readingRandomEffect && this.newEffect != null) {
                this.effects.add(this.newEffect);
                this.currentEffect = this.newEffect;
            }
            if (this.readingRandomEffect) {
                if (this.newEffect != null && this.newEffect == this.randomEffect) {
                    this.effects.add(this.newEffect);
                } else if (this.newEffect != null && !this.positiveBlockRead) {
                    this.randomEffect.setPositiveEffect(this.newEffect);
                    this.positiveBlockRead = true;
                } else if (this.newEffect != null && this.positiveBlockRead) {
                    this.randomEffect.setNegativeEffect(this.newEffect);
                    this.positiveBlockRead = false;
                    this.readingRandomEffect = false;
                    this.newEffect = this.randomEffect;
                    this.randomEffect = null;
                }
                this.currentEffect = this.newEffect;
            }
            this.currentString = new StringBuffer();
        } else if (this.subParsing == 1) {
            this.subParser.endElement(string, string2, string3);
            if (string3.equals("condition")) {
                this.currentEffect.setConditions(this.currentConditions);
                this.subParsing = 0;
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.subParsing == 0) {
            super.characters(cArray, n, n2);
        } else {
            this.subParser.characters(cArray, n, n2);
        }
    }
}

