/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.loader.subparsers;

import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.data.chapter.NextScene;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.effects.AbstractEffect;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.data.chapter.scenes.Cutscene;
import es.eucm.eadventure.common.data.chapter.scenes.Slidescene;
import es.eucm.eadventure.common.data.chapter.scenes.Videoscene;
import es.eucm.eadventure.common.loader.subparsers.ConditionSubParser;
import es.eucm.eadventure.common.loader.subparsers.EffectSubParser;
import es.eucm.eadventure.common.loader.subparsers.SubParser;
import org.xml.sax.Attributes;

public class CutsceneSubParser
extends SubParser {
    private static final int READING_NONE = 0;
    private static final int READING_RESOURCES = 1;
    private static final int READING_NEXT_SCENE = 2;
    private static final int SUBPARSING_NONE = 0;
    private static final int SUBPARSING_CONDITION = 1;
    private static final int SUBPARSING_EFFECT = 2;
    private int reading = 0;
    private int subParsing = 0;
    private Cutscene cutscene;
    private Resources currentResources;
    private NextScene currentNextScene;
    private Conditions currentConditions;
    private Effects currentEffects;
    private SubParser subParser;

    public CutsceneSubParser(Chapter chapter) {
        super(chapter);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.subParsing == 0) {
            if (string3.equals("slidescene") || string3.equals("videoscene")) {
                String string4 = "";
                boolean bl = false;
                String string5 = "";
                int n = Integer.MIN_VALUE;
                int n2 = Integer.MIN_VALUE;
                int n3 = 0;
                int n4 = 0;
                String string6 = "go-back";
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("id")) {
                        string4 = attributes.getValue(i);
                    }
                    if (attributes.getQName(i).equals("start")) {
                        bl = attributes.getValue(i).equals("yes");
                    }
                    if (attributes.getQName(i).equals("idTarget")) {
                        string5 = attributes.getValue(i);
                    }
                    if (attributes.getQName(i).equals("destinyX")) {
                        n = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("destinyY")) {
                        n2 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("transitionType")) {
                        n3 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("transitionTime")) {
                        n4 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (!attributes.getQName(i).equals("next")) continue;
                    string6 = attributes.getValue(i);
                }
                this.cutscene = string3.equals("slidescene") ? new Slidescene(string4) : new Videoscene(string4);
                if (bl) {
                    this.chapter.setTargetId(string4);
                }
                this.cutscene.setTargetId(string5);
                this.cutscene.setPositionX(n);
                this.cutscene.setPositionY(n2);
                this.cutscene.setTransitionType(n3);
                this.cutscene.setTransitionTime(n4);
                if (string6.equals("go-back")) {
                    this.cutscene.setNext(0);
                } else if (string6.equals("new-scene")) {
                    this.cutscene.setNext(2);
                } else if (string6.equals("end-chapter")) {
                    this.cutscene.setNext(1);
                }
            } else if (string3.equals("resources")) {
                this.currentResources = new Resources();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("name")) continue;
                    this.currentResources.setName(attributes.getValue(i));
                }
                this.reading = 1;
            } else if (string3.equals("asset")) {
                String string7 = "";
                String string8 = "";
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("type")) {
                        string7 = attributes.getValue(i);
                    }
                    if (!attributes.getQName(i).equals("uri")) continue;
                    string8 = attributes.getValue(i);
                }
                this.currentResources.addAsset(string7, string8);
            } else if (string3.equals("end-game")) {
                this.cutscene.setNext(1);
            } else if (string3.equals("next-scene")) {
                String string9 = "";
                int n = Integer.MIN_VALUE;
                int n5 = Integer.MIN_VALUE;
                int n6 = 0;
                int n7 = 0;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("idTarget")) {
                        string9 = attributes.getValue(i);
                    }
                    if (attributes.getQName(i).equals("x")) {
                        n = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("y")) {
                        n5 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("transitionType")) {
                        n6 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (!attributes.getQName(i).equals("transitionTime")) continue;
                    n7 = Integer.parseInt(attributes.getValue(i));
                }
                this.currentNextScene = new NextScene(string9, n, n5);
                this.currentNextScene.setTransitionType(n6);
                this.currentNextScene.setTransitionTime(n7);
                this.reading = 2;
            } else if (string3.equals("condition")) {
                this.currentConditions = new Conditions();
                this.subParser = new ConditionSubParser(this.currentConditions, this.chapter);
                this.subParsing = 1;
            } else if (string3.equals("effect")) {
                this.currentEffects = new Effects();
                this.subParser = new EffectSubParser(this.currentEffects, this.chapter);
                this.subParsing = 2;
            } else if (string3.equals("post-effect")) {
                this.currentEffects = new Effects();
                this.subParser = new EffectSubParser(this.currentEffects, this.chapter);
                this.subParsing = 2;
            }
        }
        if (this.subParsing != 0) {
            this.subParser.startElement(string, string2, string3, attributes);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (this.subParsing == 0) {
            if (string3.equals("slidescene") || string3.equals("videoscene")) {
                this.chapter.addCutscene(this.cutscene);
            } else if (string3.equals("resources")) {
                this.cutscene.addResources(this.currentResources);
                this.reading = 0;
            } else if (string3.equals("name")) {
                this.cutscene.setName(this.currentString.toString().trim());
            } else if (string3.equals("documentation")) {
                this.cutscene.setDocumentation(this.currentString.toString().trim());
            } else if (string3.equals("next-scene")) {
                this.cutscene.addNextScene(this.currentNextScene);
                this.reading = 0;
            }
            this.currentString = new StringBuffer();
        } else if (this.subParsing == 1) {
            this.subParser.endElement(string, string2, string3);
            if (string3.equals("condition")) {
                if (this.reading == 1) {
                    this.currentResources.setConditions(this.currentConditions);
                }
                if (this.reading == 2) {
                    this.currentNextScene.setConditions(this.currentConditions);
                }
                this.subParsing = 0;
            }
        } else if (this.subParsing == 2) {
            Effects effects;
            this.subParser.endElement(string, string2, string3);
            if (string3.equals("effect")) {
                if (this.currentNextScene != null) {
                    this.currentNextScene.setEffects(this.currentEffects);
                } else {
                    effects = this.cutscene.getEffects();
                    for (AbstractEffect abstractEffect : this.currentEffects.getEffects()) {
                        effects.add(abstractEffect);
                    }
                }
                this.subParsing = 0;
            }
            if (string3.equals("post-effect")) {
                if (this.currentNextScene != null) {
                    this.currentNextScene.setPostEffects(this.currentEffects);
                } else {
                    effects = this.cutscene.getEffects();
                    for (AbstractEffect abstractEffect : this.currentEffects.getEffects()) {
                        effects.add(abstractEffect);
                    }
                }
                this.subParsing = 0;
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.subParsing == 0) {
            super.characters(cArray, n, n2);
        } else {
            this.subParser.characters(cArray, n, n2);
        }
    }
}

