/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.loader.subparsers;

import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.elements.Barrier;
import es.eucm.eadventure.common.data.chapter.scenes.Scene;
import es.eucm.eadventure.common.loader.subparsers.ConditionSubParser;
import es.eucm.eadventure.common.loader.subparsers.SubParser;
import org.xml.sax.Attributes;

public class BarrierSubParser
extends SubParser {
    private static final int READING_NONE = 0;
    private static final int SUBPARSING_NONE = 0;
    private static final int SUBPARSING_CONDITION = 1;
    private int reading = 0;
    private int subParsing = 0;
    private Barrier barrier;
    private Conditions currentConditions;
    private SubParser subParser;
    private Scene scene;
    private int nBarriers;

    public BarrierSubParser(Chapter chapter, Scene scene, int n) {
        super(chapter);
        this.nBarriers = n;
        this.scene = scene;
    }

    private String generateId() {
        return Integer.toString(this.nBarriers + 1);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.subParsing == 0) {
            if (string3.equals("barrier")) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("x")) {
                        n = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("y")) {
                        n2 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("width")) {
                        n3 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (!attributes.getQName(i).equals("height")) continue;
                    n4 = Integer.parseInt(attributes.getValue(i));
                }
                this.barrier = new Barrier(this.generateId(), n, n2, n3, n4);
            } else if (string3.equals("condition")) {
                this.currentConditions = new Conditions();
                this.subParser = new ConditionSubParser(this.currentConditions, this.chapter);
                this.subParsing = 1;
            }
        }
        if (this.subParsing != 0) {
            this.subParser.startElement(string, string2, string3, attributes);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (this.subParsing == 0) {
            if (string3.equals("barrier")) {
                this.scene.addBarrier(this.barrier);
            } else if (string3.equals("name")) {
                this.barrier.setName(this.currentString.toString().trim());
            } else if (string3.equals("documentation")) {
                if (this.reading == 0) {
                    this.barrier.setDocumentation(this.currentString.toString().trim());
                }
            } else if (string3.equals("brief")) {
                this.barrier.setDescription(this.currentString.toString().trim());
            } else if (string3.equals("detailed")) {
                this.barrier.setDetailedDescription(this.currentString.toString().trim());
            }
            this.currentString = new StringBuffer();
        } else if (this.subParsing == 1) {
            this.subParser.endElement(string, string2, string3);
            if (string3.equals("condition")) {
                if (this.reading == 0) {
                    this.barrier.setConditions(this.currentConditions);
                }
                this.subParsing = 0;
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.subParsing == 0) {
            super.characters(cArray, n, n2);
        } else {
            this.subParser.characters(cArray, n, n2);
        }
    }
}

