/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.loader.subparsers;

import es.eucm.eadventure.common.data.adaptation.AdaptationProfile;
import es.eucm.eadventure.common.data.adaptation.AdaptationRule;
import es.eucm.eadventure.common.data.adaptation.AdaptedState;
import es.eucm.eadventure.common.data.adaptation.UOLProperty;
import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.loader.subparsers.SubParser;
import java.util.List;
import org.xml.sax.Attributes;

public class AdaptationSubParser
extends SubParser {
    private static final int NONE = 0;
    private static final int INITIAL_STATE = 1;
    private static final int ADAPTATION_RULE = 2;
    private int parsing = 0;
    private AdaptedState initialState;
    private List<AdaptationRule> externalRules;
    private AdaptationRule rule_temp;
    private StringBuffer currentString;
    private AdaptationProfile profile = new AdaptationProfile();

    public AdaptationSubParser(Chapter chapter) {
        super(chapter);
        this.currentString = new StringBuffer();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        int n;
        if (string3.equals("adaptation")) {
            for (n = 0; n < attributes.getLength(); ++n) {
                if (attributes.getQName(n).equals("scorm12")) {
                    this.profile.setScorm12(attributes.getValue(n).equals("yes"));
                }
                if (attributes.getQName(n).equals("scorm2004")) {
                    this.profile.setScorm2004(attributes.getValue(n).equals("yes"));
                }
                if (!attributes.getQName(n).equals("name")) continue;
                this.profile.setName(attributes.getValue(n));
            }
        }
        if (string3.equals("initial-state")) {
            this.parsing = 1;
            this.initialState = new AdaptedState();
        } else if (string3.equals("adaptation-rule")) {
            this.parsing = 2;
            this.rule_temp = new AdaptationRule();
        } else if (string3.equals("initial-scene")) {
            for (n = 0; n < attributes.getLength(); ++n) {
                if (!attributes.getQName(n).equals("idTarget")) continue;
                if (this.parsing == 1) {
                    this.initialState.setTargetId(attributes.getValue(n));
                    continue;
                }
                this.rule_temp.setInitialScene(attributes.getValue(n));
            }
        } else if (string3.equals("activate")) {
            for (n = 0; n < attributes.getLength(); ++n) {
                if (!attributes.getQName(n).equals("flag")) continue;
                if (this.parsing == 1) {
                    this.initialState.addActivatedFlag(attributes.getValue(n));
                } else {
                    this.rule_temp.addActivatedFlag(attributes.getValue(n));
                }
                this.profile.addFlag(attributes.getValue(n));
            }
        } else if (string3.equals("deactivate")) {
            for (n = 0; n < attributes.getLength(); ++n) {
                if (!attributes.getQName(n).equals("flag")) continue;
                if (this.parsing == 1) {
                    this.initialState.addDeactivatedFlag(attributes.getValue(n));
                } else {
                    this.rule_temp.addDeactivatedFlag(attributes.getValue(n));
                }
                this.profile.addFlag(attributes.getValue(n));
            }
        } else if (string3.equals("set-value")) {
            String string4 = null;
            String string5 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("var")) {
                    string4 = attributes.getValue(i);
                    continue;
                }
                if (!attributes.getQName(i).equals("value")) continue;
                string5 = attributes.getValue(i);
            }
            if (this.parsing == 1) {
                this.initialState.addVarValue(string4, "set-value " + string5);
            } else {
                this.rule_temp.addVarValue(string4, "set-value " + string5);
            }
            this.profile.addVar(string4);
        } else if (string3.equals("increment")) {
            String string6 = null;
            String string7 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("var")) {
                    string6 = attributes.getValue(i);
                    continue;
                }
                if (!attributes.getQName(i).equals("value")) continue;
                string7 = attributes.getValue(i);
            }
            if (this.parsing == 1) {
                this.initialState.addVarValue(string6, "increment " + string7);
            } else {
                this.rule_temp.addVarValue(string6, "increment " + string7);
            }
            this.profile.addVar(string6);
        } else if (string3.equals("decrement")) {
            String string8 = null;
            String string9 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("var")) {
                    string8 = attributes.getValue(i);
                    continue;
                }
                if (!attributes.getQName(i).equals("value")) continue;
                string9 = attributes.getValue(i);
            }
            if (this.parsing == 1) {
                this.initialState.addVarValue(string8, "decrement " + string9);
            } else {
                this.rule_temp.addVarValue(string8, "decrement " + string9);
            }
            this.profile.addVar(string8);
        } else if (string3.equals("property")) {
            String string10 = null;
            String string11 = null;
            String string12 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equals("id")) {
                    string10 = attributes.getValue(i);
                    continue;
                }
                if (attributes.getQName(i).equals("value")) {
                    string11 = attributes.getValue(i);
                    continue;
                }
                if (!attributes.getQName(i).equals("operation")) continue;
                string12 = attributes.getValue(i);
            }
            this.rule_temp.addUOLProperty(new UOLProperty(string10, string11, string12));
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (string3.equals("adaptation")) {
            this.chapter.addAdaptationProfile(this.profile);
        } else if (string3.equals("initial-state")) {
            this.parsing = 0;
            this.profile.setInitialState(this.initialState);
        } else if (string3.equals("ruleDescription")) {
            this.rule_temp.setDescription(this.currentString.toString().trim());
        } else if (string3.equals("adaptation-rule")) {
            this.parsing = 0;
            this.profile.addRule(this.rule_temp);
        }
        this.currentString = new StringBuffer();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        this.currentString.append(new String(cArray, n, n2));
    }
}

