/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.loader.subparsers;

import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.data.chapter.InfluenceArea;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import es.eucm.eadventure.common.data.chapter.elements.ActiveArea;
import es.eucm.eadventure.common.data.chapter.scenes.Scene;
import es.eucm.eadventure.common.loader.subparsers.ActionsSubParser;
import es.eucm.eadventure.common.loader.subparsers.ConditionSubParser;
import es.eucm.eadventure.common.loader.subparsers.EffectSubParser;
import es.eucm.eadventure.common.loader.subparsers.SubParser;
import java.awt.Point;
import org.xml.sax.Attributes;

public class ActiveAreaSubParser
extends SubParser {
    private static final int READING_NONE = 0;
    private static final int SUBPARSING_NONE = 0;
    private static final int SUBPARSING_CONDITION = 1;
    private static final int SUBPARSING_EFFECT = 2;
    private static final int SUBPARSING_ACTIONS = 3;
    private int reading = 0;
    private int subParsing = 0;
    private ActiveArea activeArea;
    private Conditions currentConditions;
    private Effects currentEffects;
    private SubParser subParser;
    private Scene scene;
    private int nAreas;

    public ActiveAreaSubParser(Chapter chapter, Scene scene, int n) {
        super(chapter);
        this.nAreas = n;
        this.scene = scene;
    }

    private String generateId() {
        return "area" + Integer.toString(this.nAreas + 1) + "scene" + this.scene.getId();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.subParsing == 0) {
            if (string3.equals("active-area")) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                String string4 = null;
                boolean bl = false;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                boolean bl2 = false;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("rectangular")) {
                        bl = attributes.getValue(i).equals("yes");
                    }
                    if (attributes.getQName(i).equals("x")) {
                        n = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("y")) {
                        n2 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("width")) {
                        n3 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("height")) {
                        n4 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("id")) {
                        string4 = attributes.getValue(i);
                    }
                    if (attributes.getQName(i).equals("hasInfluenceArea")) {
                        bl2 = attributes.getValue(i).equals("yes");
                    }
                    if (attributes.getQName(i).equals("influenceX")) {
                        n5 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("influenceY")) {
                        n6 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("influenceWidth")) {
                        n7 = Integer.parseInt(attributes.getValue(i));
                    }
                    if (!attributes.getQName(i).equals("influenceHeight")) continue;
                    n8 = Integer.parseInt(attributes.getValue(i));
                }
                this.activeArea = new ActiveArea(string4 == null ? this.generateId() : string4, bl, n, n2, n3, n4);
                if (bl2) {
                    InfluenceArea influenceArea = new InfluenceArea(n5, n6, n7, n8);
                    this.activeArea.setInfluenceArea(influenceArea);
                }
            } else if (string3.equals("point")) {
                if (this.activeArea != null) {
                    int n = 0;
                    int n9 = 0;
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        if (attributes.getQName(i).equals("x")) {
                            n = Integer.parseInt(attributes.getValue(i));
                        }
                        if (!attributes.getQName(i).equals("y")) continue;
                        n9 = Integer.parseInt(attributes.getValue(i));
                    }
                    Point point = new Point(n, n9);
                    this.activeArea.addPoint(point);
                }
            } else if (string3.equals("actions")) {
                this.subParser = new ActionsSubParser(this.chapter, this.activeArea);
                this.subParsing = 3;
            } else if (string3.equals("condition")) {
                this.currentConditions = new Conditions();
                this.subParser = new ConditionSubParser(this.currentConditions, this.chapter);
                this.subParsing = 1;
            } else if (string3.equals("effect")) {
                this.subParser = new EffectSubParser(this.currentEffects, this.chapter);
                this.subParsing = 2;
            }
        }
        if (this.subParsing != 0) {
            this.subParser.startElement(string, string2, string3, attributes);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (this.subParsing == 0) {
            if (string3.equals("active-area")) {
                this.scene.addActiveArea(this.activeArea);
            } else if (string3.equals("name")) {
                this.activeArea.setName(this.currentString.toString().trim());
            } else if (string3.equals("documentation")) {
                this.activeArea.setDocumentation(this.currentString.toString().trim());
            } else if (string3.equals("brief")) {
                this.activeArea.setDescription(this.currentString.toString().trim());
            } else if (string3.equals("detailed")) {
                this.activeArea.setDetailedDescription(this.currentString.toString().trim());
            }
            this.currentString = new StringBuffer();
        } else if (this.subParsing == 1) {
            this.subParser.endElement(string, string2, string3);
            if (string3.equals("condition")) {
                if (this.reading == 0) {
                    this.activeArea.setConditions(this.currentConditions);
                }
                this.subParsing = 0;
            }
        } else if (this.subParsing == 2) {
            this.subParser.endElement(string, string2, string3);
            if (string3.equals("effect")) {
                this.subParsing = 0;
            }
        } else if (this.subParsing == 3) {
            this.subParser.endElement(string, string2, string3);
            if (string3.equals("actions")) {
                this.subParsing = 0;
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.subParsing == 0) {
            super.characters(cArray, n, n2);
        } else {
            this.subParser.characters(cArray, n, n2);
        }
    }
}

