/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.loader.subparsers;

import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.data.chapter.CustomAction;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import es.eucm.eadventure.common.data.chapter.elements.Element;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.loader.subparsers.ConditionSubParser;
import es.eucm.eadventure.common.loader.subparsers.EffectSubParser;
import es.eucm.eadventure.common.loader.subparsers.SubParser;
import org.xml.sax.Attributes;

public class ActionsSubParser
extends SubParser {
    private int subParsing;
    private int reading;
    private Conditions currentConditions;
    private Effects currentEffects;
    private Effects currentNotEffects;
    private Effects currentClickEffects;
    private String currentDocumentation;
    private String currentIdTarget;
    private String currentName;
    private boolean currentNeedsGoTo;
    private int currentKeepDistance;
    private CustomAction currentCustomAction;
    private Resources currentResources;
    private SubParser subParser;
    private static final int SUBPARSING_NONE = 0;
    private static final int READING_NONE = 0;
    private static final int READING_ACTION = 1;
    private static final int READING_RESOURCES = 2;
    private static final int SUBPARSING_CONDITION = 1;
    private static final int SUBPARSING_EFFECT = 2;
    private Element element;
    boolean activateNotEffects;
    boolean activateClickEffects;

    public ActionsSubParser(Chapter chapter, Element element) {
        super(chapter);
        this.element = element;
        this.subParsing = 0;
        this.reading = 0;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.subParsing == 0) {
            if (string3.equals("examine") || string3.equals("grab") || string3.equals("use") || string3.equals("talk-to")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("needsGoTo")) {
                        this.currentNeedsGoTo = attributes.getValue(i).equals("yes");
                    }
                    if (attributes.getQName(i).equals("keepDistance")) {
                        this.currentKeepDistance = Integer.parseInt(attributes.getValue(i));
                    }
                    if (!attributes.getQName(i).equals("not-effects")) continue;
                    this.activateNotEffects = attributes.getValue(i).equals("yes");
                }
                this.currentConditions = new Conditions();
                this.currentEffects = new Effects();
                this.currentNotEffects = new Effects();
                this.currentClickEffects = new Effects();
                this.currentDocumentation = null;
                this.reading = 1;
            } else if (string3.equals("use-with") || string3.equals("give-to") || string3.equals("drag-to")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("idTarget")) {
                        this.currentIdTarget = attributes.getValue(i);
                    }
                    if (attributes.getQName(i).equals("needsGoTo")) {
                        this.currentNeedsGoTo = attributes.getValue(i).equals("yes");
                    }
                    if (attributes.getQName(i).equals("keepDistance")) {
                        this.currentKeepDistance = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("not-effects")) {
                        this.activateNotEffects = attributes.getValue(i).equals("yes");
                    }
                    if (!attributes.getQName(i).equals("click-effects")) continue;
                    this.activateClickEffects = attributes.getValue(i).equals("yes");
                }
                this.currentConditions = new Conditions();
                this.currentEffects = new Effects();
                this.currentNotEffects = new Effects();
                this.currentClickEffects = new Effects();
                this.currentDocumentation = null;
                this.reading = 1;
            } else if (string3.equals("custom") || string3.equals("custom-interact")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("idTarget")) {
                        this.currentIdTarget = attributes.getValue(i);
                    }
                    if (attributes.getQName(i).equals("name")) {
                        this.currentName = attributes.getValue(i);
                    }
                    if (attributes.getQName(i).equals("needsGoTo")) {
                        this.currentNeedsGoTo = attributes.getValue(i).equals("yes");
                    }
                    if (attributes.getQName(i).equals("keepDistance")) {
                        this.currentKeepDistance = Integer.parseInt(attributes.getValue(i));
                    }
                    if (attributes.getQName(i).equals("not-effects")) {
                        this.activateNotEffects = attributes.getValue(i).equals("yes");
                    }
                    if (!attributes.getQName(i).equals("click-effects")) continue;
                    this.activateClickEffects = attributes.getValue(i).equals("yes");
                }
                this.currentConditions = new Conditions();
                this.currentEffects = new Effects();
                this.currentNotEffects = new Effects();
                this.currentClickEffects = new Effects();
                this.currentDocumentation = null;
                this.currentCustomAction = string3.equals("custom") ? new CustomAction(5) : new CustomAction(6);
                this.reading = 1;
            } else if (string3.equals("resources")) {
                this.currentResources = new Resources();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("name")) continue;
                    this.currentResources.setName(attributes.getValue(i));
                }
                this.reading = 2;
            } else if (string3.equals("asset")) {
                String string4 = "";
                String string5 = "";
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("type")) {
                        string4 = attributes.getValue(i);
                    }
                    if (!attributes.getQName(i).equals("uri")) continue;
                    string5 = attributes.getValue(i);
                }
                this.currentResources.addAsset(string4, string5);
            } else if (string3.equals("condition")) {
                this.currentConditions = new Conditions();
                this.subParser = new ConditionSubParser(this.currentConditions, this.chapter);
                this.subParsing = 1;
            } else if (string3.equals("effect")) {
                this.subParser = new EffectSubParser(this.currentEffects, this.chapter);
                this.subParsing = 2;
            } else if (string3.equals("not-effect")) {
                this.subParser = new EffectSubParser(this.currentNotEffects, this.chapter);
                this.subParsing = 2;
            } else if (string3.equals("click-effect")) {
                this.subParser = new EffectSubParser(this.currentClickEffects, this.chapter);
                this.subParsing = 2;
            }
        }
        if (this.subParsing != 0) {
            this.subParser.startElement(string, string2, string3, attributes);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (this.subParsing == 0) {
            if (string3.equals("resources")) {
                if (this.reading == 2) {
                    this.currentCustomAction.addResources(this.currentResources);
                    this.reading = 0;
                }
            } else if (string3.equals("documentation")) {
                this.currentDocumentation = this.currentString.toString().trim();
            } else if (string3.equals("examine")) {
                Action action = new Action(0, this.currentConditions, this.currentEffects, this.currentNotEffects);
                action.setDocumentation(this.currentDocumentation);
                action.setKeepDistance(this.currentKeepDistance);
                action.setNeedsGoTo(this.currentNeedsGoTo);
                action.setActivatedNotEffects(this.activateNotEffects);
                action.setActivatedClickEffects(this.activateClickEffects);
                this.element.addAction(action);
                this.reading = 0;
            } else if (string3.equals("grab")) {
                Action action = new Action(1, this.currentConditions, this.currentEffects, this.currentNotEffects);
                action.setDocumentation(this.currentDocumentation);
                action.setKeepDistance(this.currentKeepDistance);
                action.setNeedsGoTo(this.currentNeedsGoTo);
                action.setActivatedNotEffects(this.activateNotEffects);
                action.setActivatedClickEffects(this.activateClickEffects);
                this.element.addAction(action);
                this.reading = 0;
            } else if (string3.equals("use")) {
                Action action = new Action(4, this.currentConditions, this.currentEffects, this.currentNotEffects);
                action.setDocumentation(this.currentDocumentation);
                action.setNeedsGoTo(this.currentNeedsGoTo);
                action.setKeepDistance(this.currentKeepDistance);
                action.setActivatedNotEffects(this.activateNotEffects);
                action.setActivatedClickEffects(this.activateClickEffects);
                this.element.addAction(action);
                this.reading = 0;
            } else if (string3.equals("talk-to")) {
                Action action = new Action(7, this.currentConditions, this.currentEffects, this.currentNotEffects);
                action.setDocumentation(this.currentDocumentation);
                action.setNeedsGoTo(this.currentNeedsGoTo);
                action.setKeepDistance(this.currentKeepDistance);
                action.setActivatedNotEffects(this.activateNotEffects);
                action.setActivatedClickEffects(this.activateClickEffects);
                this.element.addAction(action);
                this.reading = 0;
            } else if (string3.equals("use-with")) {
                Action action = new Action(3, this.currentIdTarget, this.currentConditions, this.currentEffects, this.currentNotEffects, this.currentClickEffects);
                action.setDocumentation(this.currentDocumentation);
                action.setKeepDistance(this.currentKeepDistance);
                action.setNeedsGoTo(this.currentNeedsGoTo);
                action.setActivatedNotEffects(this.activateNotEffects);
                action.setActivatedClickEffects(this.activateClickEffects);
                this.element.addAction(action);
                this.reading = 0;
            } else if (string3.equals("drag-to")) {
                Action action = new Action(8, this.currentIdTarget, this.currentConditions, this.currentEffects, this.currentNotEffects, this.currentClickEffects);
                action.setDocumentation(this.currentDocumentation);
                action.setKeepDistance(this.currentKeepDistance);
                action.setNeedsGoTo(this.currentNeedsGoTo);
                action.setActivatedNotEffects(this.activateNotEffects);
                action.setActivatedClickEffects(this.activateClickEffects);
                this.element.addAction(action);
                this.reading = 0;
            } else if (string3.equals("give-to")) {
                Action action = new Action(2, this.currentIdTarget, this.currentConditions, this.currentEffects, this.currentNotEffects, this.currentClickEffects);
                action.setDocumentation(this.currentDocumentation);
                action.setKeepDistance(this.currentKeepDistance);
                action.setNeedsGoTo(this.currentNeedsGoTo);
                action.setActivatedNotEffects(this.activateNotEffects);
                action.setActivatedClickEffects(this.activateClickEffects);
                this.element.addAction(action);
                this.reading = 0;
            } else if (string3.equals("custom")) {
                this.currentCustomAction.setName(this.currentName);
                this.currentCustomAction.setConditions(this.currentConditions);
                this.currentCustomAction.setEffects(this.currentEffects);
                this.currentCustomAction.setNotEffects(this.currentNotEffects);
                this.currentCustomAction.setDocumentation(this.currentDocumentation);
                this.currentCustomAction.setKeepDistance(this.currentKeepDistance);
                this.currentCustomAction.setNeedsGoTo(this.currentNeedsGoTo);
                this.currentCustomAction.setActivatedNotEffects(this.activateNotEffects);
                this.currentCustomAction.setClickEffects(this.currentClickEffects);
                this.currentCustomAction.setActivatedClickEffects(this.activateClickEffects);
                this.element.addAction(this.currentCustomAction);
                this.currentCustomAction = null;
                this.reading = 0;
            } else if (string3.equals("custom-interact")) {
                this.currentCustomAction.setConditions(this.currentConditions);
                this.currentCustomAction.setEffects(this.currentEffects);
                this.currentCustomAction.setNotEffects(this.currentNotEffects);
                this.currentCustomAction.setName(this.currentName);
                this.currentCustomAction.setTargetId(this.currentIdTarget);
                this.currentCustomAction.setDocumentation(this.currentDocumentation);
                this.currentCustomAction.setKeepDistance(this.currentKeepDistance);
                this.currentCustomAction.setNeedsGoTo(this.currentNeedsGoTo);
                this.currentCustomAction.setActivatedNotEffects(this.activateNotEffects);
                this.currentCustomAction.setClickEffects(this.currentClickEffects);
                this.currentCustomAction.setActivatedClickEffects(this.activateClickEffects);
                this.element.addAction(this.currentCustomAction);
                this.currentCustomAction = null;
                this.reading = 0;
            }
            this.currentString = new StringBuffer();
        } else if (this.subParsing == 1) {
            this.subParser.endElement(string, string2, string3);
            if (string3.equals("condition")) {
                if (this.reading == 2) {
                    this.currentResources.setConditions(this.currentConditions);
                }
                this.subParsing = 0;
            }
        } else if (this.subParsing == 2) {
            this.subParser.endElement(string, string2, string3);
            if (string3.equals("effect")) {
                this.subParsing = 0;
            } else if (string3.equals("not-effect")) {
                this.subParsing = 0;
            } else if (string3.equals("click-effect")) {
                this.subParsing = 0;
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.subParsing == 0) {
            super.characters(cArray, n, n2);
        } else {
            this.subParser.characters(cArray, n, n2);
        }
    }
}

