/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.loader.parsers;

import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.data.chapter.conditions.GlobalState;
import es.eucm.eadventure.common.data.chapter.effects.Macro;
import es.eucm.eadventure.common.loader.InputStreamCreator;
import es.eucm.eadventure.common.loader.subparsers.AdaptationSubParser;
import es.eucm.eadventure.common.loader.subparsers.AssessmentSubParser;
import es.eucm.eadventure.common.loader.subparsers.AtrezzoSubParser;
import es.eucm.eadventure.common.loader.subparsers.BookSubParser;
import es.eucm.eadventure.common.loader.subparsers.CharacterSubParser;
import es.eucm.eadventure.common.loader.subparsers.ConditionSubParser;
import es.eucm.eadventure.common.loader.subparsers.CutsceneSubParser;
import es.eucm.eadventure.common.loader.subparsers.EffectSubParser;
import es.eucm.eadventure.common.loader.subparsers.GraphConversationSubParser;
import es.eucm.eadventure.common.loader.subparsers.ItemSubParser;
import es.eucm.eadventure.common.loader.subparsers.PlayerSubParser;
import es.eucm.eadventure.common.loader.subparsers.SceneSubParser;
import es.eucm.eadventure.common.loader.subparsers.SubParser;
import es.eucm.eadventure.common.loader.subparsers.TimerSubParser;
import es.eucm.eadventure.common.loader.subparsers.TreeConversationSubParser;
import java.io.InputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ChapterHandler
extends DefaultHandler {
    private static final int NONE = 0;
    private static final int SCENE = 1;
    private static final int CUTSCENE = 2;
    private static final int BOOK = 3;
    private static final int OBJECT = 4;
    private static final int PLAYER = 5;
    private static final int CHARACTER = 6;
    private static final int CONVERSATION = 7;
    private static final int TIMER = 8;
    private static final int GLOBAL_STATE = 9;
    private static final int MACRO = 10;
    private static final int ATREZZO = 11;
    private static final int ASSESSMENT = 12;
    private static final int ADAPTATION = 13;
    private int subParsing = 0;
    private SubParser subParser;
    private Chapter chapter;
    private InputStreamCreator isCreator;
    private GlobalState currentGlobalState;
    private Macro currentMacro;
    private StringBuffer currentString;

    public ChapterHandler(InputStreamCreator inputStreamCreator, Chapter chapter) {
        this.chapter = chapter;
        this.isCreator = inputStreamCreator;
        this.currentString = new StringBuffer();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.subParsing == 0) {
            if (string3.equals("eAdventure")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("adaptProfile")) {
                        this.chapter.setAdaptationName(attributes.getValue(i));
                    }
                    if (!attributes.getQName(i).equals("assessProfile")) continue;
                    this.chapter.setAssessmentName(attributes.getValue(i));
                }
            } else if (string3.equals("scene")) {
                this.subParser = new SceneSubParser(this.chapter);
                this.subParsing = 1;
            } else if (string3.equals("slidescene") || string3.equals("videoscene")) {
                this.subParser = new CutsceneSubParser(this.chapter);
                this.subParsing = 2;
            } else if (string3.equals("book")) {
                this.subParser = new BookSubParser(this.chapter);
                this.subParsing = 3;
            } else if (string3.equals("object")) {
                this.subParser = new ItemSubParser(this.chapter);
                this.subParsing = 4;
            } else if (string3.equals("player")) {
                this.subParser = new PlayerSubParser(this.chapter);
                this.subParsing = 5;
            } else if (string3.equals("character")) {
                this.subParser = new CharacterSubParser(this.chapter);
                this.subParsing = 6;
            } else if (string3.equals("tree-conversation")) {
                this.subParser = new TreeConversationSubParser(this.chapter);
                this.subParsing = 7;
            } else if (string3.equals("graph-conversation")) {
                this.subParser = new GraphConversationSubParser(this.chapter);
                this.subParsing = 7;
            } else if (string3.equals("timer")) {
                this.subParser = new TimerSubParser(this.chapter);
                this.subParsing = 8;
            } else if (string3.equals("global-state")) {
                String string4 = null;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("id")) continue;
                    string4 = attributes.getValue(i);
                }
                this.currentGlobalState = new GlobalState(string4);
                this.currentString = new StringBuffer();
                this.chapter.addGlobalState(this.currentGlobalState);
                this.subParser = new ConditionSubParser(this.currentGlobalState, this.chapter);
                this.subParsing = 9;
            } else if (string3.equals("macro")) {
                String string5 = null;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("id")) continue;
                    string5 = attributes.getValue(i);
                }
                this.currentMacro = new Macro(string5);
                this.currentString = new StringBuffer();
                this.chapter.addMacro(this.currentMacro);
                this.subParser = new EffectSubParser(this.currentMacro, this.chapter);
                this.subParsing = 10;
            } else if (string3.equals("atrezzoobject")) {
                this.subParser = new AtrezzoSubParser(this.chapter);
                this.subParsing = 11;
            } else if (string3.equals("assessment")) {
                this.subParser = new AssessmentSubParser(this.chapter);
                this.subParsing = 12;
            } else if (string3.equals("adaptation")) {
                this.subParser = new AdaptationSubParser(this.chapter);
                this.subParsing = 13;
            }
        }
        if (this.subParsing != 0) {
            this.subParser.startElement(string, string2, string3, attributes);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("documentation") && this.subParsing == 9) {
            this.currentGlobalState.setDocumentation(this.currentString.toString().trim());
        } else if (string3.equals("documentation") && this.subParsing == 10) {
            this.currentMacro.setDocumentation(this.currentString.toString().trim());
        }
        this.currentString = new StringBuffer();
        if (this.subParsing != 0) {
            this.subParser.endElement(string, string2, string3);
            if (string3.equals("scene") && this.subParsing == 1 || (string3.equals("slidescene") || string3.equals("videoscene")) && this.subParsing == 2 || string3.equals("book") && this.subParsing == 3 || string3.equals("object") && this.subParsing == 4 || string3.equals("player") && this.subParsing == 5 || string3.equals("character") && this.subParsing == 6 || string3.equals("tree-conversation") && this.subParsing == 7 || string3.equals("graph-conversation") && this.subParsing == 7 || string3.equals("timer") && this.subParsing == 8 || string3.equals("global-state") && this.subParsing == 9 || string3.equals("macro") && this.subParsing == 10 || string3.equals("atrezzoobject") && this.subParsing == 11 || string3.equals("assessment") && this.subParsing == 12 || string3.equals("adaptation") && this.subParsing == 13) {
                this.subParsing = 0;
            }
        }
    }

    @Override
    public void endDocument() {
        if (this.chapter.getTargetId() == null) {
            if (this.chapter.getScenes().size() > 0) {
                this.chapter.setTargetId(this.chapter.getScenes().get(0).getId());
            } else if (this.chapter.getCutscenes().size() > 0) {
                this.chapter.setTargetId(this.chapter.getCutscenes().get(0).getId());
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.currentString.append(new String(cArray, n, n2));
        if (this.subParsing != 0) {
            this.subParser.characters(cArray, n, n2);
        }
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        sAXParseException.printStackTrace();
        throw sAXParseException;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        int n = string2.lastIndexOf("/") + 1;
        String string3 = string2.substring(n, string2.length());
        InputStream inputStream = this.isCreator.buildInputStream(string3);
        return new InputSource(inputStream);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
    }
}

