/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.loader.parsers;

import es.eucm.eadventure.common.data.adaptation.AdaptationProfile;
import es.eucm.eadventure.common.data.adventure.AdventureData;
import es.eucm.eadventure.common.data.adventure.DescriptorData;
import es.eucm.eadventure.common.data.assessment.AssessmentProfile;
import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.common.loader.InputStreamCreator;
import es.eucm.eadventure.common.loader.Loader;
import es.eucm.eadventure.common.loader.incidences.Incidence;
import es.eucm.eadventure.common.loader.parsers.ChapterHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class AdventureHandler
extends DefaultHandler {
    private static final String assessmentFolderPath = "assessment";
    private static final String adaptationFolderPath = "adaptation";
    private static final int READING_NONE = 0;
    private static final int READING_CHAPTER = 1;
    private int reading = 0;
    private AdventureData adventureData;
    private List<Incidence> incidences;
    private List<Chapter> chapters;
    private Chapter currentChapter;
    protected StringBuffer currentString;
    private InputStreamCreator isCreator;
    private List<String> assessmentPaths;
    private List<String> adaptationPaths;
    private boolean validate;

    private static void getXMLFilePaths(InputStreamCreator inputStreamCreator, List<String> list, List<String> list2) {
        for (String string : inputStreamCreator.listNames(assessmentFolderPath)) {
            if (!string.toLowerCase().endsWith(".xml")) continue;
            list.add("assessment/" + string);
        }
        for (String string : inputStreamCreator.listNames(adaptationFolderPath)) {
            if (!string.toLowerCase().endsWith(".xml")) continue;
            list2.add("adaptation/" + string);
        }
    }

    public AdventureHandler(InputStreamCreator inputStreamCreator, List<Incidence> list, boolean bl) {
        this.isCreator = inputStreamCreator;
        this.assessmentPaths = new ArrayList<String>();
        this.adaptationPaths = new ArrayList<String>();
        AdventureHandler.getXMLFilePaths(inputStreamCreator, this.assessmentPaths, this.adaptationPaths);
        this.adventureData = new AdventureData();
        this.incidences = list;
        this.chapters = new ArrayList<Chapter>();
        this.validate = bl;
    }

    public void loadProfiles() {
        if (!this.adventureData.hasAdapOrAssesData()) {
            Cloneable cloneable;
            boolean bl;
            for (String string : this.assessmentPaths) {
                bl = false;
                cloneable = Loader.loadAssessmentProfile(this.isCreator, string, this.incidences);
                if (cloneable == null) continue;
                for (Chapter chapter : this.adventureData.getChapters()) {
                    if (!chapter.getAssessmentName().equals(((AssessmentProfile)cloneable).getName())) continue;
                    chapter.addAssessmentProfile((AssessmentProfile)cloneable);
                    bl = true;
                }
                if (bl) continue;
                for (Chapter chapter : this.adventureData.getChapters()) {
                    chapter.addAssessmentProfile((AssessmentProfile)cloneable);
                }
            }
            for (String string : this.adaptationPaths) {
                bl = false;
                cloneable = Loader.loadAdaptationProfile(this.isCreator, string, this.incidences);
                if (cloneable == null) continue;
                for (Chapter chapter : this.adventureData.getChapters()) {
                    if (!chapter.getAdaptationName().equals(((AdaptationProfile)cloneable).getName())) continue;
                    chapter.addAdaptationProfile((AdaptationProfile)cloneable);
                    bl = true;
                }
                if (bl) continue;
                for (Chapter chapter : this.adventureData.getChapters()) {
                    chapter.addAdaptationProfile((AdaptationProfile)cloneable);
                }
            }
        }
    }

    public AdventureData getAdventureData() {
        return this.adventureData;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        block48: {
            int n;
            String string4;
            block51: {
                block50: {
                    block49: {
                        block47: {
                            int n2;
                            if (string3.equals("game-descriptor")) {
                                for (n2 = 0; n2 < attributes.getLength(); ++n2) {
                                    if (!attributes.getQName(n2).equals("versionNumber")) continue;
                                    this.adventureData.setVersionNumber(attributes.getValue(n2));
                                }
                            }
                            if (string3.equals("configuration")) {
                                for (n2 = 0; n2 < attributes.getLength(); ++n2) {
                                    if (attributes.getQName(n2).equals("keepShowing")) {
                                        this.adventureData.setKeepShowing(attributes.getValue(n2).equals("yes"));
                                    }
                                    if (!attributes.getQName(n2).equals("defaultClickAction")) continue;
                                    if (attributes.getValue(n2).equals("showDetails")) {
                                        this.adventureData.setDeafultClickAction(DescriptorData.DefaultClickAction.SHOW_DETAILS);
                                    }
                                    if (!attributes.getValue(n2).equals("showActions")) continue;
                                    this.adventureData.setDeafultClickAction(DescriptorData.DefaultClickAction.SHOW_ACTIONS);
                                }
                            }
                            if (string3.equals("title") || string3.equals("description")) {
                                this.currentString = new StringBuffer();
                            }
                            if (string3.endsWith("automatic-commentaries")) {
                                this.adventureData.setCommentaries(true);
                            }
                            if (string3.equals("gui")) {
                                for (n2 = 0; n2 < attributes.getLength(); ++n2) {
                                    if (attributes.getQName(n2).equals("type")) {
                                        if (attributes.getValue(n2).equals("traditional")) {
                                            this.adventureData.setGUIType(0);
                                        } else if (attributes.getValue("type").equals("contextual")) {
                                            this.adventureData.setGUIType(1);
                                        }
                                    }
                                    if (attributes.getQName(n2).equals("customized")) {
                                        if (attributes.getValue(n2).equals("yes")) {
                                            this.adventureData.setGUI(this.adventureData.getGUIType(), true);
                                        } else {
                                            this.adventureData.setGUI(this.adventureData.getGUIType(), false);
                                        }
                                    }
                                    if (!attributes.getQName(n2).equals("inventoryPosition")) continue;
                                    if (attributes.getValue(n2).equals("none")) {
                                        this.adventureData.setInventoryPosition(0);
                                        continue;
                                    }
                                    if (attributes.getValue(n2).equals("top_bottom")) {
                                        this.adventureData.setInventoryPosition(1);
                                        continue;
                                    }
                                    if (attributes.getValue(n2).equals("top")) {
                                        this.adventureData.setInventoryPosition(2);
                                        continue;
                                    }
                                    if (!attributes.getValue(n2).equals("bottom")) continue;
                                    this.adventureData.setInventoryPosition(3);
                                }
                            }
                            if (string3.equals("cursor")) {
                                String string5 = "";
                                string4 = "";
                                for (n = 0; n < attributes.getLength(); ++n) {
                                    if (attributes.getQName(n).equals("type")) {
                                        string5 = attributes.getValue(n);
                                        continue;
                                    }
                                    if (!attributes.getQName(n).equals("uri")) continue;
                                    string4 = attributes.getValue(n);
                                }
                                this.adventureData.addCursor(string5, string4);
                            }
                            if (string3.equals("button")) {
                                String string6 = "";
                                string4 = "";
                                String string7 = "";
                                for (int i = 0; i < attributes.getLength(); ++i) {
                                    if (attributes.getQName(i).equals("type")) {
                                        string6 = attributes.getValue(i);
                                        continue;
                                    }
                                    if (attributes.getQName(i).equals("uri")) {
                                        string4 = attributes.getValue(i);
                                        continue;
                                    }
                                    if (!attributes.getQName(i).equals("action")) continue;
                                    string7 = attributes.getValue(i);
                                }
                                this.adventureData.addButton(string7, string6, string4);
                            }
                            if (string3.equals("arrow")) {
                                String string8 = "";
                                string4 = "";
                                for (n = 0; n < attributes.getLength(); ++n) {
                                    if (attributes.getQName(n).equals("type")) {
                                        string8 = attributes.getValue(n);
                                        continue;
                                    }
                                    if (!attributes.getQName(n).equals("uri")) continue;
                                    string4 = attributes.getValue(n);
                                }
                                this.adventureData.addArrow(string8, string4);
                            }
                            if (string3.equals("mode")) {
                                for (int i = 0; i < attributes.getLength(); ++i) {
                                    if (!attributes.getQName(i).equals("playerTransparent")) continue;
                                    if (attributes.getValue(i).equals("yes")) {
                                        this.adventureData.setPlayerMode(0);
                                        continue;
                                    }
                                    if (!attributes.getValue(i).equals("no")) continue;
                                    this.adventureData.setPlayerMode(1);
                                }
                            }
                            if (!string3.equals("graphics")) break block47;
                            for (int i = 0; i < attributes.getLength(); ++i) {
                                if (!attributes.getQName(i).equals("mode")) continue;
                                if (attributes.getValue(i).equals("windowed")) {
                                    this.adventureData.setGraphicConfig(0);
                                    continue;
                                }
                                if (attributes.getValue(i).equals("fullscreen")) {
                                    this.adventureData.setGraphicConfig(2);
                                    continue;
                                }
                                if (!attributes.getValue(i).equals("blackbkg")) continue;
                                this.adventureData.setGraphicConfig(1);
                            }
                            break block48;
                        }
                        if (!string3.equals("contents")) break block49;
                        this.reading = 1;
                        break block48;
                    }
                    if (!string3.equals("chapter")) break block50;
                    this.currentChapter = new Chapter();
                    String string9 = null;
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        if (!attributes.getQName(i).equals("path")) continue;
                        string9 = attributes.getValue(i);
                    }
                    if (string9 != null) {
                        this.currentChapter.setChapterPath(string9);
                    } else {
                        this.currentChapter.setChapterPath("");
                    }
                    try {
                        ChapterHandler chapterHandler = new ChapterHandler(this.isCreator, this.currentChapter);
                        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                        sAXParserFactory.setValidating(false);
                        SAXParser sAXParser = sAXParserFactory.newSAXParser();
                        InputStream inputStream = this.isCreator.buildInputStream(string9);
                        sAXParser.parse(inputStream, (DefaultHandler)chapterHandler);
                        inputStream.close();
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        this.incidences.add(Incidence.createChapterIncidence(TC.get("Error.LoadData.SAX"), string9, parserConfigurationException));
                    }
                    catch (SAXException sAXException) {
                        this.incidences.add(Incidence.createChapterIncidence(TC.get("Error.LoadData.SAX"), string9, sAXException));
                    }
                    catch (IOException iOException) {
                        this.incidences.add(Incidence.createChapterIncidence(TC.get("Error.LoadData.IO"), string9, iOException));
                    }
                    break block48;
                }
                if (!string3.equals("adaptation-configuration")) break block51;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("path")) continue;
                    string4 = attributes.getValue(i);
                    string4 = string4.substring(string4.indexOf("/") + 1);
                    string4 = string4.substring(0, string4.indexOf("."));
                    this.currentChapter.setAdaptationName(string4);
                    for (n = 0; n < this.incidences.size(); ++n) {
                        Incidence incidence = this.incidences.get(n);
                        if (incidence.getAffectedArea() != 1 || !incidence.getAffectedResource().equals(string4)) continue;
                        String string10 = incidence.getMessage();
                        this.incidences.remove(n);
                        this.incidences.add(n, Incidence.createAdaptationIncidence(true, string10 + TC.get("Error.LoadAdaptation.Referenced"), string4, null));
                    }
                }
                break block48;
            }
            if (!string3.equals("assessment-configuration")) break block48;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals("path")) continue;
                string4 = attributes.getValue(i);
                string4 = string4.substring(string4.indexOf("/") + 1);
                string4 = string4.substring(0, string4.indexOf("."));
                this.currentChapter.setAssessmentName(string4);
                for (n = 0; n < this.incidences.size(); ++n) {
                    Incidence incidence = this.incidences.get(n);
                    if (incidence.getAffectedArea() != 0 || !incidence.getAffectedResource().equals(string4)) continue;
                    String string11 = incidence.getMessage();
                    this.incidences.remove(n);
                    this.incidences.add(n, Incidence.createAssessmentIncidence(true, string11 + TC.get("Error.LoadAssessment.Referenced"), string4, null));
                }
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("title")) {
            if (this.reading == 0) {
                this.adventureData.setTitle(this.currentString.toString().trim());
            } else if (this.reading == 1) {
                this.currentChapter.setTitle(this.currentString.toString().trim());
            }
        } else if (string3.equals("description")) {
            if (this.reading == 0) {
                this.adventureData.setDescription(this.currentString.toString().trim());
            } else if (this.reading == 1) {
                this.currentChapter.setDescription(this.currentString.toString().trim());
            }
        } else if (string3.equals("contents")) {
            this.adventureData.setChapters(this.chapters);
        } else if (string3.equals("chapter")) {
            this.chapters.add(this.currentChapter);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.currentString.append(new String(cArray, n, n2));
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    public List<Incidence> getIncidences() {
        return this.incidences;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        int n = string2.lastIndexOf("/") + 1;
        String string3 = string2.substring(n, string2.length());
        InputStream inputStream = this.isCreator.buildInputStream(string3);
        return new InputSource(inputStream);
    }
}

