/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.loader;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.adaptation.AdaptationProfile;
import es.eucm.eadventure.common.data.adaptation.AdaptationRule;
import es.eucm.eadventure.common.data.adaptation.AdaptedState;
import es.eucm.eadventure.common.data.adventure.AdventureData;
import es.eucm.eadventure.common.data.adventure.DescriptorData;
import es.eucm.eadventure.common.data.animation.Animation;
import es.eucm.eadventure.common.data.animation.ImageLoaderFactory;
import es.eucm.eadventure.common.data.assessment.AssessmentProfile;
import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.common.loader.InputStreamCreator;
import es.eucm.eadventure.common.loader.incidences.Incidence;
import es.eucm.eadventure.common.loader.parsers.AdaptationHandler;
import es.eucm.eadventure.common.loader.parsers.AdventureHandler;
import es.eucm.eadventure.common.loader.parsers.AnimationHandler;
import es.eucm.eadventure.common.loader.parsers.AssessmentHandler;
import es.eucm.eadventure.common.loader.parsers.ChapterHandler;
import es.eucm.eadventure.common.loader.parsers.DescriptorHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Loader {
    private static AdventureData adventureData;
    private static SAXParserFactory factory;

    private Loader() {
    }

    public static AdventureData loadAdventureData(InputStreamCreator inputStreamCreator, List<Incidence> list, boolean bl) {
        AdventureData adventureData = null;
        try {
            AdventureHandler adventureHandler = new AdventureHandler(inputStreamCreator, list, bl);
            factory.setValidating(true);
            SAXParser sAXParser = factory.newSAXParser();
            InputStream inputStream = inputStreamCreator.buildInputStream("descriptor.xml");
            sAXParser.parse(inputStream, (DefaultHandler)adventureHandler);
            inputStream.close();
            adventureHandler.loadProfiles();
            adventureData = adventureHandler.getAdventureData();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            list.add(Incidence.createDescriptorIncidence(TC.get("Error.LoadDescriptor.SAX"), parserConfigurationException));
        }
        catch (SAXException sAXException) {
            list.add(Incidence.createDescriptorIncidence(TC.get("Error.LoadDescriptor.SAX"), sAXException));
        }
        catch (IOException iOException) {
            list.add(Incidence.createDescriptorIncidence(TC.get("Error.LoadDescriptor.IO"), iOException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            list.add(Incidence.createDescriptorIncidence(TC.get("Error.LoadDescriptor.NoDescriptor"), illegalArgumentException));
        }
        return adventureData;
    }

    public static DescriptorData loadDescriptorData(InputStreamCreator inputStreamCreator) {
        DescriptorData descriptorData = null;
        if (adventureData != null) {
            descriptorData = adventureData;
        } else {
            try {
                DescriptorHandler descriptorHandler = new DescriptorHandler(inputStreamCreator);
                factory.setValidating(false);
                SAXParser sAXParser = factory.newSAXParser();
                InputStream inputStream = inputStreamCreator.buildInputStream("descriptor.xml");
                sAXParser.parse(inputStream, (DefaultHandler)descriptorHandler);
                inputStream.close();
                descriptorData = descriptorHandler.getGameDescriptor();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ReportDialog.GenerateErrorReport(parserConfigurationException, true, "UNKNOWERROR");
            }
            catch (SAXException sAXException) {
                ReportDialog.GenerateErrorReport(sAXException, true, "UNKNOWERROR");
            }
            catch (IOException iOException) {
                ReportDialog.GenerateErrorReport(iOException, true, "UNKNOWERROR");
            }
        }
        return descriptorData;
    }

    public static Chapter loadChapterData(InputStreamCreator inputStreamCreator, String string, List<Incidence> list, boolean bl) {
        Chapter object = new Chapter();
        boolean bl2 = false;
        if (adventureData != null) {
            for (Chapter object2 : adventureData.getChapters()) {
                if (object2 != null && object2.getChapterPath() != null && object2.getChapterPath().equals(string)) {
                    object = object2;
                    bl2 = true;
                    break;
                }
                if (object2 == null || object2.getChapterPath() != null) continue;
                object = object2;
                bl2 = true;
                object.setChapterPath("chapter1.xml");
                break;
            }
        }
        if (!bl2) {
            Object object3 = null;
            object3 = inputStreamCreator.buildInputStream(string);
            object.setChapterPath(string);
            try {
                if (object3 != null) {
                    ChapterHandler parserConfigurationException = new ChapterHandler(inputStreamCreator, object);
                    factory.setValidating(bl);
                    SAXParser sAXParser = factory.newSAXParser();
                    sAXParser.parse((InputStream)object3, (DefaultHandler)parserConfigurationException);
                    ((InputStream)object3).close();
                }
            }
            catch (ParserConfigurationException sAXException) {
                list.add(Incidence.createChapterIncidence(TC.get("Error.LoadData.SAX"), string, sAXException));
            }
            catch (SAXException iOException) {
                list.add(Incidence.createChapterIncidence(TC.get("Error.LoadData.SAX"), string, iOException));
            }
            catch (IOException iOException) {
                list.add(Incidence.createChapterIncidence(TC.get("Error.LoadData.IO"), string, iOException));
            }
        }
        return object;
    }

    public static AssessmentProfile loadAssessmentProfile(InputStreamCreator inputStreamCreator, String string, List<Incidence> list) {
        AssessmentProfile assessmentProfile = null;
        if (adventureData != null) {
            block6: for (Chapter chapter : adventureData.getChapters()) {
                if (chapter.getAssessmentProfiles().size() == 0) continue;
                for (AssessmentProfile assessmentProfile2 : chapter.getAssessmentProfiles()) {
                    if (!assessmentProfile2.getName().equals(string)) continue;
                    try {
                        assessmentProfile = (AssessmentProfile)assessmentProfile2.clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        cloneNotSupportedException.printStackTrace();
                    }
                    continue block6;
                }
            }
        } else {
            try {
                AssessmentProfile assessmentProfile3 = new AssessmentProfile();
                String string2 = string;
                string2 = string2.substring(string2.indexOf("/") + 1);
                if (string2.indexOf(".") != -1) {
                    string2 = string2.substring(0, string2.indexOf("."));
                }
                assessmentProfile3.setName(string2);
                AssessmentHandler assessmentHandler = new AssessmentHandler(inputStreamCreator, assessmentProfile3);
                factory.setValidating(true);
                SAXParser sAXParser = factory.newSAXParser();
                InputStream inputStream = inputStreamCreator.buildInputStream(string);
                sAXParser.parse(inputStream, (DefaultHandler)assessmentHandler);
                inputStream.close();
                assessmentProfile = assessmentProfile3;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                list.add(Incidence.createAssessmentIncidence(false, TC.get("Error.LoadAssessmentData.SAX"), string, parserConfigurationException));
            }
            catch (SAXException sAXException) {
                list.add(Incidence.createAssessmentIncidence(false, TC.get("Error.LoadAssessmentData.SAX"), string, sAXException));
            }
            catch (IOException iOException) {
                list.add(Incidence.createAssessmentIncidence(false, TC.get("Error.LoadAssessmentData.IO"), string, iOException));
            }
        }
        return assessmentProfile;
    }

    public static AdaptationProfile loadAdaptationProfile(InputStreamCreator inputStreamCreator, String string, List<Incidence> list) {
        AdaptationProfile adaptationProfile = null;
        if (adventureData != null) {
            block4: for (Chapter chapter : adventureData.getChapters()) {
                if (chapter.getAssessmentProfiles().size() == 0) continue;
                for (AdaptationProfile adaptationProfile2 : chapter.getAdaptationProfiles()) {
                    if (!adaptationProfile2.getName().equals(string)) continue;
                    adaptationProfile = adaptationProfile2;
                    continue block4;
                }
            }
        } else {
            try {
                ArrayList<AdaptationRule> arrayList = new ArrayList<AdaptationRule>();
                AdaptedState adaptedState = new AdaptedState();
                AdaptationHandler adaptationHandler = new AdaptationHandler(inputStreamCreator, arrayList, adaptedState);
                factory.setValidating(true);
                SAXParser sAXParser = factory.newSAXParser();
                InputStream inputStream = inputStreamCreator.buildInputStream(string);
                sAXParser.parse(inputStream, (DefaultHandler)adaptationHandler);
                inputStream.close();
                String string2 = string;
                string2 = string2.substring(string2.indexOf("/") + 1);
                string2 = string2.substring(0, string2.indexOf("."));
                adaptationProfile = new AdaptationProfile(adaptationHandler.getAdaptationRules(), adaptationHandler.getInitialState(), string2, adaptationHandler.isScorm12(), adaptationHandler.isScorm2004());
                adaptationProfile.setFlags(adaptationHandler.getFlags());
                System.out.println("ADP PARSER FLAGS:" + adaptationHandler.getFlags());
                adaptationProfile.setVars(adaptationHandler.getVars());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                list.add(Incidence.createAdaptationIncidence(false, TC.get("Error.LoadAdaptationData.SAX"), string, parserConfigurationException));
            }
            catch (SAXException sAXException) {
                list.add(Incidence.createAdaptationIncidence(false, TC.get("Error.LoadAdaptationData.SAX"), string, sAXException));
            }
            catch (IOException iOException) {
                list.add(Incidence.createAdaptationIncidence(false, TC.get("Error.LoadAdaptationData.IO"), string, iOException));
            }
        }
        return adaptationProfile;
    }

    public static AdventureData getAdventureData() {
        return adventureData;
    }

    public static void setAdventureData(AdventureData adventureData) {
        Loader.adventureData = adventureData;
    }

    public static Animation loadAnimation(InputStreamCreator inputStreamCreator, String string, ImageLoaderFactory imageLoaderFactory) {
        AnimationHandler animationHandler = new AnimationHandler(inputStreamCreator, imageLoaderFactory);
        factory.setValidating(true);
        try {
            SAXParser sAXParser = factory.newSAXParser();
            InputStream inputStream = null;
            inputStream = inputStreamCreator.buildInputStream(string);
            sAXParser.parse(inputStream, (DefaultHandler)animationHandler);
            inputStream.close();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (animationHandler.getAnimation() != null) {
            return animationHandler.getAnimation();
        }
        return new Animation("anim" + new Random().nextInt(1000), imageLoaderFactory);
    }

    public static SAXParserFactory getFactory() {
        return factory;
    }

    static {
        factory = SAXParserFactory.newInstance();
    }
}

