/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.gui;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import javax.swing.JOptionPane;

public class TC {
    public static final int NORMAL_SENTENCE = 1;
    public static final int NO_CONDITION_SENTENCE = 2;
    private static Properties guiStrings;

    public static void loadStrings(String string) {
        try {
            TC.loadStrings(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            guiStrings = new Properties();
            fileNotFoundException.printStackTrace();
            JOptionPane.showMessageDialog(null, "The language file was not found, please verify that the language files are on the disk.\nAlthough you may still be able to use the adventure editor, you might get occasional problems or get some unreadable texts.\nIf you get this error again, please try reinstalling the application.", "Error loading the language file", 0);
        }
    }

    public static void loadStrings(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            TC.loadStrings(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                TC.appendStrings(stringArray[i]);
            }
        } else {
            guiStrings = new Properties();
        }
    }

    public static void loadStrings(InputStream[] inputStreamArray) {
        if (inputStreamArray != null && inputStreamArray.length > 0) {
            TC.loadStrings(inputStreamArray[0]);
            for (int i = 1; i < inputStreamArray.length; ++i) {
                TC.appendStrings(inputStreamArray[i]);
            }
        } else {
            guiStrings = new Properties();
        }
    }

    public static void loadStrings(InputStream inputStream) {
        guiStrings = new Properties();
        try {
            guiStrings.loadFromXML(inputStream);
        }
        catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
            JOptionPane.showMessageDialog(null, "The language file is bad-formed, please try to use another language file.\nAlthough you may still be able to use the adventure editor, you might get occasional problems or get some unreadable texts.\nIf you get this error again, please try reinstalling the application.", "Error loading the language file", 0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, "The language file was not found, please verify that the language files are on the disk.\nAlthough you may still be able to use the adventure editor, you might get occasional problems or get some unreadable texts.\nIf you get this error again, please try reinstalling the application.", "Error loading the language file", 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "There has been an error loading the language file, please check for problem accessing the files.\nAlthough you may still be able to use the adventure editor, you might get occasional problems or get some unreadable texts.\nIf you get this error again, please try reinstalling the application.", "Error loading the language file", 0);
        }
    }

    public static void appendStrings(String string) {
        try {
            TC.appendStrings(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            JOptionPane.showMessageDialog(null, "One of the language file required was not found, please verify that the language files are on the disk.\nAlthough you may still be able to use the adventure editor, you might get occasional problems or get some unreadable texts.\nIf you get this error again, please try reinstalling the application.", "Error loading the language file", 0);
        }
    }

    public static void appendStrings(InputStream inputStream) {
        try {
            Properties properties = new Properties();
            properties.loadFromXML(inputStream);
            for (Object object : properties.keySet()) {
                guiStrings.put(object, properties.get(object));
            }
        }
        catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
            JOptionPane.showMessageDialog(null, "The language file is bad-formed, please try to use another language file.\nAlthough you may still be able to use the adventure editor, you might get occasional problems or get some unreadable texts.\nIf you get this error again, please try reinstalling the application.", "Error loading the language file", 0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, "One of the language file required was not found, please verify that the language files are on the disk.\nAlthough you may still be able to use the adventure editor, you might get occasional problems or get some unreadable texts.\nIf you get this error again, please try reinstalling the application.", "Error loading the language file", 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "There has been an error loading the language file, please check for problem accessing the files.\nAlthough you may still be able to use the adventure editor, you might get occasional problems or get some unreadable texts.\nIf you get this error again, please try reinstalling the application.", "Error loading the language file", 0);
        }
    }

    public static boolean containsText(String string) {
        return guiStrings.containsKey(string);
    }

    public static boolean containsConditionsContextText(int n, int n2) {
        return TC.containsText("Conditions.Context." + n2 + "." + n);
    }

    public static String getElement(int n) {
        return TC.get("Element.Name" + n);
    }

    public static String getConditionsContextText(int n, int n2) {
        return TC.get("Conditions.Context." + n2 + "." + n);
    }

    public static String get(String string) {
        String string2 = null;
        if (guiStrings != null && guiStrings.containsKey(string)) {
            string2 = guiStrings.getProperty(string);
        } else {
            string2 = "Error";
            System.err.println("Identifier \"" + string + "\" not found");
        }
        return string2;
    }

    public static String get(String string, String string2) {
        String string3 = null;
        if (guiStrings.containsKey(string)) {
            string3 = guiStrings.getProperty(string);
            string3 = string3.replace("{#0}", string2);
        } else {
            string3 = "Error";
            System.err.println("Identifier \"" + string + "\" not found");
        }
        return string3;
    }

    public static String get(String string, String[] stringArray) {
        String string2 = null;
        if (guiStrings.containsKey(string)) {
            string2 = guiStrings.getProperty(string);
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = string2.replace("{#" + i + "}", stringArray[i]);
            }
        } else {
            string2 = "Error";
            System.err.println("Identifier \"" + string + "\" not found");
        }
        return string2;
    }

    public static String getToolName(Class clazz) {
        String string = null;
        string = guiStrings != null && guiStrings.containsKey("Edition.UndoRedo.Name." + clazz.getSimpleName()) ? guiStrings.getProperty("Edition.UndoRedo.Name." + clazz.getSimpleName()) : clazz.getSimpleName();
        return string;
    }
}

