/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.gui;

import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NoEditableNumberSpinner
extends JSpinner {
    private static final long serialVersionUID = 4827835884428487802L;
    private JLabel editor;

    public NoEditableNumberSpinner(Number number, int n, int n2, Number number2) {
        super(new SpinnerNumberModel(number, Integer.valueOf(n), Integer.valueOf(n2), number2));
        this.editor = new JLabel(number.toString());
        this.setEditor(this.editor);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                NoEditableNumberSpinner.this.editor.setText(NoEditableNumberSpinner.this.getValue().toString());
            }
        });
    }

    public NoEditableNumberSpinner(Number number, float f, float f2, Number number2) {
        super(new FloatSpinnerNumberModel(number, f, f2, number2));
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(1);
        this.editor = new JLabel(numberFormat.format(((Float)this.getValue()).floatValue()));
        this.setEditor(this.editor);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setMaximumFractionDigits(1);
                NoEditableNumberSpinner.this.editor.setText(numberFormat.format(((Float)NoEditableNumberSpinner.this.getValue()).floatValue()));
            }
        });
    }

    private static class FloatSpinnerNumberModel
    extends SpinnerNumberModel {
        private static final long serialVersionUID = 5181715509494977849L;
        private Comparable<Float> max;
        private Comparable<Float> min;

        public FloatSpinnerNumberModel(Number number, float f, float f2, Number number2) {
            super(number, Float.valueOf(f), Float.valueOf(f2), number2);
            this.max = Float.valueOf(f2);
            this.min = Float.valueOf(f);
        }

        private Number incrValue(int n) {
            Number number = this.getNumber();
            Number number2 = this.getStepSize();
            float f = number.floatValue() + number2.floatValue() * (float)n;
            Float f2 = new Float(f);
            if (this.max != null && this.max.compareTo(f2) < 0) {
                return null;
            }
            if (this.min != null && this.min.compareTo(f2) > 0) {
                return null;
            }
            return f2;
        }

        @Override
        public Object getNextValue() {
            return this.incrValue(1);
        }

        @Override
        public Object getPreviousValue() {
            return this.incrValue(-1);
        }
    }
}

