/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter.resources;

import es.eucm.eadventure.common.auxiliar.AllElementsWithAssets;
import es.eucm.eadventure.common.data.Named;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.resources.Asset;
import java.util.HashMap;

public class Resources
implements Cloneable,
Named {
    private Conditions conditions;
    private HashMap<String, String> assets = new HashMap();
    private String name;

    public Resources() {
        AllElementsWithAssets.addAsset(this.assets);
        this.conditions = new Conditions();
        this.name = "No name";
    }

    public boolean addAsset(String string, String string2) {
        boolean bl = this.existAsset(string) && this.getAssetPath(string).equals(string2);
        this.deleteAsset(string);
        this.assets.put(string, string2);
        return !bl;
    }

    public boolean addAsset(Asset asset) {
        return this.addAsset(asset.getType(), asset.getPath());
    }

    public void deleteAsset(String string) {
        this.assets.remove(string);
    }

    public int getAssetCount() {
        return this.assets.size();
    }

    public String[] getAssetTypes() {
        return this.assets.keySet().toArray(new String[0]);
    }

    public String[] getAssetValues() {
        return this.assets.values().toArray(new String[0]);
    }

    public String getAssetPath(String string) {
        return this.assets.get(string);
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public boolean existAsset(String string) {
        boolean bl = false;
        bl = this.assets.containsKey(string) && this.assets.get(string) != null;
        return bl;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Object clone() throws CloneNotSupportedException {
        Resources resources = (Resources)super.clone();
        if (this.assets != null) {
            resources.assets = new HashMap();
            for (String string : this.assets.keySet()) {
                String string2 = this.assets.get(string) != null ? new String(this.assets.get(string)) : null;
                resources.assets.put(new String(string), string2);
            }
        }
        resources.name = this.name != null ? new String(this.name) : null;
        resources.conditions = this.conditions != null ? (Conditions)this.conditions.clone() : null;
        return resources;
    }

    public void clearAssets() {
        this.assets.clear();
    }
}

