/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter.effects;

import es.eucm.eadventure.common.auxiliar.AllElementsWithAssets;
import es.eucm.eadventure.common.data.chapter.effects.AbstractEffect;
import es.eucm.eadventure.common.data.chapter.effects.RandomEffect;
import java.util.ArrayList;
import java.util.List;

public class Effects
implements Cloneable {
    private List<AbstractEffect> effects = new ArrayList<AbstractEffect>();

    public boolean isEmpty() {
        return this.effects.isEmpty();
    }

    public void clear() {
        this.effects.clear();
    }

    public void add(AbstractEffect abstractEffect) {
        this.effects.add(abstractEffect);
        if (abstractEffect.getType() == 9 || abstractEffect.getType() == 8) {
            AllElementsWithAssets.addAsset(abstractEffect);
        } else if (abstractEffect.getType() == 16) {
            if (((RandomEffect)abstractEffect).getPositiveEffect() != null && ((RandomEffect)abstractEffect).getPositiveEffect().getType() == 9) {
                AllElementsWithAssets.addAsset(((RandomEffect)abstractEffect).getPositiveEffect());
            }
            if (((RandomEffect)abstractEffect).getNegativeEffect() != null && ((RandomEffect)abstractEffect).getNegativeEffect().getType() == 8) {
                AllElementsWithAssets.addAsset(((RandomEffect)abstractEffect).getNegativeEffect());
            }
        }
    }

    public List<AbstractEffect> getEffects() {
        return this.effects;
    }

    public boolean hasCancelAction() {
        boolean bl = false;
        for (AbstractEffect abstractEffect : this.effects) {
            if (abstractEffect.getType() != 4) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Object clone() throws CloneNotSupportedException {
        Effects effects = (Effects)super.clone();
        if (this.effects != null) {
            effects.effects = new ArrayList<AbstractEffect>();
            for (AbstractEffect abstractEffect : this.effects) {
                effects.effects.add((AbstractEffect)abstractEffect.clone());
            }
        }
        return effects;
    }
}

