/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter.conversation.node;

import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.conversation.line.ConversationLine;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNode;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import java.util.ArrayList;
import java.util.List;

public class DialogueConversationNode
extends ConversationNode {
    private List<ConversationLine> dialogue = new ArrayList<ConversationLine>();
    private ConversationNode nextNode = null;
    private boolean terminal = true;
    private Effects effects = new Effects();
    private boolean effectConsumed = false;
    private boolean keepShowing;

    public DialogueConversationNode() {
        this(false);
    }

    public DialogueConversationNode(boolean bl) {
        this.keepShowing = bl;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public boolean isTerminal() {
        return this.terminal;
    }

    @Override
    public int getChildCount() {
        int n = 0;
        if (this.nextNode != null) {
            ++n;
        }
        return n;
    }

    @Override
    public ConversationNode getChild(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.nextNode;
    }

    @Override
    public void addChild(ConversationNode conversationNode) {
        if (this.nextNode != null) {
            throw new IndexOutOfBoundsException();
        }
        this.nextNode = conversationNode;
        this.terminal = false;
    }

    @Override
    public void addChild(int n, ConversationNode conversationNode) {
        if (n != 0 || this.nextNode != null) {
            throw new IndexOutOfBoundsException();
        }
        this.nextNode = conversationNode;
        this.terminal = false;
    }

    @Override
    public ConversationNode removeChild(int n) {
        if (n != 0 || this.nextNode == null) {
            throw new IndexOutOfBoundsException();
        }
        ConversationNode conversationNode = this.nextNode;
        this.nextNode = null;
        this.terminal = true;
        return conversationNode;
    }

    @Override
    public int getLineCount() {
        return this.dialogue.size();
    }

    @Override
    public ConversationLine getLine(int n) {
        return this.dialogue.get(n);
    }

    @Override
    public void addLine(ConversationLine conversationLine) {
        this.dialogue.add(conversationLine);
    }

    @Override
    public void addLine(int n, ConversationLine conversationLine) {
        this.dialogue.add(n, conversationLine);
    }

    @Override
    public ConversationLine removeLine(int n) {
        return this.dialogue.remove(n);
    }

    @Override
    public boolean hasEffects() {
        return this.hasValidEffect() && !this.effects.isEmpty();
    }

    @Override
    public void setEffects(Effects effects) {
        this.effects = effects;
    }

    @Override
    public Effects getEffects() {
        return this.effects;
    }

    @Override
    public void consumeEffect() {
        this.effectConsumed = true;
    }

    @Override
    public boolean isEffectConsumed() {
        return this.effectConsumed;
    }

    @Override
    public void resetEffect() {
        this.effectConsumed = false;
    }

    @Override
    public boolean hasValidEffect() {
        return this.effects != null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DialogueConversationNode dialogueConversationNode = (DialogueConversationNode)super.clone();
        if (this.dialogue != null) {
            dialogueConversationNode.dialogue = new ArrayList<ConversationLine>();
            for (ConversationLine conversationLine : this.dialogue) {
                dialogueConversationNode.dialogue.add((ConversationLine)conversationLine.clone());
            }
        }
        dialogueConversationNode.effectConsumed = this.effectConsumed;
        dialogueConversationNode.effects = this.effects != null ? (Effects)this.effects.clone() : null;
        dialogueConversationNode.nextNode = null;
        dialogueConversationNode.terminal = this.terminal;
        dialogueConversationNode.keepShowing = this.keepShowing;
        return dialogueConversationNode;
    }

    @Override
    public Conditions getLineConditions(int n) {
        return this.dialogue.get(n).getConditions();
    }

    @Override
    public ConversationLine getConversationLine(int n) {
        return this.dialogue.get(n);
    }

    public Boolean isKeepShowing() {
        return this.keepShowing;
    }

    public void setKeepShowing(Boolean bl) {
        this.keepShowing = bl;
    }
}

