/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter.conversation.line;

import es.eucm.eadventure.common.auxiliar.AllElementsWithAssets;
import es.eucm.eadventure.common.data.Named;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.gui.TC;

public class ConversationLine
implements Cloneable,
Named {
    public static final String PLAYER = "Player";
    private String name;
    private String text;
    private String audioPath;
    private boolean synthesizerVoice;
    private Conditions conditions;
    private boolean keepShowing;

    public ConversationLine(String string, String string2) {
        this.name = string;
        this.text = string2;
        this.synthesizerVoice = false;
        this.keepShowing = false;
        this.conditions = new Conditions();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.text;
    }

    public boolean isPlayerLine() {
        return this.name.equals(PLAYER);
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getAudioPath() {
        return this.audioPath;
    }

    public void setAudioPath(String string) {
        this.audioPath = string;
        if (string != null) {
            AllElementsWithAssets.addAsset(this);
        }
    }

    public boolean isValidAudio() {
        return this.audioPath != null && !this.audioPath.equals("");
    }

    public Boolean getSynthesizerVoice() {
        return this.synthesizerVoice;
    }

    public void setSynthesizerVoice(Boolean bl) {
        this.synthesizerVoice = bl;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public Object clone() throws CloneNotSupportedException {
        ConversationLine conversationLine = (ConversationLine)super.clone();
        conversationLine.audioPath = this.audioPath != null ? new String(this.audioPath) : null;
        conversationLine.name = this.name != null ? new String(this.name) : null;
        conversationLine.synthesizerVoice = this.synthesizerVoice;
        conversationLine.text = this.text != null ? new String(this.text) : null;
        conversationLine.conditions = this.conditions != null ? (Conditions)this.conditions.clone() : null;
        conversationLine.keepShowing = this.keepShowing;
        return conversationLine;
    }

    public boolean isKeepShowing() {
        return this.keepShowing;
    }

    public void setKeepShowing(boolean bl) {
        this.keepShowing = bl;
    }

    public static enum Type {
        NORMAL,
        WHISPER,
        THOUGHT,
        YELL;


        public String toString() {
            switch (this) {
                case WHISPER: {
                    return "#:*";
                }
                case THOUGHT: {
                    return "#O";
                }
                case YELL: {
                    return "#!";
                }
            }
            return "";
        }

        public String getName() {
            String string;
            switch (this) {
                case WHISPER: {
                    string = TC.get("ConversationLine.Type.Whisper");
                    break;
                }
                case THOUGHT: {
                    string = TC.get("ConversationLine.Type.Thought");
                    break;
                }
                case YELL: {
                    string = TC.get("ConversationLine.Type.Yell");
                    break;
                }
                default: {
                    string = TC.get("ConversationLine.Type.Normal");
                }
            }
            return string + " " + this.toString();
        }

        public static Type getType(String string) {
            if (string.equals(WHISPER.toString())) {
                return WHISPER;
            }
            if (string.equals(THOUGHT.toString())) {
                return THOUGHT;
            }
            if (string.equals(YELL.toString())) {
                return YELL;
            }
            return NORMAL;
        }
    }
}

