/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter.conditions;

import es.eucm.eadventure.common.data.chapter.conditions.Condition;
import java.util.ArrayList;
import java.util.List;

public class Conditions
implements Cloneable {
    private List<List<Condition>> conditionsList = new ArrayList<List<Condition>>();

    public void add(int n, Condition condition) {
        ArrayList<Condition> arrayList = new ArrayList<Condition>();
        arrayList.add(condition);
        this.conditionsList.add(n, arrayList);
    }

    public void add(Condition condition) {
        ArrayList<Condition> arrayList = new ArrayList<Condition>();
        arrayList.add(condition);
        this.conditionsList.add(arrayList);
    }

    public void add(Conditions conditions) {
        this.conditionsList.add(conditions.getSimpleConditions());
    }

    public void add(int n, Conditions conditions) {
        this.conditionsList.add(n, conditions.getSimpleConditions());
    }

    public void add(int n, List<Condition> list) {
        this.conditionsList.add(n, list);
    }

    public void add(List<Condition> list) {
        this.conditionsList.add(list);
    }

    public boolean isEmpty() {
        return this.conditionsList.isEmpty();
    }

    public List<Condition> delete(int n) {
        return this.conditionsList.remove(n);
    }

    public List<Condition> getSimpleConditions() {
        ArrayList<Condition> arrayList = new ArrayList<Condition>();
        for (List<Condition> list : this.conditionsList) {
            if (list.size() != 1) continue;
            arrayList.add(list.get(0));
        }
        return arrayList;
    }

    private List<Conditions> getEitherConditions() {
        ArrayList<Conditions> arrayList = new ArrayList<Conditions>();
        for (List<Condition> list : this.conditionsList) {
            if (list.size() <= 1) continue;
            Conditions conditions = new Conditions();
            for (Condition condition : list) {
                conditions.add(condition);
            }
            arrayList.add(conditions);
        }
        return arrayList;
    }

    public List<List<Condition>> getConditionsList() {
        return this.conditionsList;
    }

    public List<String> getGloblaStateIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (List<Condition> list : this.conditionsList) {
            for (Condition condition : list) {
                if (condition.getType() != 2) continue;
                arrayList.add(condition.getId());
            }
        }
        return arrayList;
    }

    public int getEitherConditionsBlockCount() {
        return this.getEitherConditions().size();
    }

    public List<Condition> getEitherConditions(int n) {
        return this.getEitherConditions().get(n).getSimpleConditions();
    }

    public Conditions getEitherBlock(int n) {
        return this.getEitherConditions().get(n);
    }

    public List<Condition> get(int n) {
        if (n >= 0 && n < this.conditionsList.size()) {
            return this.conditionsList.get(n);
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        Conditions conditions = (Conditions)super.clone();
        conditions.conditionsList = new ArrayList<List<Condition>>();
        for (List<Condition> list : this.conditionsList) {
            ArrayList<Condition> arrayList = new ArrayList<Condition>();
            conditions.add(arrayList);
            for (Condition condition : list) {
                arrayList.add((Condition)condition.clone());
            }
        }
        return conditions;
    }

    public int size() {
        return this.conditionsList.size();
    }
}

