/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter.book;

import es.eucm.eadventure.common.auxiliar.AllElementsWithAssets;
import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.HasId;
import es.eucm.eadventure.common.data.chapter.book.BookPage;
import es.eucm.eadventure.common.data.chapter.book.BookParagraph;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class Book
implements Cloneable,
Documented,
HasId {
    public static final String RESOURCE_TYPE_BACKGROUND = "background";
    public static final String RESOURCE_TYPE_ARROW_LEFT_NORMAL = "arrowLeftNormal";
    public static final String RESOURCE_TYPE_ARROW_RIGHT_NORMAL = "arrowRightNormal";
    public static final String RESOURCE_TYPE_ARROW_LEFT_OVER = "arrowLeftOver";
    public static final String RESOURCE_TYPE_ARROW_RIGHT_OVER = "arrowRightOver";
    public static final int TYPE_PARAGRAPHS = 0;
    public static final int TYPE_PAGES = 1;
    private String id;
    private String documentation;
    private List<Resources> resources;
    private List<BookParagraph> paragraphs;
    private ArrayList<BookPage> pages;
    private Point previousPagePoint;
    private Point nextPagePoint;
    private int type;

    public Point getPreviousPagePoint() {
        return this.previousPagePoint;
    }

    public void setPreviousPagePoint(Point point) {
        this.previousPagePoint = point;
    }

    public Point getNextPagePoint() {
        return this.nextPagePoint;
    }

    public void setNextPagePoint(Point point) {
        this.nextPagePoint = point;
    }

    public Book(String string) {
        this.id = string;
        this.type = 0;
        this.resources = new ArrayList<Resources>();
        this.paragraphs = new ArrayList<BookParagraph>();
        this.pages = new ArrayList();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    public List<Resources> getResources() {
        return this.resources;
    }

    public void addResources(Resources resources) {
        this.resources.add(resources);
    }

    public List<BookParagraph> getParagraphs() {
        return this.paragraphs;
    }

    public void addPage(String string, int n, int n2, boolean bl) {
        BookPage bookPage = new BookPage(string, n, n2, bl);
        this.pages.add(bookPage);
        if (string != null && !string.equals("")) {
            AllElementsWithAssets.addAsset(bookPage);
        }
    }

    public void addPage(String string, int n, int n2, int n3, int n4, int n5, boolean bl) {
        BookPage bookPage = new BookPage(string, n, n2, n3, n4, n5, bl);
        this.pages.add(bookPage);
        if (n != 0 && string != null && !string.equals("")) {
            AllElementsWithAssets.addAsset(bookPage);
        }
    }

    public void addPage(String string, int n) {
        BookPage bookPage = new BookPage(string, n);
        this.pages.add(bookPage);
        if (string != null && !string.equals("")) {
            AllElementsWithAssets.addAsset(bookPage);
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public ArrayList<BookPage> getPageURLs() {
        return this.pages;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public void setDocumentation(String string) {
        this.documentation = string;
    }

    public void addParagraph(BookParagraph bookParagraph) {
        this.paragraphs.add(bookParagraph);
        if (bookParagraph.getType() == 1) {
            AllElementsWithAssets.addAsset(bookParagraph);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Book book = (Book)super.clone();
        book.documentation = this.documentation != null ? new String(this.documentation) : null;
        String string = book.id = this.id != null ? new String(this.id) : null;
        if (this.pages != null) {
            book.pages = new ArrayList();
            for (BookPage cloneable : this.pages) {
                book.pages.add((BookPage)cloneable.clone());
            }
        }
        if (this.paragraphs != null) {
            book.paragraphs = new ArrayList<BookParagraph>();
            for (BookParagraph bookParagraph : this.paragraphs) {
                book.paragraphs.add((BookParagraph)bookParagraph.clone());
            }
        }
        if (this.resources != null) {
            book.resources = new ArrayList<Resources>();
            for (Resources resources : this.resources) {
                book.resources.add((Resources)resources.clone());
            }
        }
        if (this.nextPagePoint != null) {
            book.nextPagePoint = (Point)this.nextPagePoint.clone();
        }
        if (this.previousPagePoint != null) {
            book.previousPagePoint = (Point)this.previousPagePoint.clone();
        }
        book.type = this.type;
        return book;
    }
}

