/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter;

import es.eucm.eadventure.common.data.HasTargetId;
import es.eucm.eadventure.common.data.Positioned;
import es.eucm.eadventure.common.data.chapter.ExitLook;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.effects.Effects;

public class NextScene
implements Cloneable,
HasTargetId,
Positioned {
    public static final int NO_TRANSITION = 0;
    public static final int TOP_TO_BOTTOM = 1;
    public static final int BOTTOM_TO_TOP = 2;
    public static final int LEFT_TO_RIGHT = 3;
    public static final int RIGHT_TO_LEFT = 4;
    public static final int FADE_IN = 5;
    private String nextSceneId;
    private int destinyX;
    private int destinyY;
    private Conditions conditions;
    private Effects effects;
    private Effects postEffects;
    private ExitLook look;
    private int transitionType;
    private int transitionTime;

    public NextScene(String string) {
        this.nextSceneId = string;
        this.destinyX = Integer.MIN_VALUE;
        this.destinyY = Integer.MIN_VALUE;
        this.conditions = new Conditions();
        this.effects = new Effects();
        this.postEffects = new Effects();
        this.transitionType = 0;
        this.transitionTime = 0;
    }

    public NextScene(String string, int n, int n2) {
        this.nextSceneId = string;
        this.destinyX = n;
        this.destinyY = n2;
        this.conditions = new Conditions();
        this.effects = new Effects();
        this.postEffects = new Effects();
        this.transitionType = 0;
        this.transitionTime = 0;
    }

    @Override
    public String getTargetId() {
        return this.nextSceneId;
    }

    public boolean hasPlayerPosition() {
        return this.destinyX != Integer.MIN_VALUE && this.destinyY != Integer.MIN_VALUE;
    }

    @Override
    public int getPositionX() {
        return this.destinyX;
    }

    @Override
    public int getPositionY() {
        return this.destinyY;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public Effects getEffects() {
        return this.effects;
    }

    public Effects getPostEffects() {
        return this.postEffects;
    }

    @Override
    public void setTargetId(String string) {
        this.nextSceneId = string;
    }

    public void setDestinyPosition(int n, int n2) {
        this.setPositionX(n);
        this.setPositionY(n2);
    }

    @Override
    public void setPositionX(int n) {
        this.destinyX = n;
    }

    @Override
    public void setPositionY(int n) {
        this.destinyY = n;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public void setEffects(Effects effects) {
        this.effects = effects;
    }

    public void setPostEffects(Effects effects) {
        this.postEffects = effects;
    }

    public String getExitText() {
        String string = null;
        if (this.look != null) {
            string = this.look.getExitText();
        }
        return string;
    }

    public String getCursorPath() {
        String string = null;
        if (this.look != null) {
            string = this.look.getCursorPath();
        }
        return string;
    }

    public ExitLook getExitLook() {
        return this.look;
    }

    public void setExitLook(ExitLook exitLook) {
        this.look = exitLook;
    }

    public int getTransitionType() {
        return this.transitionType;
    }

    public int getTransitionTime() {
        return this.transitionTime;
    }

    public void setTransitionType(int n) {
        this.transitionType = n;
    }

    public void setTransitionTime(int n) {
        this.transitionTime = n;
    }

    public Object clone() throws CloneNotSupportedException {
        NextScene nextScene = (NextScene)super.clone();
        nextScene.conditions = this.conditions != null ? (Conditions)this.conditions.clone() : null;
        nextScene.destinyX = this.destinyX;
        nextScene.destinyY = this.destinyY;
        nextScene.effects = this.effects != null ? (Effects)this.effects.clone() : null;
        nextScene.look = this.look != null ? (ExitLook)this.look.clone() : null;
        nextScene.nextSceneId = this.nextSceneId != null ? new String(this.nextSceneId) : null;
        nextScene.postEffects = this.postEffects != null ? (Effects)this.postEffects.clone() : null;
        return nextScene;
    }
}

