/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter;

import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.Positioned;
import es.eucm.eadventure.common.data.chapter.ExitLook;
import es.eucm.eadventure.common.data.chapter.InfluenceArea;
import es.eucm.eadventure.common.data.chapter.NextScene;
import es.eucm.eadventure.common.data.chapter.Rectangle;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import java.awt.Point;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.List;

public class Exit
implements Cloneable,
Documented,
Rectangle,
Positioned {
    public static final int NO_TRANSITION = 0;
    public static final int TOP_TO_BOTTOM = 1;
    public static final int BOTTOM_TO_TOP = 2;
    public static final int LEFT_TO_RIGHT = 3;
    public static final int RIGHT_TO_LEFT = 4;
    public static final int FADE_IN = 5;
    private int x;
    private int y;
    private int width;
    private int height;
    private String documentation;
    private List<NextScene> nextScenes;
    private ExitLook defaultExitLook;
    private boolean rectangular;
    private List<Point> points;
    private InfluenceArea influenceArea;
    private String nextSceneId;
    private int destinyX;
    private int destinyY;
    private Conditions conditions;
    private Effects effects;
    private Effects postEffects;
    private Effects notEffects;
    private boolean hasNotEffects;
    private Integer transitionType;
    private Integer transitionTime;

    public Exit(boolean bl, int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.documentation = null;
        this.points = new ArrayList<Point>();
        this.nextScenes = new ArrayList<NextScene>();
        this.rectangular = bl;
        this.influenceArea = new InfluenceArea();
        this.destinyX = Integer.MIN_VALUE;
        this.destinyY = Integer.MIN_VALUE;
        this.conditions = new Conditions();
        this.effects = new Effects();
        this.postEffects = new Effects();
        this.notEffects = new Effects();
        this.hasNotEffects = false;
        this.transitionType = 0;
        this.transitionTime = 0;
        this.defaultExitLook = new ExitLook();
    }

    public Exit(String string) {
        this(false, 0, 0, 20, 20);
        this.nextSceneId = string;
    }

    public String getNextSceneId() {
        return this.nextSceneId;
    }

    public void setNextSceneId(String string) {
        this.nextSceneId = string;
    }

    public int getDestinyX() {
        return this.destinyX;
    }

    public void setDestinyX(int n) {
        this.destinyX = n;
    }

    public int getDestinyY() {
        return this.destinyY;
    }

    public void setDestinyY(int n) {
        this.destinyY = n;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public Effects getEffects() {
        return this.effects;
    }

    public void setEffects(Effects effects) {
        this.effects = effects;
    }

    public Effects getPostEffects() {
        return this.postEffects;
    }

    public void setPostEffects(Effects effects) {
        this.postEffects = effects;
    }

    public Effects getNotEffects() {
        return this.notEffects;
    }

    public void setNotEffects(Effects effects) {
        this.notEffects = effects;
    }

    public Boolean isHasNotEffects() {
        return this.hasNotEffects;
    }

    public void setHasNotEffects(Boolean bl) {
        this.hasNotEffects = bl;
    }

    public Integer getTransitionType() {
        return this.transitionType;
    }

    public void setTransitionType(Integer n) {
        this.transitionType = n;
    }

    public Integer getTransitionTime() {
        return this.transitionTime;
    }

    public void setTransitionTime(Integer n) {
        this.transitionTime = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setNextScenes(List<NextScene> list) {
        this.nextScenes = list;
    }

    @Override
    public int getX() {
        if (this.rectangular) {
            return this.x;
        }
        int n = Integer.MAX_VALUE;
        for (Point point : this.points) {
            if (point.x >= n) continue;
            n = point.x;
        }
        return n;
    }

    @Override
    public int getY() {
        if (this.rectangular) {
            return this.y;
        }
        int n = Integer.MAX_VALUE;
        for (Point point : this.points) {
            if (point.y >= n) continue;
            n = point.y;
        }
        return n;
    }

    @Override
    public int getWidth() {
        if (this.rectangular) {
            return this.width;
        }
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MAX_VALUE;
        for (Point point : this.points) {
            if (point.x > n) {
                n = point.x;
            }
            if (point.x >= n2) continue;
            n2 = point.x;
        }
        return n - n2;
    }

    @Override
    public int getHeight() {
        if (this.rectangular) {
            return this.height;
        }
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MAX_VALUE;
        for (Point point : this.points) {
            if (point.y > n) {
                n = point.y;
            }
            if (point.y >= n2) continue;
            n2 = point.y;
        }
        return n - n2;
    }

    @Override
    public void setValues(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    public List<NextScene> getNextScenes() {
        return this.nextScenes;
    }

    @Override
    public void setDocumentation(String string) {
        this.documentation = string;
    }

    public void addNextScene(NextScene nextScene) {
        this.nextScenes.add(nextScene);
    }

    public ExitLook getDefaultExitLook() {
        return this.defaultExitLook;
    }

    public void setDefaultExitLook(ExitLook exitLook) {
        this.defaultExitLook = exitLook;
    }

    public boolean isPointInside(int n, int n2) {
        if (this.rectangular) {
            return n > this.getX0() && n < this.getX1() && n2 > this.getY0() && n2 < this.getY1();
        }
        Polygon polygon = new Polygon();
        for (Point point : this.getPoints()) {
            polygon.addPoint(point.x, point.y);
        }
        return polygon.contains(n, n2);
    }

    public int getX0() {
        return this.getX();
    }

    public int getX1() {
        return this.getX() + this.getWidth();
    }

    public int getY0() {
        return this.getY();
    }

    public int getY1() {
        return this.getY() + this.getHeight();
    }

    public Object clone() throws CloneNotSupportedException {
        Exit exit = (Exit)super.clone();
        exit.defaultExitLook = this.defaultExitLook != null ? (ExitLook)this.defaultExitLook.clone() : null;
        exit.documentation = this.documentation != null ? new String(this.documentation) : null;
        exit.height = this.height;
        if (this.nextScenes != null) {
            exit.nextScenes = new ArrayList<NextScene>();
            for (NextScene cloneable : this.nextScenes) {
                exit.nextScenes.add((NextScene)cloneable.clone());
            }
        }
        exit.influenceArea = this.influenceArea != null ? (InfluenceArea)this.influenceArea.clone() : null;
        exit.width = this.width;
        exit.x = this.x;
        exit.y = this.y;
        exit.rectangular = this.rectangular;
        if (this.points != null) {
            exit.points = new ArrayList<Point>();
            for (Point point : this.points) {
                exit.points.add((Point)point.clone());
            }
        }
        exit.conditions = this.conditions != null ? (Conditions)this.conditions.clone() : null;
        exit.effects = this.effects != null ? (Effects)this.effects.clone() : null;
        exit.postEffects = this.postEffects != null ? (Effects)this.postEffects.clone() : null;
        exit.notEffects = this.notEffects != null ? (Effects)this.notEffects.clone() : null;
        exit.destinyX = this.destinyX;
        exit.destinyY = this.destinyY;
        exit.hasNotEffects = this.hasNotEffects;
        exit.nextSceneId = this.nextSceneId != null ? new String(this.nextSceneId) : null;
        exit.transitionTime = new Integer(this.transitionTime);
        exit.transitionType = new Integer(this.transitionType);
        return exit;
    }

    @Override
    public boolean isRectangular() {
        return this.rectangular;
    }

    @Override
    public void setRectangular(boolean bl) {
        this.rectangular = bl;
    }

    @Override
    public List<Point> getPoints() {
        return this.points;
    }

    public void addPoint(Point point) {
        this.points.add(point);
    }

    public InfluenceArea getInfluenceArea() {
        return this.influenceArea;
    }

    public void setInfluenceArea(InfluenceArea influenceArea) {
        this.influenceArea = influenceArea;
    }

    public boolean hasPlayerPosition() {
        return this.destinyX != Integer.MIN_VALUE && this.destinyY != Integer.MIN_VALUE;
    }

    @Override
    public int getPositionX() {
        return this.destinyX;
    }

    @Override
    public int getPositionY() {
        return this.destinyY;
    }

    @Override
    public void setPositionX(int n) {
        this.destinyX = n;
    }

    @Override
    public void setPositionY(int n) {
        this.destinyY = n;
    }
}

