/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter;

import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.HasTargetId;
import es.eucm.eadventure.common.data.chapter.InfluenceArea;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;

public class ElementReference
implements Cloneable,
Documented,
HasTargetId {
    private String idTarget;
    private int x;
    private int y;
    private float scale;
    private int layer;
    private String documentation;
    private Conditions conditions;
    private InfluenceArea influenceArea;

    public ElementReference(String string, int n, int n2) {
        this.idTarget = string;
        this.x = n;
        this.y = n2;
        this.scale = 1.0f;
        this.layer = -1;
        this.documentation = null;
        this.conditions = new Conditions();
        this.influenceArea = new InfluenceArea();
    }

    public ElementReference(String string, int n, int n2, int n3) {
        this.idTarget = string;
        this.x = n;
        this.y = n2;
        this.scale = 1.0f;
        this.layer = n3;
        this.documentation = null;
        this.conditions = new Conditions();
        this.influenceArea = new InfluenceArea();
    }

    @Override
    public String getTargetId() {
        return this.idTarget;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float f) {
        this.scale = f;
    }

    @Override
    public void setTargetId(String string) {
        this.idTarget = string;
    }

    public void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    @Override
    public void setDocumentation(String string) {
        this.documentation = string;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int n) {
        this.layer = n;
    }

    public InfluenceArea getInfluenceArea() {
        return this.influenceArea;
    }

    public void setInfluenceArea(InfluenceArea influenceArea) {
        this.influenceArea = influenceArea;
    }

    public Object clone() throws CloneNotSupportedException {
        ElementReference elementReference = (ElementReference)super.clone();
        elementReference.conditions = this.conditions != null ? (Conditions)this.conditions.clone() : null;
        elementReference.documentation = this.documentation != null ? new String(this.documentation) : null;
        elementReference.idTarget = this.idTarget != null ? new String(this.idTarget) : null;
        elementReference.influenceArea = this.influenceArea != null ? (InfluenceArea)this.influenceArea.clone() : null;
        elementReference.layer = this.layer;
        elementReference.scale = this.scale;
        elementReference.x = this.x;
        elementReference.y = this.y;
        return elementReference;
    }
}

