/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.chapter;

import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.HasTargetId;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.effects.Effects;

public class Action
implements Cloneable,
Documented,
HasTargetId {
    public static final int EXAMINE = 0;
    public static final int GRAB = 1;
    public static final int GIVE_TO = 2;
    public static final int USE_WITH = 3;
    public static final int USE = 4;
    public static final int CUSTOM = 5;
    public static final int CUSTOM_INTERACT = 6;
    public static final int TALK_TO = 7;
    public static final int DRAG_TO = 8;
    private int type;
    private String documentation;
    private String idTarget;
    private Conditions conditions;
    private Effects effects;
    private Effects notEffects;
    private boolean activatedNotEffects;
    private Effects clickEffects;
    private boolean activatedClickEffects;
    private boolean needsGoTo;
    private int keepDistance;
    private boolean conditionsAreMeet;

    public Action(int n) {
        this(n, null, new Conditions(), new Effects(), new Effects(), new Effects());
        switch (n) {
            case 0: {
                this.needsGoTo = false;
                this.keepDistance = 0;
                break;
            }
            case 1: {
                this.needsGoTo = true;
                this.keepDistance = 35;
                break;
            }
            case 2: {
                this.needsGoTo = true;
                this.keepDistance = 35;
                break;
            }
            case 3: {
                this.needsGoTo = true;
                this.keepDistance = 35;
                break;
            }
            case 4: {
                this.needsGoTo = true;
                this.keepDistance = 35;
                break;
            }
            case 7: {
                this.needsGoTo = true;
                this.keepDistance = 35;
                break;
            }
            case 8: {
                this.needsGoTo = false;
                this.keepDistance = 0;
                break;
            }
            default: {
                this.needsGoTo = false;
                this.keepDistance = 0;
            }
        }
    }

    public Action(int n, String string) {
        this(n, string, new Conditions(), new Effects(), new Effects(), new Effects());
    }

    public Action(int n, Conditions conditions, Effects effects, Effects effects2) {
        this(n, null, conditions, effects, effects2, new Effects());
    }

    public Action(int n, String string, Conditions conditions, Effects effects, Effects effects2, Effects effects3) {
        this.type = n;
        this.idTarget = string;
        this.conditions = conditions;
        this.effects = effects;
        this.notEffects = effects2;
        this.clickEffects = effects3;
        this.documentation = null;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    @Override
    public String getTargetId() {
        return this.idTarget;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public Effects getEffects() {
        return this.effects;
    }

    @Override
    public void setDocumentation(String string) {
        this.documentation = string;
    }

    @Override
    public void setTargetId(String string) {
        this.idTarget = string;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public void setEffects(Effects effects) {
        this.effects = effects;
    }

    public Boolean isNeedsGoTo() {
        return this.needsGoTo;
    }

    public void setNeedsGoTo(Boolean bl) {
        this.needsGoTo = bl;
    }

    public Integer getKeepDistance() {
        return this.keepDistance;
    }

    public void setKeepDistance(Integer n) {
        this.keepDistance = n;
    }

    public Effects getNotEffects() {
        return this.notEffects;
    }

    public void setNotEffects(Effects effects) {
        this.notEffects = effects;
    }

    public Object clone() throws CloneNotSupportedException {
        Action action = (Action)super.clone();
        action.conditions = this.conditions != null ? (Conditions)this.conditions.clone() : null;
        action.documentation = this.documentation != null ? new String(this.documentation) : null;
        action.effects = this.effects != null ? (Effects)this.effects.clone() : null;
        action.idTarget = this.idTarget != null ? new String(this.idTarget) : null;
        action.keepDistance = this.keepDistance;
        action.needsGoTo = this.needsGoTo;
        action.type = this.type;
        action.notEffects = this.notEffects != null ? (Effects)this.notEffects.clone() : null;
        action.activatedNotEffects = this.activatedNotEffects;
        action.activatedClickEffects = this.activatedClickEffects;
        action.clickEffects = this.clickEffects != null ? (Effects)this.clickEffects.clone() : null;
        action.conditionsAreMeet = this.conditionsAreMeet;
        return action;
    }

    public boolean isActivatedNotEffects() {
        return this.activatedNotEffects;
    }

    public void setActivatedNotEffects(boolean bl) {
        this.activatedNotEffects = bl;
    }

    public boolean isConditionsAreMeet() {
        return this.conditionsAreMeet;
    }

    public void setConditionsAreMeet(boolean bl) {
        this.conditionsAreMeet = bl;
    }

    public Effects getClickEffects() {
        return this.clickEffects;
    }

    public void setClickEffects(Effects effects) {
        this.clickEffects = effects;
    }

    public boolean isActivatedClickEffects() {
        return this.activatedClickEffects;
    }

    public void setActivatedClickEffects(boolean bl) {
        this.activatedClickEffects = bl;
    }
}

