/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.assessment;

import es.eucm.eadventure.common.data.assessment.AssessmentProperty;
import es.eucm.eadventure.common.data.assessment.AssessmentRule;
import es.eucm.eadventure.common.data.assessment.TimedAssessmentEffect;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import java.util.ArrayList;
import java.util.List;

public class TimedAssessmentRule
extends AssessmentRule {
    protected Conditions endConditions;
    protected List<TimedAssessmentEffect> effects = new ArrayList<TimedAssessmentEffect>();
    protected int effectIndex = -1;
    protected boolean isDone = false;
    protected long elapsedTime = 0L;
    protected boolean usesEndConditions = true;
    private long startTime;

    public TimedAssessmentRule(String string, int n, boolean bl) {
        super(string, n, bl);
        this.endConditions = new Conditions();
    }

    public void setInitConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public void setText(String string, int n) {
        if (n >= 0 && n < this.effects.size()) {
            this.effects.get(n).setText(string);
        }
    }

    public void addProperty(AssessmentProperty assessmentProperty, int n) {
        if (n >= 0 && n < this.effects.size()) {
            this.effects.get(n).getAssessmentProperties().add(assessmentProperty);
        }
    }

    public AssessmentProperty getProperty(int n, int n2) {
        if (n2 >= 0 && n2 < this.effects.size()) {
            return this.effects.get(n2).getAssessmentProperties().get(n);
        }
        return null;
    }

    public List<AssessmentProperty> getAssessmentProperties(int n) {
        return this.effects.get(n).getAssessmentProperties();
    }

    public void setMinTime(int n, int n2) {
        if (n2 >= 0 && n2 < this.effects.size()) {
            this.effects.get(n2).setMinTime(n);
        }
    }

    public void setMaxTime(int n, int n2) {
        if (n2 >= 0 && n2 < this.effects.size()) {
            this.effects.get(n2).setMaxTime(n);
        }
    }

    public int getMinTime(int n) {
        if (n >= 0 && n < this.effects.size()) {
            return this.effects.get(n).getMinTime();
        }
        return Integer.MIN_VALUE;
    }

    public int getMaxTime(int n) {
        if (n >= 0 && n < this.effects.size()) {
            return this.effects.get(n).getMaxTime();
        }
        return Integer.MAX_VALUE;
    }

    public int getEffectsCount() {
        return this.effects.size();
    }

    public Conditions getInitConditions() {
        return this.conditions;
    }

    public Conditions getEndConditions() {
        return this.endConditions;
    }

    public void setEndConditions(Conditions conditions) {
        this.endConditions = conditions;
    }

    public List<TimedAssessmentEffect> getEffects() {
        return this.effects;
    }

    public void setEffects(List<TimedAssessmentEffect> list) {
        this.effects = list;
    }

    public void addEffect() {
        ++this.effectIndex;
        this.effects.add(new TimedAssessmentEffect());
    }

    public TimedAssessmentEffect getLastEffect() {
        return this.effects.get(this.effects.size() - 1);
    }

    public void addEffect(int n, int n2) {
        ++this.effectIndex;
        TimedAssessmentEffect timedAssessmentEffect = new TimedAssessmentEffect();
        timedAssessmentEffect.setMinTime(n);
        timedAssessmentEffect.setMaxTime(n2);
        this.effects.add(timedAssessmentEffect);
    }

    @Override
    public void setText(String string) {
        this.setText(string, this.effectIndex);
    }

    @Override
    public void addProperty(AssessmentProperty assessmentProperty) {
        this.addProperty(assessmentProperty, this.effectIndex);
    }

    public boolean isActive() {
        return this.isDone;
    }

    public void ruleStarted(long l) {
        this.isDone = false;
        this.startTime = l;
    }

    public void ruleDone(long l) {
        this.isDone = true;
        this.elapsedTime = l - this.startTime;
        for (TimedAssessmentEffect timedAssessmentEffect : this.effects) {
            if (this.elapsedTime < (long)timedAssessmentEffect.getMinTime().intValue() || this.elapsedTime > (long)timedAssessmentEffect.getMaxTime().intValue()) continue;
            this.effect.properties = timedAssessmentEffect.getAssessmentProperties();
            this.effect.text = "[ELAPSED TIME = " + this.getTimeHhMmSs() + " ] " + timedAssessmentEffect.getText();
            break;
        }
    }

    private String getTimeHhMmSs() {
        String string = "";
        if (this.elapsedTime < 60L && this.elapsedTime >= 0L) {
            string = Long.toString(this.elapsedTime) + "s";
        } else if (this.elapsedTime < 3600L && this.elapsedTime >= 60L) {
            long l = this.elapsedTime / 60L;
            long l2 = this.elapsedTime % 60L;
            string = Long.toString(l) + "m:" + Long.toString(l2) + "s";
        } else if (this.elapsedTime >= 3600L) {
            long l = this.elapsedTime / 3600L;
            long l3 = this.elapsedTime % 3600L / 60L;
            long l4 = this.elapsedTime % 3600L % 60L;
            string = Long.toString(l) + "h:" + Long.toString(l3) + "m:" + Long.toString(l4) + "s";
        }
        return string;
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)super.clone();
        timedAssessmentRule.effectIndex = this.effectIndex;
        if (this.effects != null) {
            timedAssessmentRule.effects = new ArrayList<TimedAssessmentEffect>();
            for (TimedAssessmentEffect timedAssessmentEffect : this.effects) {
                timedAssessmentRule.effects.add((TimedAssessmentEffect)timedAssessmentEffect.clone());
            }
        }
        timedAssessmentRule.elapsedTime = this.elapsedTime;
        timedAssessmentRule.endConditions = this.endConditions != null ? (Conditions)this.endConditions.clone() : null;
        timedAssessmentRule.isDone = this.isDone;
        timedAssessmentRule.usesEndConditions = this.usesEndConditions;
        return timedAssessmentRule;
    }

    public void setUsesEndConditions(boolean bl) {
        this.usesEndConditions = bl;
    }

    public boolean isUsesEndConditions() {
        return this.usesEndConditions;
    }
}

