/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.data.adaptation;

import es.eucm.eadventure.common.data.adaptation.AdaptationRule;
import es.eucm.eadventure.common.data.adaptation.AdaptedState;
import es.eucm.eadventure.common.data.adaptation.ContainsAdaptedState;
import java.util.ArrayList;
import java.util.List;

public class AdaptationProfile
implements Cloneable,
ContainsAdaptedState {
    public static final String EQUALS = "eq";
    public static final String GRATER = "gt";
    public static final String LESS = "lt";
    public static final String GRATER_EQ = "ge";
    public static final String LESS_EQ = "le";
    private String name;
    private List<AdaptationRule> rules;
    private AdaptedState initialState;
    private List<String> flags;
    private List<String> vars;
    private boolean scorm2004;
    private boolean scorm12;

    public AdaptationProfile(List<AdaptationRule> list, AdaptedState adaptedState, String string, boolean bl, boolean bl2) {
        this.name = string;
        this.rules = list;
        this.initialState = adaptedState == null ? new AdaptedState() : adaptedState;
        this.flags = new ArrayList<String>();
        this.vars = new ArrayList<String>();
        this.scorm2004 = bl2;
        this.scorm12 = bl;
    }

    public AdaptationProfile() {
        this.name = null;
        this.rules = new ArrayList<AdaptationRule>();
        this.scorm2004 = false;
        this.scorm12 = false;
        this.flags = new ArrayList<String>();
        this.vars = new ArrayList<String>();
        this.initialState = new AdaptedState();
    }

    public AdaptationProfile(String string) {
        this();
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List<AdaptationRule> getRules() {
        return this.rules;
    }

    public void addRule(AdaptationRule adaptationRule) {
        this.rules.add(adaptationRule);
    }

    public void addRule(AdaptationRule adaptationRule, int n) {
        this.rules.add(n, adaptationRule);
    }

    @Override
    public AdaptedState getAdaptedState() {
        return this.initialState;
    }

    @Override
    public void setAdaptedState(AdaptedState adaptedState) {
        this.initialState = adaptedState;
    }

    public void addFlag(String string) {
        if (!this.flags.contains(string)) {
            this.flags.add(string);
        }
    }

    public void addVar(String string) {
        if (!this.vars.contains(string)) {
            this.vars.add(string);
        }
    }

    public List<String> getFlags() {
        return this.flags;
    }

    public List<String> getVars() {
        return this.vars;
    }

    public void setFlags(List<String> list) {
        this.flags = list;
    }

    public void setVars(List<String> list) {
        this.vars = list;
    }

    public Object clone() throws CloneNotSupportedException {
        AdaptationProfile adaptationProfile = (AdaptationProfile)super.clone();
        adaptationProfile.flags = new ArrayList<String>();
        for (String object : this.flags) {
            adaptationProfile.flags.add(object != null ? new String(object) : null);
        }
        adaptationProfile.initialState = (AdaptedState)this.initialState.clone();
        adaptationProfile.name = this.name != null ? new String(this.name) : null;
        adaptationProfile.rules = new ArrayList<AdaptationRule>();
        for (AdaptationRule adaptationRule : this.rules) {
            adaptationProfile.rules.add((AdaptationRule)adaptationRule.clone());
        }
        adaptationProfile.vars = new ArrayList<String>();
        for (String string : this.vars) {
            adaptationProfile.vars.add(string != null ? new String(string) : null);
        }
        adaptationProfile.scorm12 = this.scorm12;
        adaptationProfile.scorm2004 = this.scorm2004;
        return adaptationProfile;
    }

    public Boolean isScorm2004() {
        return this.scorm2004;
    }

    public void changeToScorm2004Profile() {
        this.scorm2004 = true;
        this.scorm12 = false;
    }

    public Boolean isScorm12() {
        return this.scorm12;
    }

    public void changeToScorm12Profile() {
        this.scorm2004 = false;
        this.scorm12 = true;
    }

    public void changeToNormalProfile() {
        this.scorm2004 = false;
        this.scorm12 = false;
    }

    public static String[] getOperations() {
        return new String[]{"=", ">", "<", ">=", "<="};
    }

    public static String getOpName(Object object) {
        String string = new String("");
        if (object.equals("=")) {
            string = EQUALS;
        } else if (object.equals(">")) {
            string = GRATER;
        } else if (object.equals("<")) {
            string = LESS;
        } else if (object.equals(">=")) {
            string = GRATER_EQ;
        } else if (object.equals("<=")) {
            string = LESS_EQ;
        }
        return string;
    }

    public static String getOpRepresentation(Object object) {
        String string = new String("");
        if (object.equals(EQUALS)) {
            string = "=";
        } else if (object.equals(GRATER)) {
            string = ">";
        } else if (object.equals(LESS)) {
            string = "<";
        } else if (object.equals(GRATER_EQ)) {
            string = ">=";
        } else if (object.equals(LESS_EQ)) {
            string = "<=";
        }
        return string;
    }

    public void setScorm2004(boolean bl) {
        this.scorm2004 = bl;
    }

    public void setScorm12(boolean bl) {
        this.scorm12 = bl;
    }

    public void setInitialState(AdaptedState adaptedState) {
        this.initialState = adaptedState;
    }

    public AdaptedState getInitialState() {
        return this.initialState;
    }

    public void setRules(List<AdaptationRule> list) {
        this.rules = list;
    }
}

