/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.auxiliar;

import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.VoiceManager;
import java.util.TimerTask;

public class TTask
extends TimerTask {
    private String text;
    private boolean end;
    private boolean deallocate;
    private Voice voice;

    public TTask() {
        this.end = true;
    }

    public TTask(String string, String string2) {
        this.text = string2;
        this.deallocate = false;
        this.end = true;
        VoiceManager voiceManager = VoiceManager.getInstance();
        this.voice = voiceManager.getVoice(string);
        this.voice.allocate();
    }

    @Override
    public void run() {
        try {
            this.end = false;
            this.voice.speak(this.text);
            this.end = true;
        }
        catch (IllegalStateException illegalStateException) {
            System.out.println("TTS found one word which can not be processated.");
        }
    }

    @Override
    public boolean cancel() {
        if (!this.deallocate) {
            this.end = true;
            if (this.voice != null) {
                this.voice.deallocate();
            }
            this.deallocate = true;
        }
        return true;
    }

    public boolean isEnd() {
        return this.end;
    }
}

