/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.common.auxiliar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class File
extends java.io.File {
    private static final String CHAPTER = "chapter";
    private static final String DESCRIPTOR = "descriptor.xml";
    private static final String ASSETS = "assets";
    private static final String GUI = "gui";
    private static final String ASSESS = "assessment";
    private static final String ADAPT = "adaptation";
    private static final String CHAPTER_SUFFIX = ".xml";
    private static final String DTD_SUFFIX = ".dtd";
    private static final String JAR_CHECKER = "es.eucm.eadventure";
    private static final String LO_CHECKER = "manifest.xml";
    private static final String EAD_LO_CHECKER = ".jar";
    private static final long serialVersionUID = -756962356996164247L;

    private static String lastSlash(String string) {
        if (string != null && (string.endsWith("/") || string.endsWith("\\"))) {
            return string.substring(0, Math.max(string.lastIndexOf("\\"), string.lastIndexOf("/")));
        }
        return string;
    }

    public File(String string, String string2) {
        super(File.lastSlash(string), string2);
    }

    public File(String string) {
        super(string);
    }

    public File(File file, String string) {
        this(file.getAbsolutePath(), string);
    }

    public static boolean copyTo(java.io.File file, java.io.File file2) {
        boolean bl = true;
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            if (file2.getParentFile() != null && !file2.getParentFile().exists()) {
                file2.getParentFile().mkdirs();
            }
            if (!file2.exists()) {
                file2.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean copyTo(java.io.File file) {
        return File.copyTo(this, file);
    }

    public static boolean copyAllTo(java.io.File file, java.io.File file2) {
        boolean bl = true;
        if (!file.exists()) {
            return false;
        }
        try {
            if (file.isDirectory()) {
                for (java.io.File file3 : file.listFiles()) {
                    File file4;
                    if (file3.isDirectory()) {
                        file4 = new File(file2.getAbsolutePath(), file3.getName() + "/");
                        bl &= File.copyAllTo(file3, file4);
                        continue;
                    }
                    file4 = new File(file2.getAbsolutePath(), file3.getName());
                    boolean bl2 = File.copyTo(file3, file4);
                    bl &= bl2;
                    if (bl2) continue;
                }
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean copyAllTo(java.io.File file) {
        return File.copyAllTo(this, file);
    }

    public boolean create() {
        boolean bl = false;
        if (this.getParentFile() != null && !this.getParentFile().exists()) {
            this.getParentFile().mkdirs();
        }
        if (!this.getName().contains(".") && !this.exists()) {
            bl = this.mkdirs();
        } else if (!this.exists()) {
            try {
                bl = this.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }

    public File[] listFiles() {
        this.create();
        java.io.File[] fileArray = super.listFiles();
        File[] fileArray2 = new File[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray2[i] = new File(fileArray[i].getAbsolutePath());
        }
        return fileArray2;
    }

    public File[] listFiles(FileFilter fileFilter) {
        this.create();
        java.io.File[] fileArray = super.listFiles(fileFilter);
        File[] fileArray2 = new File[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray2[i] = new File(fileArray[i].getAbsolutePath());
        }
        return fileArray2;
    }

    public boolean deleteAll() {
        boolean bl = true;
        if (this.isDirectory()) {
            for (File file : this.listFiles()) {
                if (file.isDirectory()) {
                    bl &= file.deleteAll();
                    continue;
                }
                bl &= file.delete();
            }
            bl &= this.delete();
        }
        return bl;
    }

    public static void zipDirectory(String string, String string2) {
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string2));
            File.zipDir(string, "", zipOutputStream);
            zipOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void zipDir(String string, String string2, ZipOutputStream zipOutputStream) {
        try {
            java.io.File file = new java.io.File(string);
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                java.io.File file2 = new java.io.File(file, stringArray[i]);
                if (file2.isDirectory()) {
                    object = file2.getAbsolutePath();
                    if (string2 != null && !string2.equals("")) {
                        File.zipDir((String)object, string2 + "/" + file2.getName(), zipOutputStream);
                        continue;
                    }
                    File.zipDir((String)object, file2.getName(), zipOutputStream);
                    continue;
                }
                object = new FileInputStream(file2);
                String string3 = file2.getName();
                if (string2 != null && !string2.equals("")) {
                    string3 = string2 + "/" + string3;
                }
                ZipEntry zipEntry = new ZipEntry(string3);
                try {
                    zipOutputStream.putNextEntry(zipEntry);
                    byte[] byArray = new byte[1024];
                    int n = 0;
                    while ((n = ((FileInputStream)object).read(byArray)) != -1) {
                        zipOutputStream.write(byArray, 0, n);
                    }
                }
                catch (ZipException zipException) {
                    // empty catch block
                }
                ((FileInputStream)object).close();
                zipOutputStream.closeEntry();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean importEadventureJar(String string, String string2) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            return File.importEadventureJar(fileInputStream, string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    private static boolean isEadJar(Manifest manifest, JarInputStream jarInputStream) {
        if (manifest == null) {
            JarEntry jarEntry = null;
            try {
                while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                    if (!File.isFileToUnzip(jarEntry.getName())) continue;
                    return true;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return false;
        }
        Attributes attributes = manifest.getMainAttributes();
        return attributes != null && attributes.getValue("Main-Class") != null && attributes.getValue("Main-Class").contains(JAR_CHECKER);
    }

    private static boolean importEadventureJar(FileInputStream fileInputStream, String string) {
        try {
            CheckedInputStream checkedInputStream = new CheckedInputStream(fileInputStream, new Adler32());
            JarInputStream jarInputStream = new JarInputStream(new BufferedInputStream(checkedInputStream));
            Manifest manifest = jarInputStream.getManifest();
            if (File.isEadJar(manifest, jarInputStream)) {
                File.unzipDir(jarInputStream, string, true);
                return true;
            }
            jarInputStream.close();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public static boolean importEadventureLO(String string, String string2) {
        boolean bl = false;
        boolean bl2 = false;
        FileInputStream fileInputStream = null;
        java.io.File file = null;
        try {
            fileInputStream = new FileInputStream(string);
            CheckedInputStream checkedInputStream = new CheckedInputStream(fileInputStream, new Adler32());
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(checkedInputStream));
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                String string3 = zipEntry.getName().substring(0, zipEntry.getName().indexOf("."));
                if (zipEntry.getName().contains(LO_CHECKER)) {
                    bl2 = true;
                    continue;
                }
                if (!zipEntry.getName().endsWith(EAD_LO_CHECKER)) continue;
                bl = true;
                string3 = zipEntry.getName().substring(0, zipEntry.getName().indexOf("."));
                if (string3.contains("/")) {
                    string3 = string3.substring(string3.lastIndexOf("/") + 1);
                }
                file = java.io.File.createTempFile(string3, EAD_LO_CHECKER);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 2048);
                byte[] byArray = new byte[2048];
                while ((n = zipInputStream.read(byArray, 0, 2048)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                file.deleteOnExit();
            }
            return bl && bl2 && File.importEadventureJar(new FileInputStream(file), string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    public static boolean isFileToUnzip(String string) {
        if (string.startsWith(CHAPTER) && string.contains(CHAPTER_SUFFIX)) {
            return true;
        }
        if (string.startsWith(ASSETS) || string.startsWith(GUI) || string.startsWith(ADAPT) || string.startsWith(ASSESS)) {
            return true;
        }
        if (string.contains(DTD_SUFFIX)) {
            return true;
        }
        return string.equals(DESCRIPTOR);
    }

    public static void unzipDir(String string, String string2) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            CheckedInputStream checkedInputStream = new CheckedInputStream(fileInputStream, new Adler32());
            JarInputStream jarInputStream = new JarInputStream(new BufferedInputStream(checkedInputStream));
            File.unzipDir(jarInputStream, string2, false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void unzipDir(JarInputStream jarInputStream, String string, boolean bl) {
        try {
            BufferedOutputStream bufferedOutputStream = null;
            JarEntry jarEntry = null;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                int n;
                boolean bl2 = bl && File.isFileToUnzip(jarEntry.getName()) || !bl;
                if (!bl2) continue;
                byte[] byArray = new byte[2048];
                File file = new File(string, jarEntry.getName());
                file.create();
                if (file.isDirectory()) continue;
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 2048);
                while ((n = jarInputStream.read(byArray, 0, 2048)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            jarInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void mergeZipAndDirToJar(String string, String string2, ZipOutputStream zipOutputStream) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            CheckedInputStream checkedInputStream = new CheckedInputStream(fileInputStream, new Adler32());
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(checkedInputStream));
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                JarEntry jarEntry = new JarEntry(zipEntry.getName());
                zipOutputStream.putNextEntry(jarEntry);
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = zipInputStream.read(byArray)) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
                zipOutputStream.closeEntry();
            }
            zipInputStream.close();
            File.zipDir(string2, "", zipOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addJarContentsToZip(String string, ZipOutputStream zipOutputStream) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(fileInputStream));
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.getName().contains("META-INF/") && !zipEntry.getName().contains("services")) continue;
                try {
                    zipOutputStream.putNextEntry(zipEntry);
                    byte[] byArray = new byte[1024];
                    int n = 0;
                    while ((n = zipInputStream.read(byArray)) != -1) {
                        zipOutputStream.write(byArray, 0, n);
                    }
                    zipOutputStream.closeEntry();
                }
                catch (ZipException zipException) {}
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addFileToZip(File file, String string, ZipOutputStream zipOutputStream) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ZipEntry zipEntry = new ZipEntry(string);
            zipOutputStream.putNextEntry(zipEntry);
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.closeEntry();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

