/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio.urlfetch;

import de.xeinfach.kafenio.urlfetch.Cookie;
import de.xeinfach.kafenio.urlfetch.HTTPHeader;
import de.xeinfach.kafenio.util.Base64Codec;
import de.xeinfach.kafenio.util.LeanLogger;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.StringTokenizer;

public class URLFetch {
    private static LeanLogger log = new LeanLogger("URLFetch.class");
    private String postData = null;
    private String proxyHost = null;
    private int proxyPort = -1;
    private String proxyPassword = null;
    private URL url = null;
    private HashSet requestHeaders = new HashSet();
    private boolean isBinary = false;
    private byte[] responseBody = null;
    private HashSet responseHeaders = new HashSet();
    private String responseStatus = null;
    private HashSet cookies = new HashSet();
    private String authorizationUsername = null;
    private String authorizationPassword = null;
    private String referer = null;

    public void fetch() throws IOException {
        Object var1_1 = null;
        Object var2_2 = null;
        HttpURLConnection httpURLConnection = null;
        StringBuffer stringBuffer = new StringBuffer();
        HTTPHeader hTTPHeader2 = null;
        httpURLConnection = (HttpURLConnection)this.url.openConnection();
        HttpURLConnection.setFollowRedirects(false);
        httpURLConnection.setAllowUserInteraction(true);
        if (this.url.getProtocol().equals("https")) {
            log.debug("HTTPS is not supported.");
        }
        if (this.authorizationUsername != null) {
            this.addHeader(new HTTPHeader("Authorization", "BASIC " + Base64Codec.encode(this.authorizationUsername + ":" + this.authorizationPassword)));
        }
        if (this.proxyHost != null) {
            System.getProperties().put("proxySet", "true");
            System.getProperties().put("proxyHost", this.proxyHost);
            System.getProperties().put("proxyPort", String.valueOf(this.proxyPort));
            if (this.proxyPassword != null && this.proxyPassword.length() > 0) {
                httpURLConnection.setRequestProperty("Proxy-Authorization", "Basic " + Base64Codec.encode(this.proxyPassword));
            }
        }
        for (Object object : this.cookies) {
            if (this.url.getHost().indexOf(((Cookie)object).getDomain()) == -1 || this.url.getFile().indexOf(((Cookie)object).getPath()) == -1) continue;
            stringBuffer.append(((Cookie)object).getKeyValue());
        }
        if (stringBuffer.length() > 0) {
            this.requestHeaders.add(new HTTPHeader("Cookie", stringBuffer.substring(0, stringBuffer.length() - 2)));
        }
        if (this.referer != null && this.getRequestHeader("Referer") == null) {
            this.addHeader(new HTTPHeader("Referer", this.referer));
        }
        for (HTTPHeader hTTPHeader2 : this.requestHeaders) {
            httpURLConnection.setRequestProperty(hTTPHeader2.getKey(), hTTPHeader2.getValue());
        }
        if (this.postData != null) {
            Object object;
            httpURLConnection.setDoOutput(true);
            object = new PrintWriter(httpURLConnection.getOutputStream());
            ((PrintWriter)object).print(this.postData);
            ((PrintWriter)object).close();
        }
        this.setResponseStatus(httpURLConnection.getHeaderField(0));
        int n = 1;
        while (httpURLConnection.getHeaderField(n) != null) {
            this.responseHeaders.add(new HTTPHeader(httpURLConnection.getHeaderFieldKey(n), httpURLConnection.getHeaderField(n)));
            if (httpURLConnection.getHeaderField(++n) == null || httpURLConnection.getHeaderFieldKey(n) == null || httpURLConnection.getHeaderFieldKey(n).compareToIgnoreCase("Set-Cookie") != 0) continue;
            this.addHeader(new HTTPHeader("Cookie", httpURLConnection.getHeaderField(n)));
        }
        byte[] byArray = new byte[128];
        DataInputStream dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
        int n2 = 0;
        int n3 = 0;
        this.responseBody = new byte[0];
        while ((n2 = dataInputStream.read(byArray)) != -1) {
            n3 = this.responseBody.length;
            byte[] byArray2 = this.responseBody;
            this.responseBody = new byte[this.responseBody.length + n2];
            System.arraycopy(byArray2, 0, this.responseBody, 0, byArray2.length);
            System.arraycopy(byArray, 0, this.responseBody, n3, n2);
        }
        if (this.referer == null || this.referer != null && this.getHTTPStatusCode() >= 300 && this.getHTTPStatusCode() < 400) {
            this.setReferer(this.getURL().toString());
        }
    }

    public void flushHeaders() {
        this.requestHeaders.clear();
        this.responseHeaders.clear();
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL uRL) {
        this.url = uRL;
    }

    public void setPOSTData(String string) {
        this.postData = string;
    }

    public String getPOSTData() {
        return this.postData;
    }

    public HTTPHeader getResponseHeader(String string) {
        HTTPHeader hTTPHeader2 = null;
        for (HTTPHeader hTTPHeader2 : this.responseHeaders) {
            if (hTTPHeader2.getKey().compareToIgnoreCase(string) != 0) continue;
            return hTTPHeader2;
        }
        return null;
    }

    public URL getRedirectURL() {
        if (this.getResponseHeader("Location") == null) {
            return null;
        }
        String string = this.getResponseHeader("Location").getValue();
        try {
            if (string.startsWith("http")) {
                return new URL(string);
            }
            return new URL(this.getURL().getProtocol(), this.getURL().getHost(), this.getURL().getPort(), string);
        }
        catch (MalformedURLException malformedURLException) {
            log.debug("not a URL" + malformedURLException.fillInStackTrace());
            return null;
        }
    }

    public HashSet getRequestHeaders() {
        return this.requestHeaders;
    }

    public HTTPHeader getRequestHeader(String string) {
        HTTPHeader hTTPHeader2 = null;
        for (HTTPHeader hTTPHeader2 : this.requestHeaders) {
            if (hTTPHeader2.getKey().compareToIgnoreCase(string) != 0) continue;
            return hTTPHeader2;
        }
        return null;
    }

    public String getRequestMethod() {
        if (this.getPOSTData() == null) {
            return "GET";
        }
        return "POST";
    }

    public String getRequestLine() {
        return this.getRequestMethod() + " " + this.getURL() + " HTTP/1.0";
    }

    public HashSet getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setAuthorization(String string, String string2) {
        this.authorizationUsername = string;
        this.authorizationPassword = string2;
    }

    public void addHeader(HTTPHeader hTTPHeader) {
        if (hTTPHeader.getKey().compareToIgnoreCase("Cookie") == 0) {
            Cookie cookie = new Cookie(hTTPHeader.getValue());
            Cookie cookie22 = null;
            if ("".equals(cookie.getDomain())) {
                cookie.setDomain(this.url.getHost());
            }
            for (Cookie cookie22 : this.cookies) {
                if (!cookie22.getKey().equals(cookie.getKey()) || !cookie22.getDomain().equals(cookie.getDomain()) || !cookie22.getPath().equals(cookie.getPath())) continue;
                this.cookies.remove(cookie22);
                break;
            }
            if (!cookie.getValue().equals("")) {
                this.cookies.add(cookie);
            }
        } else {
            this.requestHeaders.add(hTTPHeader);
        }
    }

    public byte[] getResponseBody() {
        return this.responseBody;
    }

    public String getResponseStatus() {
        return this.responseStatus;
    }

    public void setResponseStatus(String string) {
        this.responseStatus = string;
    }

    public int getHTTPStatusCode() {
        if (this.responseStatus == null) {
            return -1;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.responseStatus, " ");
        stringTokenizer.nextToken();
        return Integer.parseInt(stringTokenizer.nextToken());
    }

    private void setReferer(String string) {
        this.referer = string;
    }

    public void setProxyHost(String string) {
        this.proxyHost = string;
    }

    public void setProxyPort(int n) {
        this.proxyPort = n;
    }

    public void setProxyPassword(String string) {
        this.proxyPassword = string;
    }
}

