/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio.component.dialogs;

import de.xeinfach.kafenio.KafenioPanel;
import de.xeinfach.kafenio.util.LeanLogger;
import de.xeinfach.kafenio.util.Utils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class HyperlinkDialog
extends JDialog
implements ActionListener {
    public static final int INSERT = 0;
    public static final int REMOVE_LINK = 2;
    public static final int CANCEL = 1;
    private JButton insertServerUrlButton;
    private static LeanLogger log = new LeanLogger("HyperlinkDialog.class");
    private KafenioPanel parentKafenio;
    private String url;
    private String target;
    private int option;
    private JTextField nameField;
    private JTextField urlField;
    private JComboBox targetField;
    private Object[] controls;
    private Object[] options;
    private Vector targets;

    public HyperlinkDialog(KafenioPanel kafenioPanel, String string, String string2) {
        this.parentKafenio = kafenioPanel;
        this.url = string;
        this.target = string2;
        log.debug("new HyperlinkDialog created: " + this.url + ";" + this.target);
        this.init();
    }

    public void init() {
        this.nameField = new JTextField(20);
        this.nameField.setText(this.parentKafenio.getTextPane().getSelectedText());
        this.urlField = new JTextField(20);
        this.urlField.setText(this.url);
        this.insertServerUrlButton = new JButton(this.getString("ServerFiles"));
        this.insertServerUrlButton.setActionCommand("openInsertServerDialog");
        this.insertServerUrlButton.addActionListener(this);
        this.targets = new Vector<String>(Arrays.asList("", "_new", "_blank", "_parent", "top"));
        if (this.targets.indexOf(this.target) == -1) {
            this.targets.add(0, this.target);
        }
        this.targetField = new JComboBox(this.targets);
        this.targetField.setSelectedIndex(this.targets.indexOf(this.target));
        this.targetField.setEditable(true);
        this.controls = new Object[]{new JLabel(this.getString("InsertAnchorTextField")), this.nameField, new JLabel(this.getString("InsertAnchorURLField")), this.urlField, this.insertServerUrlButton, new JLabel(this.getString("InsertAnchorTargetField")), this.targetField};
        this.options = Utils.checkNullOrEmpty(this.url) != null ? new String[]{this.getString("InsertAnchorInsertLinkButton"), this.getString("DialogCancel"), this.getString("InsertAnchorRemoveLinkButton")} : new String[]{this.getString("InsertAnchorInsertLinkButton"), this.getString("DialogCancel")};
        this.option = JOptionPane.showOptionDialog(this.parentKafenio, this.controls, this.getString("AnchorDialogTitle"), -1, -1, null, this.options, this.options[0]);
        switch (this.option) {
            case 0: {
                this.url = this.urlField.getText();
                if (this.targetField.getSelectedIndex() > -1) {
                    this.target = (String)this.targets.get(this.targetField.getSelectedIndex());
                }
                log.debug("insert button pressed.");
                break;
            }
            case 1: {
                log.debug("cancel button pressed.");
                break;
            }
            case 2: {
                this.url = "";
                this.target = "";
                log.debug("remove button pressed.");
                break;
            }
            case -1: {
                log.debug("close dialog.");
            }
        }
    }

    public String getTarget() {
        return this.target;
    }

    public String getUrl() {
        return this.url;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("openInsertServerDialog")) {
            this.urlField.setText(this.parentKafenio.insertFile());
        }
    }

    private String getString(String string) {
        return this.parentKafenio.getTranslation(string);
    }

    public int getAction() {
        return this.option;
    }
}

