/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio.component.dialogs;

import de.xeinfach.kafenio.KafenioPanel;
import de.xeinfach.kafenio.component.dialogs.AbstractKafenioDialog;
import de.xeinfach.kafenio.util.LeanLogger;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class FontSelectorDialog
extends AbstractKafenioDialog
implements ItemListener {
    private static LeanLogger log = new LeanLogger("FontSelectorDialog.class");
    private final JComboBox jcmbFontlist;
    private final JTextPane jtpFontPreview;
    private final Object[] panelContents;
    private Vector vcFontnames;
    private KafenioPanel parentKafenio;
    private String fontName;
    private String defaultText;
    private String[] fonts;

    public FontSelectorDialog(KafenioPanel kafenioPanel, String string, boolean bl, String string2, String string3) {
        super(kafenioPanel, string, bl);
        this.defaultText = string3 != null && string3.length() > 0 ? (string3.length() > 24 ? string3.substring(0, 24) : string3) : "aAbBcCdDeEfFgGhH,.0123";
        this.fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.vcFontnames = new Vector(this.fonts.length - 5);
        for (int i = 0; i < this.fonts.length; ++i) {
            if (this.fonts[i].equals("Dialog") || this.fonts[i].equals("DialogInput") || this.fonts[i].equals("Monospaced") || this.fonts[i].equals("SansSerif") || this.fonts[i].equals("Serif")) continue;
            this.vcFontnames.add(this.fonts[i]);
        }
        this.jcmbFontlist = new JComboBox(this.vcFontnames);
        this.jcmbFontlist.addItemListener(this);
        this.jtpFontPreview = new JTextPane();
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        HTMLDocument hTMLDocument = (HTMLDocument)hTMLEditorKit.createDefaultDocument();
        this.jtpFontPreview.setEditorKit(hTMLEditorKit);
        this.jtpFontPreview.setDocument(hTMLDocument);
        this.jtpFontPreview.setMargin(new Insets(4, 4, 4, 4));
        this.jtpFontPreview.setBounds(0, 0, 120, 18);
        this.jtpFontPreview.setText(this.getFontSampleString(this.defaultText));
        this.panelContents = new Object[]{string2, this.jcmbFontlist, kafenioPanel.getTranslation("FontSample"), this.jtpFontPreview};
        this.init(this.panelContents);
    }

    @Override
    public void setDefaultValues(Object object) {
        if (object.equals(this.getButtonLabels()[0])) {
            this.fontName = (String)this.jcmbFontlist.getSelectedItem();
            this.setVisible(false);
        } else {
            this.fontName = null;
            this.setVisible(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.jtpFontPreview.setText(this.getFontSampleString(this.defaultText));
        }
    }

    public FontSelectorDialog(KafenioPanel kafenioPanel, String string, boolean bl, String string2) {
        this(kafenioPanel, string, bl, string2, "");
    }

    public String getFontName() {
        return this.fontName;
    }

    private String getFontSampleString(String string) {
        return "<HTML><BODY><FONT FACE=\"" + this.jcmbFontlist.getSelectedItem() + '\"' + ">" + string + "</FONT></BODY></HTML>";
    }
}

