/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio.component.dialogs;

import de.xeinfach.kafenio.KafenioPanel;
import de.xeinfach.kafenio.component.NameValuePair;
import de.xeinfach.kafenio.util.LeanLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FileDialog
extends JDialog
implements ActionListener {
    private static LeanLogger log = new LeanLogger("FileDialog.class");
    private KafenioPanel parentKafenioPanel;
    private JList fileList;
    private String fileDir = "";
    private Vector files;
    private String selectedFile;

    public FileDialog(KafenioPanel kafenioPanel, String string, Vector vector, String string2, boolean bl) {
        super(kafenioPanel.getFrame(), string2, bl);
        if (string != null && !string.equals("")) {
            string = string + "/";
        }
        this.files = vector;
        this.parentKafenioPanel = kafenioPanel;
        this.init();
    }

    public FileDialog(KafenioPanel kafenioPanel, String string, String[] stringArray, String string2, boolean bl) {
        this(kafenioPanel, string, FileDialog.arrayToVector(stringArray), string2, bl);
    }

    private static Vector arrayToVector(String[] stringArray) {
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(new NameValuePair(stringArray[i]));
            }
        }
        return vector;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("save")) {
            this.hide();
        } else if (actionEvent.getActionCommand().equals("cancel")) {
            this.selectedFile = null;
            this.hide();
        }
    }

    public void init() {
        this.selectedFile = "";
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.setBounds(100, 100, 400, 500);
        this.setDefaultCloseOperation(1);
        this.fileList = new JList(this.files);
        this.fileList.setSelectionMode(0);
        this.fileList.clearSelection();
        ListSelectionModel listSelectionModel = this.fileList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel;
                if (!listSelectionEvent.getValueIsAdjusting() && !(listSelectionModel = FileDialog.this.fileList.getSelectionModel()).isSelectionEmpty()) {
                    FileDialog.this.selectedFile = ((NameValuePair)FileDialog.this.files.get(listSelectionModel.getMinSelectionIndex())).getValue();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.fileList);
        jScrollPane.setAlignmentX(0.0f);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(jScrollPane);
        jPanel.setBorder(BorderFactory.createTitledBorder("Files"));
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("Accept");
        jButton.setActionCommand("save");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("cancel");
        jButton2.addActionListener(this);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "South");
        this.setVisible(true);
    }

    public String getSelectedFile() {
        if (this.selectedFile != null) {
            this.selectedFile = this.fileDir + this.selectedFile;
        }
        return this.selectedFile;
    }
}

