/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio.component;

import de.xeinfach.kafenio.util.LeanLogger;
import gnu.regexp.RE;
import gnu.regexp.REMatch;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class SyntaxPane
extends JTextPane
implements CaretListener {
    private static LeanLogger log = new LeanLogger("SyntaxPane.class");
    private Vector patterns;
    private Cursor waitCursor = Cursor.getPredefinedCursor(3);

    public SyntaxPane() {
        this.setupPatterns();
    }

    private void setupPatterns() {
        this.patterns = new Vector();
        RE rE = this.getRegex("\\b\\w+");
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.black);
        StyleConstants.setBold(simpleAttributeSet, false);
        this.patterns.addElement(new RegExStyle(rE, simpleAttributeSet));
        rE = this.getRegex("<[/a-zA-Z0-9\\s]+");
        simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, new Color(0, 0, 128));
        StyleConstants.setBold(simpleAttributeSet, true);
        this.patterns.addElement(new RegExStyle(rE, simpleAttributeSet));
        rE = this.getRegex(">");
        this.patterns.addElement(new RegExStyle(rE, simpleAttributeSet));
        rE = this.getRegex("\\s[/a-zA-Z0-9]+=");
        simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, new Color(158, 119, 0));
        StyleConstants.setBold(simpleAttributeSet, true);
        this.patterns.addElement(new RegExStyle(rE, simpleAttributeSet));
        rE = this.getRegex("\"[\\x2D;:/.%#?=,\\w\\s]+\"");
        simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.blue);
        StyleConstants.setBold(simpleAttributeSet, false);
        this.patterns.addElement(new RegExStyle(rE, simpleAttributeSet));
    }

    private RE getRegex(String string) {
        try {
            return new RE((Object)string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setMarks(StyledDocument styledDocument, int n, int n2) {
        SwingUtilities.invokeLater(new StyleUpdater(this, styledDocument, n, n2));
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public void setSize(Dimension dimension) {
        if (dimension.width < this.getParent().getSize().width) {
            dimension.width = this.getParent().getSize().width;
        }
        super.setSize(dimension);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        try {
            StyledDocument styledDocument = (StyledDocument)this.getDocument();
            int n = caretEvent.getDot();
            int n2 = styledDocument.getLength();
            String string = styledDocument.getText(0, n2);
            int n3 = string.substring(0, n).lastIndexOf("\n") + 1;
            int n4 = string.indexOf("\n", n);
            if (n4 < 0) {
                n4 = n2;
            }
            this.setMarks(styledDocument, n3, n4 - n3);
        }
        catch (Exception exception) {
            log.warn("something went wrong while updating the caret position.");
        }
    }

    @Override
    public void setText(String string) {
        this.removeCaretListener(this);
        super.setText(string);
        StyledDocument styledDocument = (StyledDocument)this.getDocument();
        this.setMarks(styledDocument, 0, styledDocument.getLength());
        this.setCaretPosition(0);
        this.addCaretListener(this);
    }

    public class RegExStyle {
        private RE p;
        private AttributeSet a;

        public RegExStyle(RE rE, AttributeSet attributeSet) {
            this.p = rE;
            this.a = attributeSet;
        }

        public RE getPattern() {
            return this.p;
        }

        public AttributeSet getStyle() {
            return this.a;
        }

        public void setPattern(RE rE) {
            this.p = rE;
        }

        public void setStyle(AttributeSet attributeSet) {
            this.a = attributeSet;
        }
    }

    private class StyleUpdater
    implements Runnable {
        private StyledDocument doc;
        private int offset;
        private int len;
        private SyntaxPane syntaxPane;

        public StyleUpdater(SyntaxPane syntaxPane2, StyledDocument styledDocument, int n, int n2) {
            this.doc = styledDocument;
            this.offset = n;
            this.len = n2;
            this.syntaxPane = syntaxPane2;
        }

        @Override
        public void run() {
            SyntaxPane.this.setCursor(new Cursor(3));
            this.syntaxPane.removeCaretListener(this.syntaxPane);
            try {
                String string;
                int n = this.doc.getLength();
                if (n > 0 && this.len > 0 && (string = this.doc.getText(this.offset, this.len)) != null && string.length() > 0) {
                    Enumeration enumeration = SyntaxPane.this.patterns.elements();
                    while (enumeration.hasMoreElements()) {
                        RegExStyle regExStyle = (RegExStyle)enumeration.nextElement();
                        REMatch[] rEMatchArray = regExStyle.getPattern().getAllMatches((Object)string);
                        for (int i = 0; i < rEMatchArray.length; ++i) {
                            this.doc.setCharacterAttributes(this.offset + rEMatchArray[i].getStartIndex(), rEMatchArray[i].getEndIndex() - rEMatchArray[i].getStartIndex(), regExStyle.getStyle(), true);
                        }
                    }
                }
            }
            catch (Exception exception) {
                log.warn("StyleUpdater ERROR: " + exception.fillInStackTrace());
            }
            this.syntaxPane.addCaretListener(this.syntaxPane);
            SyntaxPane.this.setCursor(new Cursor(0));
        }
    }
}

