/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio.action;

import de.xeinfach.kafenio.KafenioPanel;
import de.xeinfach.kafenio.component.HTMLUtilities;
import de.xeinfach.kafenio.component.dialogs.SimpleInfoDialog;
import de.xeinfach.kafenio.util.LeanLogger;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class ListAutomationAction
extends HTMLEditorKit.InsertHTMLTextAction {
    private static LeanLogger log = new LeanLogger("ListAutomationAction.class");
    private KafenioPanel parentKafenioPanel;
    private HTML.Tag baseTag;
    private String listType;
    private HTMLUtilities htmlUtilities;

    public ListAutomationAction(KafenioPanel kafenioPanel, String string, HTML.Tag tag) {
        super(string, "", tag, HTML.Tag.LI);
        this.parentKafenioPanel = kafenioPanel;
        this.baseTag = tag;
        this.htmlUtilities = new HTMLUtilities(kafenioPanel);
        log.debug("created new ListAutomationAction.");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            JTextPane jTextPane = this.parentKafenioPanel.getTextPane();
            String string = jTextPane.getSelectedText();
            int n = -1;
            if (string != null) {
                n = string.length();
            }
            if (string == null || n < 1) {
                int n2 = this.parentKafenioPanel.getCaretPosition();
                this.parentKafenioPanel.setCaretPosition(n2);
                if (actionEvent.getActionCommand() != "newListPoint" && (this.htmlUtilities.checkParentsTag(HTML.Tag.OL) || this.htmlUtilities.checkParentsTag(HTML.Tag.UL))) {
                    new SimpleInfoDialog(this.parentKafenioPanel, this.getString("Error"), true, this.getString("ErrorNestedListsNotSupported"));
                    return;
                }
                this.listType = this.baseTag == HTML.Tag.OL ? "ol" : "ul";
                StringBuffer stringBuffer = new StringBuffer();
                if (this.htmlUtilities.checkParentsTag(this.baseTag)) {
                    stringBuffer.append("<li></li>");
                    this.insertHTML(this.parentKafenioPanel.getTextPane(), this.parentKafenioPanel.getExtendedHtmlDoc(), this.parentKafenioPanel.getTextPane().getCaretPosition(), stringBuffer.toString(), 0, 0, HTML.Tag.LI);
                } else {
                    stringBuffer.append("<" + this.listType + "><li></li></" + this.listType + ">&nbsp;");
                    this.insertHTML(this.parentKafenioPanel.getTextPane(), this.parentKafenioPanel.getExtendedHtmlDoc(), this.parentKafenioPanel.getTextPane().getCaretPosition(), stringBuffer.toString(), 0, 0, this.listType.equals("ol") ? HTML.Tag.OL : HTML.Tag.UL);
                }
                this.parentKafenioPanel.refreshOnUpdate();
            } else {
                this.listType = this.baseTag == HTML.Tag.OL ? "ol" : "ul";
                HTMLDocument hTMLDocument = (HTMLDocument)jTextPane.getDocument();
                int n3 = jTextPane.getSelectionStart();
                int n4 = jTextPane.getSelectionEnd();
                String string2 = hTMLDocument.getText(n3, n4 - n3);
                StringBuffer stringBuffer = new StringBuffer();
                String string3 = string2.indexOf("\r") > -1 ? "\r" : "\n";
                StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
                stringBuffer.append("<" + this.listType + ">");
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append("<li>");
                    stringBuffer.append(stringTokenizer.nextToken());
                    stringBuffer.append("</li>");
                }
                stringBuffer.append("</" + this.listType + ">&nbsp;");
                hTMLDocument.remove(n3, n4 - n3);
                this.insertHTML(jTextPane, hTMLDocument, n3, stringBuffer.toString(), 1, 1, null);
                this.parentKafenioPanel.refreshOnUpdate();
            }
        }
        catch (BadLocationException badLocationException) {
            log.error("BadLocationException: " + badLocationException.fillInStackTrace());
        }
        this.parentKafenioPanel.repaint();
    }

    private String getString(String string) {
        return this.parentKafenioPanel.getTranslation(string);
    }
}

