/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio.action;

import de.xeinfach.kafenio.KafenioPanel;
import de.xeinfach.kafenio.util.LeanLogger;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.CSS;

public class IndentAction
extends StyledEditorKit.StyledTextAction {
    private static LeanLogger log = new LeanLogger("IndentAction.class");
    private KafenioPanel parentKafenioPanel;
    private String myActionName;
    private Float currentIndent = null;
    private int newIndent = 0;

    public IndentAction(KafenioPanel kafenioPanel, String string) {
        super(string);
        this.parentKafenioPanel = kafenioPanel;
        this.myActionName = string;
        log.debug("new IndentAction created.");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        JEditorPane jEditorPane = this.getEditor(actionEvent);
        if (jEditorPane != null) {
            JTextPane jTextPane = this.parentKafenioPanel.getTextPane();
            int n = jTextPane.getCaretPosition();
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(jTextPane.getParagraphAttributes());
            this.currentIndent = null;
            if (simpleAttributeSet.getAttribute(CSS.Attribute.MARGIN_LEFT) != null) {
                this.currentIndent = new Float(simpleAttributeSet.getAttribute(CSS.Attribute.MARGIN_LEFT).toString());
            }
            if (this.myActionName.equalsIgnoreCase("deindent")) {
                if (this.currentIndent != null) {
                    this.newIndent = this.currentIndent.intValue() - 30;
                    this.currentIndent = new Float(this.newIndent);
                    if (this.newIndent < 0) {
                        this.newIndent = 0;
                        this.currentIndent = new Float(this.newIndent);
                    }
                    if (this.newIndent == 0) {
                        simpleAttributeSet.removeAttribute(CSS.Attribute.MARGIN_LEFT);
                        this.setParagraphAttributes(jEditorPane, simpleAttributeSet, true);
                    } else {
                        simpleAttributeSet.removeAttribute(CSS.Attribute.MARGIN_LEFT);
                        simpleAttributeSet.addAttribute(StyleConstants.LeftIndent, new Float(this.newIndent));
                        this.setParagraphAttributes(jEditorPane, simpleAttributeSet, true);
                    }
                }
                jEditorPane.repaint();
            } else if (this.myActionName.equalsIgnoreCase("indent")) {
                if (this.currentIndent == null) {
                    this.newIndent = 30;
                } else {
                    this.newIndent = this.currentIndent.intValue() + 30;
                    this.currentIndent = new Float(this.newIndent);
                }
                if (this.newIndent < 0) {
                    this.newIndent = 0;
                    this.currentIndent = new Float(this.newIndent);
                }
                simpleAttributeSet.removeAttribute(CSS.Attribute.MARGIN_LEFT);
                simpleAttributeSet.addAttribute(StyleConstants.LeftIndent, new Float(this.newIndent));
                this.setParagraphAttributes(jEditorPane, simpleAttributeSet, true);
                jEditorPane.repaint();
            }
        }
    }
}

