/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio;

import de.xeinfach.kafenio.KafenioMenuBar;
import de.xeinfach.kafenio.KafenioPanel;
import de.xeinfach.kafenio.interfaces.KafenioPanelConfigurationInterface;
import de.xeinfach.kafenio.util.LeanLogger;
import java.awt.Color;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;

public class KafenioPanelConfiguration
implements KafenioPanelConfigurationInterface {
    private static LeanLogger log = new LeanLogger("KafenioPanelConfiguration.class");
    public static final int STANDALONE_MODE = 0;
    public static final int APPLET_MODE = 1;
    public static final int JWS_MODE = 2;
    private static String defaultToolbar1Items = "NEW,OPEN,SAVE,SEPARATOR,CUT,COPY,PASTE,SEPARATOR,BOLD,ITALIC,UNDERLINE,SEPARATOR,LEFT,CENTER,RIGHT,JUSTIFY,SEPARATOR,STYLESELECT";
    private static String defaultToolbar2Items = "ULIST,OLIST,SEPARATOR,DEINDENT,INDENT,SEPARATOR,ANCHOR,SEPARATOR,IMAGE,SEPARATOR,CLEARFORMATS,SEPARATOR,VIEWSOURCE,SEPARATOR,STRIKE,SUPERSCRIPT,SUBSCRIPT,INSERTCHARACTER,SEPARATOR,FIND,COLOR,TABLE,SEPARATOR";
    private Object kafenioParent = null;
    private String outputmode = null;
    private String contentParameter = null;
    private String postUrl = null;
    private String servletMode = null;
    private String servletUrl = null;
    private boolean unicode = false;
    private String treePilotSystemID = null;
    private String imageDir = null;
    private String fileDir = null;
    private boolean showMenuBar = true;
    private boolean showToolbar2 = true;
    private boolean showToolbar = true;
    private String document = null;
    private String styleSheet = null;
    private String rawDocument = null;
    private URL urlStyleSheet = null;
    private boolean showViewSource = false;
    private boolean showMenuIcons = true;
    private String language = null;
    private String country = null;
    private boolean base64 = false;
    private boolean debugMode = false;
    private String[] styleSheetFileList = null;
    private String codeBase = null;
    private boolean applet = false;
    private Color bgcolor = null;
    private Vector customMenuItems = null;
    private Vector customToolBar1;
    private Vector customToolBar2;
    private int mode = 0;
    private Properties properties = new Properties();

    public KafenioPanelConfiguration() {
        this.customToolBar1 = this.parseToolbarItems(defaultToolbar1Items);
        this.customToolBar2 = this.parseToolbarItems(defaultToolbar2Items);
    }

    @Override
    public boolean isApplet() {
        return this.mode == 1;
    }

    @Override
    public boolean isWebStart() {
        return this.mode == 2;
    }

    @Override
    public boolean isStandalone() {
        return this.mode == 0;
    }

    @Override
    public boolean isBase64() {
        return this.base64;
    }

    @Override
    public Color getBgcolor() {
        return this.bgcolor;
    }

    @Override
    public boolean isDebugMode() {
        return this.debugMode;
    }

    @Override
    public String getCodeBase() {
        return this.codeBase;
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    @Override
    public String getDocument() {
        return this.document;
    }

    @Override
    public boolean isShowMenuIcons() {
        return this.showMenuIcons;
    }

    @Override
    public boolean isShowViewSource() {
        return this.showViewSource;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public String getRawDocument() {
        return this.rawDocument;
    }

    @Override
    public String getStyleSheet() {
        return this.styleSheet;
    }

    @Override
    public String[] getStyleSheetFileList() {
        return this.styleSheetFileList;
    }

    @Override
    public URL getUrlStyleSheet() {
        return this.urlStyleSheet;
    }

    @Override
    public void setMode(int n) {
        this.mode = n;
    }

    @Override
    public void setBase64(boolean bl) {
        this.base64 = bl;
    }

    @Override
    public void setBgcolor(Color color) {
        this.bgcolor = color;
    }

    @Override
    public void setBgcolor(String string) {
        this.bgcolor = this.parseBgColor(string);
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    @Override
    public void setCodeBase(String string) {
        this.codeBase = string;
    }

    @Override
    public void setCountry(String string) {
        this.country = string;
    }

    @Override
    public void setDocument(String string) {
        this.document = string;
    }

    @Override
    public void setShowMenuIcons(boolean bl) {
        this.showMenuIcons = bl;
    }

    @Override
    public void setShowViewSource(boolean bl) {
        this.showViewSource = bl;
    }

    @Override
    public void setLanguage(String string) {
        this.language = string;
    }

    @Override
    public void setRawDocument(String string) {
        this.rawDocument = string;
    }

    @Override
    public void setStyleSheet(String string) {
        this.styleSheet = string;
    }

    @Override
    public void setStyleSheetFileList(String[] stringArray) {
        this.styleSheetFileList = stringArray;
    }

    @Override
    public void setUrlStyleSheet(URL uRL) {
        this.urlStyleSheet = uRL;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public Vector getCustomMenuItems() {
        return this.customMenuItems;
    }

    @Override
    public void setCustomMenuItems(Vector vector) {
        this.customMenuItems = vector;
    }

    @Override
    public void setCustomMenuItems(String string) {
        if (string != null) {
            this.customMenuItems = this.parseMenuItems(string);
        }
    }

    @Override
    public void setShowToolbar(boolean bl) {
        this.showToolbar = bl;
    }

    @Override
    public void setShowToolbar2(boolean bl) {
        this.showToolbar2 = bl;
    }

    @Override
    public void setShowMenuBar(boolean bl) {
        this.showMenuBar = bl;
    }

    @Override
    public boolean isShowMenuBar() {
        return this.showMenuBar;
    }

    @Override
    public boolean isShowToolbar() {
        return this.showToolbar;
    }

    @Override
    public boolean isShowToolbar2() {
        return this.showToolbar2;
    }

    @Override
    public void setImageDir(String string) {
        this.imageDir = string;
    }

    @Override
    public void setFileDir(String string) {
        this.fileDir = string;
    }

    @Override
    public String getFileDir() {
        return this.fileDir;
    }

    @Override
    public String getImageDir() {
        return this.imageDir;
    }

    @Override
    public void setTreePilotSystemID(String string) {
        this.treePilotSystemID = string;
    }

    @Override
    public String getTreePilotSystemID() {
        return this.treePilotSystemID;
    }

    @Override
    public void setServletUrl(String string) {
        this.servletUrl = string;
    }

    @Override
    public String getServletUrl() {
        return this.servletUrl;
    }

    @Override
    public void setServletMode(String string) {
        if (string.equalsIgnoreCase("cgi") || string.equalsIgnoreCase("java")) {
            this.servletMode = string;
        } else if (string == null || "".equals(string) || "none".equalsIgnoreCase(string)) {
            this.servletMode = "cgi";
        } else {
            throw new IllegalArgumentException("Valid arguments: \"cgi\", \"java\", \"none\"");
        }
    }

    @Override
    public void setPostUrl(String string) {
        this.postUrl = string;
    }

    @Override
    public String getPostUrl() {
        return this.postUrl;
    }

    @Override
    public String getServletMode() {
        return this.servletMode;
    }

    @Override
    public void setContentParameter(String string) {
        this.contentParameter = string;
    }

    @Override
    public String getContentParameter() {
        return this.contentParameter;
    }

    @Override
    public void setOutputmode(String string) {
        if ("normal".equalsIgnoreCase(string)) {
            this.outputmode = string.toUpperCase();
        } else if ("off".equalsIgnoreCase(string)) {
            this.outputmode = string.toUpperCase();
        } else if ("base64".equalsIgnoreCase(string)) {
            this.outputmode = string.toUpperCase();
        }
    }

    @Override
    public String getOutputmode() {
        return this.outputmode;
    }

    @Override
    public void setKafenioParent(Object object) {
        this.kafenioParent = object;
    }

    @Override
    public Object getKafenioParent() {
        return this.kafenioParent;
    }

    @Override
    public Vector getCustomToolBar1() {
        return this.customToolBar1;
    }

    @Override
    public Vector getCustomToolBar2() {
        return this.customToolBar2;
    }

    @Override
    public void setCustomToolBar1(Vector vector) {
        this.customToolBar1 = vector;
    }

    @Override
    public void setCustomToolBar1(String string) {
        if (string != null) {
            this.customToolBar1 = this.parseToolbarItems(string);
        }
    }

    @Override
    public void setCustomToolBar2(Vector vector) {
        this.customToolBar2 = vector;
    }

    @Override
    public void setCustomToolBar2(String string) {
        if (string != null) {
            this.customToolBar2 = this.parseToolbarItems(string);
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("codebase: " + this.getCodeBase());
        stringBuffer.append("\ncontent parameter: " + this.getContentParameter());
        stringBuffer.append("\ncountry: " + this.getCountry());
        stringBuffer.append("\ncustom menuitems: " + this.getCustomMenuItems());
        stringBuffer.append("\ntoolbar1: " + this.getCustomToolBar1());
        stringBuffer.append("\ntoolbar2: " + this.getCustomToolBar2());
        stringBuffer.append("\ndocument: " + this.getDocument());
        stringBuffer.append("\nfiledir: " + this.getFileDir());
        stringBuffer.append("\nimagedir: " + this.getImageDir());
        stringBuffer.append("\nparent: " + this.getKafenioParent());
        stringBuffer.append("\nlanguage: " + this.getLanguage());
        stringBuffer.append("\noutputmode: " + this.getOutputmode());
        stringBuffer.append("\npost url: " + this.getPostUrl());
        stringBuffer.append("\nraw document: " + this.getRawDocument());
        stringBuffer.append("\nservlet mode: " + this.getServletMode());
        stringBuffer.append("\nservlet url: " + this.getServletUrl());
        stringBuffer.append("\nstylesheet: " + this.getStyleSheet());
        stringBuffer.append("\nstylesheet file list: " + this.getStyleSheetFileList());
        stringBuffer.append("\ntreepilot sys id: " + this.getTreePilotSystemID());
        stringBuffer.append("\nstylesheet url: " + this.getUrlStyleSheet());
        stringBuffer.append("\nisApplet: " + this.isApplet());
        stringBuffer.append("\nisBase64: " + this.isBase64());
        stringBuffer.append("\nisDebugMode: " + this.isDebugMode());
        stringBuffer.append("\nisShowMenuBar: " + this.isShowMenuBar());
        stringBuffer.append("\nisShowMenuIcons: " + this.isShowMenuIcons());
        stringBuffer.append("\nisShowToolbar: " + this.isShowToolbar());
        stringBuffer.append("\nisShowToolbar2: " + this.isShowToolbar2());
        stringBuffer.append("\nisShowViewSource: " + this.isShowViewSource());
        return stringBuffer.toString();
    }

    @Override
    public Vector parseToolbarItems(String string) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = null;
        if (string != null) {
            stringArray = KafenioPanel.tokenize(string);
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i].toLowerCase());
            }
        }
        if (vector.size() > 0) {
            return vector;
        }
        return null;
    }

    private Vector parseMenuItems(String string) {
        Vector<String> vector = null;
        if (this.isShowMenuBar()) {
            vector = new Vector<String>();
            String[] stringArray = null;
            if (string != null) {
                stringArray = KafenioPanel.tokenize(string.toLowerCase());
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!KafenioMenuBar.getOrderedMenuKeys().contains(stringArray[i])) continue;
                    vector.add(stringArray[i]);
                }
            }
        }
        return vector;
    }

    @Override
    public Color parseBgColor(String string) {
        try {
            return Color.decode(string);
        }
        catch (Exception exception) {
            log.error("bgcolor-parameter not specified. setting background color to system default.");
            return null;
        }
    }

    @Override
    public void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    @Override
    public String getProperty(String string) {
        if (this.properties.getProperty(string) != null) {
            return this.properties.getProperty(string);
        }
        return "";
    }

    @Override
    public boolean isUnicode() {
        return this.unicode;
    }

    @Override
    public void setUnicode(boolean bl) {
        this.unicode = bl;
    }
}

