/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio;

import de.xeinfach.kafenio.KafenioMenuBar;
import de.xeinfach.kafenio.KafenioPanelActions;
import de.xeinfach.kafenio.KafenioPanelConfiguration;
import de.xeinfach.kafenio.KafenioToolBar;
import de.xeinfach.kafenio.component.ExtendedHTMLDocument;
import de.xeinfach.kafenio.component.ExtendedHTMLEditorKit;
import de.xeinfach.kafenio.component.HTMLUtilities;
import de.xeinfach.kafenio.component.ImageFileChooser;
import de.xeinfach.kafenio.component.MutableFilter;
import de.xeinfach.kafenio.component.NameValuePair;
import de.xeinfach.kafenio.component.SyntaxPane;
import de.xeinfach.kafenio.component.dialogs.FileDialog;
import de.xeinfach.kafenio.component.dialogs.PropertiesDialog;
import de.xeinfach.kafenio.component.dialogs.SearchDialog;
import de.xeinfach.kafenio.component.dialogs.SimpleInfoDialog;
import de.xeinfach.kafenio.interfaces.KafenioContainerInterface;
import de.xeinfach.kafenio.interfaces.KafenioPanelConfigurationInterface;
import de.xeinfach.kafenio.interfaces.KafenioPanelInterface;
import de.xeinfach.kafenio.urlfetch.URLFetch;
import de.xeinfach.kafenio.util.Base64Codec;
import de.xeinfach.kafenio.util.HTMLTranslate;
import de.xeinfach.kafenio.util.LeanLogger;
import de.xeinfach.kafenio.util.Translatrix;
import de.xeinfach.kafenio.util.Utils;
import gnu.regexp.RE;
import gnu.regexp.REException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.rtf.RTFEditorKit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class KafenioPanel
extends JPanel
implements ActionListener,
KeyListener,
DocumentListener,
KafenioPanelInterface {
    private static LeanLogger log = new LeanLogger("KafenioPanel.class");
    private static ResourceBundle treepilotProperties;
    private static File currentFile;
    private static final String APP_NAME = "Kafenio";
    private static final String FONTSIZE_KEY = "size";
    private static final boolean USE_FORM_INDICATOR = true;
    private static final String FORM_INDICATOR_COLOR = "#cccccc";
    private static final int INDENT_STEP = 4;
    private JMenuBar jMenuBar;
    private JToolBar toolbar2;
    private JToolBar toolbar1;
    private Container kafenioParent;
    private KafenioMenuBar kafenioMenuBar;
    private KafenioToolBar kafenioToolBar1;
    private KafenioToolBar kafenioToolBar2;
    private KafenioPanelConfiguration kafenioConfig;
    private Frame frameHandler;
    private JTextPane htmlPane;
    private SyntaxPane srcPane;
    private JScrollPane srcScrollPane;
    private JScrollPane htmlScrollPane;
    private JPanel mainPane;
    private JPanel toolbarPanel;
    private ExtendedHTMLEditorKit htmlKit;
    private ExtendedHTMLDocument htmlDoc;
    private StyleSheet styleSheet;
    private UndoManager undoManager;
    private HTMLUtilities htmlUtils = new HTMLUtilities(this);
    private Clipboard sysClipboard;
    protected boolean documentConfirmed = false;
    private SecurityManager secManager;
    protected Translatrix translatrix;
    private int splitPos = 0;
    private String lastSearchFindTerm = null;
    private String lastSearchReplaceTerm = null;
    private boolean lastSearchCaseSetting = false;
    private boolean lastSearchTopSetting = false;
    private int indent = 0;
    private Vector toolbars = new Vector();
    private URLFetch urlFetcher = new URLFetch();
    private RE pattern1 = null;
    private RE pattern2 = null;
    private RE codeBasePattern = null;
    private Hashtable tActions;
    private RedoAction redoAction;
    private UndoAction undoAction;
    private KafenioPanelActions kafenioActions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KafenioPanel(KafenioPanelConfigurationInterface kafenioPanelConfigurationInterface) {
        Object object;
        log.info("1");
        this.kafenioConfig = (KafenioPanelConfiguration)kafenioPanelConfigurationInterface;
        log.info("12");
        this.secManager = System.getSecurityManager();
        if (this.secManager != null) {
            try {
                this.secManager.checkSystemClipboardAccess();
                this.sysClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (SecurityException securityException) {
                this.sysClipboard = null;
            }
            catch (Exception exception) {
                this.sysClipboard = null;
            }
            finally {
                log.debug("System clipboard is not available. Possible reason: no permission.");
            }
        }
        log.info("13");
        this.translatrix = new Translatrix("de.xeinfach.kafenio.LanguageResources");
        log.info("14");
        Locale locale = null;
        log.info("15");
        if (this.kafenioConfig.getLanguage() != null && this.kafenioConfig.getCountry() != null) {
            log.info("16");
            locale = new Locale(this.kafenioConfig.getLanguage(), this.kafenioConfig.getCountry());
            log.info("17");
        }
        this.translatrix.setLocale(locale);
        log.info("18");
        this.kafenioParent = (Container)this.kafenioConfig.getKafenioParent();
        this.frameHandler = new Frame();
        this.toolbarPanel = new JPanel();
        this.kafenioActions = new KafenioPanelActions(this);
        this.undoManager = new UndoManager();
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        this.toolbarPanel = new JPanel();
        log.info("19");
        try {
            treepilotProperties = ResourceBundle.getBundle("de.xeinfach.kafenio.TreePilot");
        }
        catch (MissingResourceException missingResourceException) {
            log.error("MissingResourceException while loading treepilot file: " + missingResourceException.fillInStackTrace());
        }
        this.htmlPane = new JTextPane();
        this.htmlKit = new ExtendedHTMLEditorKit();
        try {
            this.htmlDoc = (ExtendedHTMLDocument)this.htmlKit.createDefaultDocument(new URL(this.getConfig().getCodeBase()));
        }
        catch (Exception exception) {
            this.htmlDoc = (ExtendedHTMLDocument)this.htmlKit.createDefaultDocument();
        }
        this.htmlDoc.putProperty("de.xeinfach.kafenio.docsource", this.getConfig().getCodeBase());
        this.styleSheet = this.htmlDoc.getStyleSheet();
        this.htmlKit.setDefaultCursor(new Cursor(2));
        this.htmlPane.setEditorKit(this.htmlKit);
        this.htmlPane.setDocument(this.htmlDoc);
        this.htmlPane.setMargin(new Insets(0, 0, 0, 0));
        this.htmlPane.addKeyListener(this);
        this.srcPane = new SyntaxPane();
        this.srcPane.setBackground(new Color(255, 255, 255));
        this.srcPane.setSelectionColor(new Color(255, 192, 192));
        this.srcPane.setText(this.htmlPane.getText());
        this.srcPane.getDocument().addDocumentListener(this);
        this.htmlPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                KafenioPanel.this.handleCaretPositionChange(caretEvent);
            }
        });
        this.htmlPane.getDocument().addUndoableEditListener(new CustomUndoableEditListener());
        this.kafenioMenuBar = new KafenioMenuBar(this);
        this.kafenioToolBar1 = new KafenioToolBar(this);
        this.kafenioToolBar2 = new KafenioToolBar(this);
        if (this.getConfig().isShowMenuBar()) {
            this.jMenuBar = this.kafenioConfig.getCustomMenuItems() != null ? this.kafenioMenuBar.createCustomMenuBar(this.kafenioConfig.getCustomMenuItems()) : this.kafenioMenuBar.createDefaultKafenioMenuBar();
            this.kafenioMenuBar.getViewToolbarItem().setSelected(this.getConfig().isShowToolbar() || this.getConfig().isShowToolbar2());
            this.kafenioMenuBar.getViewSourceItem().setSelected(this.getConfig().isShowViewSource());
            if (this.kafenioParent != null) {
                if (this.kafenioParent instanceof JDialog) {
                    ((JDialog)this.kafenioParent).setJMenuBar(this.jMenuBar);
                } else if (this.kafenioParent instanceof JFrame) {
                    ((JFrame)this.kafenioParent).setJMenuBar(this.jMenuBar);
                } else if (this.kafenioParent instanceof KafenioContainerInterface) {
                    ((KafenioContainerInterface)((Object)this.kafenioParent)).setJMenuBar(this.jMenuBar);
                }
            }
        }
        log.debug("config: " + this.getConfig());
        this.toolbarPanel.setLayout(new BorderLayout());
        this.toolbarPanel.setBackground(this.getConfig().getBgcolor());
        if (this.getConfig().isShowToolbar()) {
            this.toolbar1 = this.kafenioToolBar1.createToolbar(this.getConfig().getCustomToolBar1(), this.getConfig().isShowToolbar());
            this.toolbarPanel.add((Component)this.toolbar1, "North");
            this.toolbars.add(this.toolbar1);
        }
        if (this.getConfig().isShowToolbar2()) {
            this.toolbar2 = this.kafenioToolBar2.createToolbar(this.getConfig().getCustomToolBar2(), this.getConfig().isShowToolbar2());
            this.toolbarPanel.add((Component)this.toolbar2, "South");
            this.toolbars.add(this.toolbar2);
        }
        String string = "<html><body></body></html>";
        if (this.kafenioConfig.getRawDocument() != null && this.kafenioConfig.getRawDocument().length() > 0) {
            string = this.kafenioConfig.isBase64() ? Base64Codec.decode(this.kafenioConfig.getRawDocument()) : this.kafenioConfig.getRawDocument();
            string = this.addURLPrefixToImagePath(string);
        }
        this.setDocumentText(string);
        this.htmlPane.setCaretPosition(0);
        this.htmlPane.getDocument().addDocumentListener(this);
        if (this.kafenioConfig.getStyleSheetFileList() != null) {
            try {
                this.loadStyleSheets(this.kafenioConfig.getStyleSheetFileList(), this.kafenioConfig.getCodeBase());
            }
            catch (Exception exception) {
                log.warn("could not load stylesheet file list: " + exception.fillInStackTrace());
            }
        }
        if (this.kafenioConfig.getUrlStyleSheet() != null) {
            object = new String[]{this.kafenioConfig.getUrlStyleSheet().toString()};
            try {
                this.loadStyleSheets((String[])object, this.kafenioConfig.getCodeBase());
            }
            catch (Exception exception) {
                log.warn("could not load stylesheet from url: " + exception.fillInStackTrace());
            }
        }
        if (this.kafenioConfig.getDocument() != null && ((File)(object = new File(this.kafenioConfig.getDocument()))).exists()) {
            try {
                this.openDocument((File)object);
            }
            catch (Exception exception) {
                log.error("Exception in preloading HTML document: " + exception.fillInStackTrace());
            }
        }
        if (this.kafenioConfig.getStyleSheet() != null && ((File)(object = new File(this.kafenioConfig.getStyleSheet()))).exists()) {
            try {
                this.openStyleSheet((File)object);
            }
            catch (Exception exception) {
                log.error("Exception in preloading CSS stylesheet: " + exception.fillInStackTrace());
            }
        }
        this.htmlScrollPane = new JScrollPane(this.htmlPane);
        this.htmlScrollPane.setVerticalScrollBarPolicy(22);
        this.htmlScrollPane.setPreferredSize(new Dimension(400, 400));
        this.htmlScrollPane.setMinimumSize(new Dimension(128, 128));
        this.srcScrollPane = new JScrollPane(this.srcPane);
        this.srcScrollPane.setVerticalScrollBarPolicy(22);
        this.srcScrollPane.setPreferredSize(new Dimension(400, 100));
        this.srcScrollPane.setMinimumSize(new Dimension(64, 64));
        this.mainPane = new JPanel();
        this.mainPane.setLayout(new BorderLayout());
        if (this.kafenioConfig.isShowViewSource()) {
            this.mainPane.add((Component)this.srcScrollPane, "Center");
        } else {
            this.mainPane.add((Component)this.htmlScrollPane, "Center");
        }
        this.registerDocumentStyles();
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolbarPanel, "North");
        this.add((Component)this.mainPane, "Center");
        this.validate();
    }

    @Override
    public JMenuBar getJMenuBar() {
        return this.jMenuBar;
    }

    @Override
    public JToolBar getJToolBar1() {
        return this.toolbar1;
    }

    @Override
    public JToolBar getJToolBar2() {
        return this.toolbar2;
    }

    @Override
    public void setDocumentConfirmed(boolean bl) {
        this.documentConfirmed = bl;
    }

    @Override
    public boolean getDocumentConfirmed() {
        return this.documentConfirmed;
    }

    @Override
    public Hashtable getTActions() {
        if (this.tActions == null) {
            this.tActions = new Hashtable();
            Action[] actionArray = this.htmlPane.getActions();
            for (int i = 0; i < actionArray.length; ++i) {
                Action action = actionArray[i];
                this.tActions.put(action.getValue("Name"), action);
            }
        }
        return this.tActions;
    }

    private String addURLPrefixToImagePath(String string) {
        if (string != null && this.kafenioConfig.getCodeBase() != null && (this.kafenioConfig.getCodeBase().startsWith("http://") || this.kafenioConfig.getCodeBase().startsWith("file://"))) {
            StringBuffer stringBuffer = new StringBuffer(string);
            String string2 = "src=\"";
            int n = stringBuffer.toString().indexOf(string2);
            while (n > -1) {
                int n2 = n + string2.length();
                if (!stringBuffer.substring(n2 + 4, n2 + 7).equalsIgnoreCase("://")) {
                    if (stringBuffer.substring(n2, n2 + 1).equalsIgnoreCase("/")) {
                        stringBuffer.delete(n2, n2 + 1);
                    }
                    stringBuffer.insert(n2, this.kafenioConfig.getCodeBase());
                }
                if ((n = stringBuffer.toString().indexOf(string2, n2 + 1)) != n2) continue;
            }
            return stringBuffer.toString();
        }
        return string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            if (string.equals("newdoc")) {
                SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this, "", true, this.translatrix.getTranslationString("AskNewDocument"), 3);
                String string2 = simpleInfoDialog.getDecisionValue();
                if (string2.equals(this.translatrix.getTranslationString("DialogAccept"))) {
                    this.htmlDoc = this.styleSheet != null ? new ExtendedHTMLDocument(this.styleSheet) : (ExtendedHTMLDocument)this.htmlKit.createDefaultDocument();
                    this.setDocumentText("<HTML><BODY></BODY></HTML>");
                    this.registerDocument(this.htmlDoc);
                    currentFile = null;
                    this.updateTitle();
                }
            } else if (string.equals("openhtml")) {
                this.openDocument(null);
            } else if (string.equals("opencss")) {
                this.openStyleSheet(null);
            } else if (string.equals("openb64")) {
                this.openDocumentBase64(null);
            } else if (string.equals("save")) {
                this.writeOut(currentFile);
                this.updateTitle();
            } else if (string.equals("saveas")) {
                this.writeOut(null);
            } else if (string.equals("savebody")) {
                this.writeOutFragment("body");
            } else if (string.equals("savecontent")) {
                this.postContent(this.getDocumentBody());
            } else if (string.equals("savedocument")) {
                this.postContent(this.getDocumentText());
            } else if (string.equals("confirmcontent")) {
                this.setAsConfirmedAndQuit();
            } else if (string.equals("detachframe")) {
                this.detachFrame();
            } else if (string.equals("savertf")) {
                this.writeOutRTF(this.htmlPane.getStyledDocument());
            } else if (string.equals("saveb64")) {
                this.writeOutBase64(this.getDocumentText());
            } else if (string.equals("textcut")) {
                if (this.srcScrollPane.isShowing() && this.srcPane.hasFocus()) {
                    this.srcPane.cut();
                } else {
                    this.htmlPane.cut();
                }
            } else if (string.equals("textcopy")) {
                if (this.srcScrollPane.isShowing() && this.srcPane.hasFocus()) {
                    this.srcPane.copy();
                } else {
                    this.htmlPane.copy();
                }
            } else if (string.equals("textpaste")) {
                if (this.srcScrollPane.isShowing() && this.srcPane.hasFocus()) {
                    this.srcPane.paste();
                } else {
                    this.htmlPane.paste();
                }
            } else if (string.equals("describe")) {
                log.debug("------------DOCUMENT------------");
                log.debug("Content Type : " + this.htmlPane.getContentType());
                log.debug("Editor Kit   : " + this.htmlPane.getEditorKit());
                log.debug("Doc Tree     :");
                log.debug("");
                this.describeDocument(this.htmlPane.getStyledDocument());
                log.debug("--------------------------------");
                log.debug("");
            } else if (string.equals("describecss")) {
                log.debug("-----------STYLESHEET-----------");
                log.debug("Stylesheet Rules");
                Enumeration<?> enumeration = this.styleSheet.getStyleNames();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    Style style = this.styleSheet.getStyle(string3);
                    log.debug(style.toString());
                }
                log.debug("--------------------------------");
                log.debug("");
            } else if (string.equals("whattags")) {
                log.debug("Caret Position : " + this.htmlPane.getCaretPosition());
                AttributeSet attributeSet = this.htmlPane.getCharacterAttributes();
                Enumeration<?> enumeration = attributeSet.getAttributeNames();
                log.debug("Attributes     : ");
                while (enumeration.hasMoreElements()) {
                    String string4 = enumeration.nextElement().toString();
                    log.debug("                 " + string4 + " | " + attributeSet.getAttribute(string4));
                }
            } else if (string.equals("toggletoolbar")) {
                for (int i = 0; i < this.toolbars.size(); ++i) {
                    JToolBar jToolBar = (JToolBar)this.toolbars.get(i);
                    jToolBar.setVisible(this.kafenioMenuBar.getViewToolbarItem().isSelected());
                }
            } else if (string.equals("viewsource")) {
                this.htmlScrollPane.setCursor(new Cursor(3));
                this.srcScrollPane.setCursor(new Cursor(3));
                this.htmlScrollPane.setCursor(new Cursor(3));
                this.setCursor(new Cursor(3));
                this.toggleSourceWindow();
                this.htmlScrollPane.setCursor(new Cursor(0));
                this.srcScrollPane.setCursor(new Cursor(0));
                this.htmlScrollPane.setCursor(new Cursor(0));
                this.setCursor(new Cursor(0));
            } else if (string.equals("serialize")) {
                this.serializeOut((HTMLDocument)this.htmlPane.getDocument());
            } else if (string.equals("readfromser")) {
                this.serializeIn();
            } else if (string.equals("inserttable")) {
                String[] stringArray = new String[]{"rows", "cols", "border", "cellspacing", "cellpadding", "width"};
                String[] stringArray2 = new String[]{"text", "text", "text", "text", "text", "text"};
                this.insertTable(null, stringArray, stringArray2);
            } else if (string.equals("inserttablerow")) {
                this.insertTableRow();
            } else if (string.equals("inserttablecolumn")) {
                this.insertTableColumn();
            } else if (string.equals("deletetablerow")) {
                this.deleteTableRow();
            } else if (string.equals("deletetablecolumn")) {
                this.deleteTableColumn();
            } else if (string.equals("insertbreak")) {
                this.insertBreak();
            } else if (string.equals("insertlocalimage")) {
                this.insertLocalImage(null);
            } else if (string.equals("insertnbsp")) {
                this.insertNonbreakingSpace();
            } else if (string.equals("insertform")) {
                String[] stringArray = new String[]{"name", "method", "enctype"};
                String[] stringArray3 = new String[]{"text", "combo", "text"};
                String[] stringArray4 = new String[]{"", "POST,GET", "text"};
                this.insertFormElement(HTML.Tag.FORM, "form", null, stringArray, stringArray3, stringArray4, true);
            } else if (string.equals("inserttextfield")) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("type", "text");
                String[] stringArray = new String[]{"name", "value", FONTSIZE_KEY, "maxlength"};
                String[] stringArray5 = new String[]{"text", "text", "text", "text"};
                this.insertFormElement(HTML.Tag.INPUT, "input", hashtable, stringArray, stringArray5, false);
            } else if (string.equals("inserttextarea")) {
                String[] stringArray = new String[]{"name", "rows", "cols"};
                String[] stringArray6 = new String[]{"text", "text", "text"};
                this.insertFormElement(HTML.Tag.TEXTAREA, "textarea", null, stringArray, stringArray6, true);
            } else if (string.equals("insertcheckbox")) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("type", "checkbox");
                String[] stringArray = new String[]{"name", "checked"};
                String[] stringArray7 = new String[]{"text", "bool"};
                this.insertFormElement(HTML.Tag.INPUT, "input", hashtable, stringArray, stringArray7, false);
            } else if (string.equals("insertradiobutton")) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("type", "radio");
                String[] stringArray = new String[]{"name", "checked"};
                String[] stringArray8 = new String[]{"text", "bool"};
                this.insertFormElement(HTML.Tag.INPUT, "input", hashtable, stringArray, stringArray8, false);
            } else if (string.equals("insertpassword")) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("type", "password");
                String[] stringArray = new String[]{"name", "value", FONTSIZE_KEY, "maxlength"};
                String[] stringArray9 = new String[]{"text", "text", "text", "text"};
                this.insertFormElement(HTML.Tag.INPUT, "input", hashtable, stringArray, stringArray9, false);
            } else if (string.equals("insertbutton")) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("type", "button");
                String[] stringArray = new String[]{"name", "value"};
                String[] stringArray10 = new String[]{"text", "text"};
                this.insertFormElement(HTML.Tag.INPUT, "input", hashtable, stringArray, stringArray10, false);
            } else if (string.equals("insertbuttonsubmit")) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("type", "submit");
                String[] stringArray = new String[]{"name", "value"};
                String[] stringArray11 = new String[]{"text", "text"};
                this.insertFormElement(HTML.Tag.INPUT, "input", hashtable, stringArray, stringArray11, false);
            } else if (string.equals("insertbuttonreset")) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("type", "reset");
                String[] stringArray = new String[]{"name", "value"};
                String[] stringArray12 = new String[]{"text", "text"};
                this.insertFormElement(HTML.Tag.INPUT, "input", hashtable, stringArray, stringArray12, false);
            } else if (string.equals("find")) {
                this.doSearch(null, null, false, this.lastSearchCaseSetting, this.lastSearchTopSetting, string);
            } else if (string.equals("findagain")) {
                this.doSearch(this.lastSearchFindTerm, null, false, this.lastSearchCaseSetting, false, string);
            } else if (string.equals("replace")) {
                this.doSearch(null, null, true, this.lastSearchCaseSetting, this.lastSearchTopSetting, string);
            } else if (string.equals("exit")) {
                this.dispose();
            } else if (string.equals("helpabout")) {
                SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this, this.translatrix.getTranslationString("About"), true, this.translatrix.getTranslationString("AboutMessage") + this.translatrix.getTranslationString("Contributors") + this.translatrix.getTranslationString("ContributorNames") + this.translatrix.getTranslationString("Version") + this.translatrix.getTranslationString("VersionNumber"), 1);
            }
        }
        catch (IOException iOException) {
            log.error("IOException in actionPerformed method: " + iOException.fillInStackTrace());
            SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this, this.translatrix.getTranslationString("Error"), true, this.translatrix.getTranslationString("ErrorIOException"), 0);
        }
        catch (BadLocationException badLocationException) {
            log.error("BadLocationException in actionPerformed method: " + badLocationException.fillInStackTrace());
            SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this, this.translatrix.getTranslationString("Error"), true, this.translatrix.getTranslationString("ErrorBadLocationException"), 0);
        }
        catch (NumberFormatException numberFormatException) {
            log.error("NumberFormatException in actionPerformed method: " + numberFormatException.fillInStackTrace());
            SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this, this.translatrix.getTranslationString("Error"), true, this.translatrix.getTranslationString("ErrorNumberFormatException"), 0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error("ClassNotFound Exception in actionPerformed method: " + classNotFoundException.fillInStackTrace());
            SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this, this.translatrix.getTranslationString("Error"), true, this.translatrix.getTranslationString("ErrorClassNotFoundException "), 0);
        }
        catch (RuntimeException runtimeException) {
            log.error("RuntimeException in actionPerformed method: " + runtimeException.fillInStackTrace());
            SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this, this.translatrix.getTranslationString("Error"), true, this.translatrix.getTranslationString("ErrorRuntimeException"), 0);
        }
    }

    @Override
    public void detachFrame() {
        if (this.kafenioParent != null && this.kafenioParent instanceof KafenioContainerInterface) {
            ((KafenioContainerInterface)((Object)this.kafenioParent)).detachFrame();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        log.debug("key-event caught: " + keyEvent);
        int n = this.getCaretPosition();
        int n2 = -1;
        if (keyEvent.getKeyChar() == '\b') {
            try {
                if (n > 0) {
                    String string = this.htmlPane.getSelectedText();
                    if (string != null) {
                        this.htmlPane.replaceSelection("");
                        this.refreshOnUpdate();
                        return;
                    }
                    int n3 = this.htmlDoc.getParagraphElement(n).getStartOffset();
                    if (n3 == this.htmlPane.getSelectionStart()) {
                        boolean bl = true;
                        if (this.htmlUtils.checkParentsTag(HTML.Tag.LI)) {
                            Object object;
                            int n4;
                            Element element = this.htmlUtils.getListItemParent();
                            bl = false;
                            int n5 = element.getStartOffset();
                            if (n5 + 1 < (n4 = element.getEndOffset())) {
                                object = this.htmlPane.getText(n5, n4 - n5).toCharArray();
                                for (int i = 0; i < ((Object)object).length; ++i) {
                                    if (Character.isWhitespace((char)object[i])) continue;
                                    bl = true;
                                }
                            }
                            if (!bl) {
                                object = element.getParentElement();
                                this.htmlUtils.removeTag(element, true);
                                this.setCaretPosition(n3 - 1);
                                return;
                            }
                            this.htmlPane.setCaretPosition(this.htmlPane.getCaretPosition() - 1);
                            this.htmlPane.moveCaretPosition(this.htmlPane.getCaretPosition() - 2);
                            this.htmlPane.replaceSelection("");
                            return;
                        }
                        if (this.htmlUtils.checkParentsTag(HTML.Tag.TABLE)) {
                            this.htmlPane.setCaretPosition(this.htmlPane.getCaretPosition() - 1);
                            keyEvent.consume();
                            return;
                        }
                    }
                    this.htmlPane.replaceSelection("");
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                log.error("BadLocationException in keyTyped method: " + badLocationException.fillInStackTrace());
                SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this, this.translatrix.getTranslationString("Error"), true, this.translatrix.getTranslationString("ErrorBadLocationException"), 0);
            }
        } else if (keyEvent.getKeyChar() == '\n') {
            try {
                if (this.htmlUtils.checkParentsTag(HTML.Tag.UL) | this.htmlUtils.checkParentsTag(HTML.Tag.OL)) {
                    if (keyEvent.isShiftDown()) {
                        log.debug("shift-enter pressed inside list item.");
                    } else {
                        int n6;
                        log.debug("enter pressed inside list item.");
                        Element element = this.htmlUtils.getListItemParent();
                        int n7 = element.getStartOffset();
                        int n8 = element.getEndOffset();
                        char[] cArray = this.getTextPane().getText(n7, n8 - n7).toCharArray();
                        boolean bl = false;
                        for (n6 = 0; n6 < cArray.length; ++n6) {
                            if (Character.isWhitespace(cArray[n6])) continue;
                            bl = true;
                        }
                        if (bl) {
                            n6 = -1;
                            int n9 = cArray.length;
                            do {
                                if (!Character.isLetterOrDigit(cArray[--n9])) continue;
                                n6 = n9;
                            } while (n6 == -1 && n9 >= 0);
                            n9 = n6;
                            do {
                                if (Character.isSpaceChar(cArray[++n9])) continue;
                                n2 = n9 - n6 - 1;
                            } while (n2 == -1 && n9 < cArray.length);
                            if (n2 == -1) {
                                n2 = 0;
                            }
                        }
                        if (element.getStartOffset() == element.getEndOffset() || !bl) {
                            this.manageListElement(element);
                        } else if (this.getCaretPosition() + 1 == element.getEndOffset()) {
                            this.insertListStyle(element);
                            this.setCaretPosition(n - n2);
                        } else {
                            n6 = this.getCaretPosition();
                            String string = this.getTextPane().getText(n6, n8 - n6);
                            this.getTextPane().select(n6, n8 - 1);
                            this.getTextPane().replaceSelection("");
                            this.htmlUtils.insertListElement(string);
                            Element element2 = this.htmlUtils.getListItemParent();
                            this.setCaretPosition(element2.getEndOffset() - 1);
                        }
                    }
                } else if (!keyEvent.isShiftDown()) {
                    this.getKafenioActions().getActionAddParagraph().actionPerformed(new ActionEvent(keyEvent.getSource(), 10, ""));
                }
            }
            catch (BadLocationException badLocationException) {
                log.error("BadLocationException in keyTyped method: " + badLocationException.fillInStackTrace());
                SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this, this.translatrix.getTranslationString("Error"), true, this.translatrix.getTranslationString("ErrorBadLocationException"), 0);
            }
            catch (IOException iOException) {
                log.error("IOException in keyTyped method: " + iOException.fillInStackTrace());
                SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this, this.translatrix.getTranslationString("Error"), true, this.translatrix.getTranslationString("ErrorIOException"), 0);
            }
        } else if (keyEvent.getKeyChar() == ' ') {
            try {
                int n10 = this.getCaretPosition();
                String string = this.getTextPane().getText(n10 - 1, 1);
                if ("&".equals(string)) {
                    this.insertNonbreakingSpace();
                }
            }
            catch (BadLocationException badLocationException) {
                log.error("BadLocationException in keyTyped method: " + badLocationException.fillInStackTrace());
                SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this, this.translatrix.getTranslationString("Error"), true, this.translatrix.getTranslationString("ErrorBadLocationException"), 0);
            }
            catch (IOException iOException) {
                log.error("IOException in keyTyped method: " + iOException.fillInStackTrace());
                SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this, this.translatrix.getTranslationString("Error"), true, this.translatrix.getTranslationString("ErrorIOException"), 0);
            }
        } else if (keyEvent.getKeyChar() == '\u001b' && this.getConfig().getProperty("escapeCloses").equals("true")) {
            this.getKafenioParent().hide();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public void insertListStyle(Element element) throws BadLocationException, IOException {
        if (element.getParentElement().getName() == "ol") {
            this.getKafenioActions().getActionListOrdered().actionPerformed(new ActionEvent(new Object(), 0, "newListPoint"));
        } else {
            this.getKafenioActions().getActionListUnordered().actionPerformed(new ActionEvent(new Object(), 0, "newListPoint"));
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.handleDocumentChange(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.handleDocumentChange(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.handleDocumentChange(documentEvent);
    }

    @Override
    public void handleDocumentChange(DocumentEvent documentEvent) {
    }

    public void registerDocument(ExtendedHTMLDocument extendedHTMLDocument) {
        this.htmlPane.setDocument(extendedHTMLDocument);
        this.htmlPane.getDocument().addUndoableEditListener(new CustomUndoableEditListener());
        this.htmlPane.getDocument().addDocumentListener(this);
        this.purgeUndos();
        this.registerDocumentStyles();
    }

    @Override
    public void registerDocumentStyles() {
        if (this.kafenioToolBar1.getStyleSelector() == null || this.kafenioToolBar2.getStyleSelector() == null || this.htmlDoc == null) {
            return;
        }
        this.kafenioToolBar1.getStyleSelector().setEnabled(false);
        this.kafenioToolBar1.getStyleSelector().removeAllItems();
        this.kafenioToolBar1.getStyleSelector().addItem(this.translatrix.getTranslationString("NoCSSStyle"));
        this.kafenioToolBar2.getStyleSelector().setEnabled(false);
        this.kafenioToolBar2.getStyleSelector().removeAllItems();
        this.kafenioToolBar2.getStyleSelector().addItem(this.translatrix.getTranslationString("NoCSSStyle"));
        Vector<String> vector = new Vector<String>();
        Enumeration<?> enumeration = this.htmlDoc.getStyleNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            if (string.length() <= 0 || string.charAt(0) != '.') continue;
            vector.add(string.substring(1));
        }
        Collections.sort(vector);
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            this.kafenioToolBar1.getStyleSelector().addItem(string);
            this.kafenioToolBar2.getStyleSelector().addItem(string);
        }
        this.kafenioToolBar1.getStyleSelector().setEnabled(true);
        this.kafenioToolBar2.getStyleSelector().setEnabled(true);
    }

    private void insertTable(Hashtable hashtable, String[] stringArray, String[] stringArray2) throws IOException, BadLocationException, RuntimeException, NumberFormatException {
        Object object;
        log.debug("starting insertTable action...");
        int n = this.htmlPane.getCaretPosition();
        StringBuffer stringBuffer = new StringBuffer("<TABLE");
        if (hashtable != null && hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                object = hashtable.get(k);
                if (object == null || object == "") continue;
                stringBuffer.append(" " + k + "=" + '\"' + object + '\"');
            }
        }
        int n2 = 0;
        int n3 = 0;
        if (stringArray != null && stringArray.length > 0) {
            object = new PropertiesDialog(this, stringArray, stringArray2, this.translatrix.getTranslationString("FormDialogTitle"), true);
            String string = ((PropertiesDialog)object).getDecisionValue();
            if (string.equals(this.translatrix.getTranslationString("DialogCancel"))) {
                ((Window)object).dispose();
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = ((PropertiesDialog)object).getFieldValue(string2);
                if (string3 == null || string3 == "" || string3.length() <= 0) continue;
                if (string2.equals("rows")) {
                    n2 = Integer.parseInt(string3);
                    continue;
                }
                if (string2.equals("cols")) {
                    n3 = Integer.parseInt(string3);
                    continue;
                }
                stringBuffer.append(" " + string2 + "=" + '\"' + string3 + '\"');
            }
            ((Window)object).dispose();
        }
        stringBuffer.append(">");
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append("<TR>");
            for (int j = 0; j < n3; ++j) {
                stringBuffer.append("<TD></TD>");
            }
            stringBuffer.append("</TR>");
        }
        stringBuffer.append("</TABLE><P>&nbsp;<P>");
        this.htmlKit.insertHTML(this.htmlDoc, n, stringBuffer.toString(), 0, 0, HTML.Tag.TABLE);
        this.htmlPane.setCaretPosition(n + 1);
        this.refreshOnUpdate();
    }

    private void insertTableRow() {
        int n = this.htmlPane.getCaretPosition();
        Element element = this.htmlDoc.getCharacterElement(this.htmlPane.getCaretPosition());
        int n2 = -1;
        int n3 = -1;
        for (Element element2 = element.getParentElement(); element2 != null && !element2.getName().equals("body"); element2 = element2.getParentElement()) {
            if (!element2.getName().equals("tr")) continue;
            n2 = element2.getStartOffset();
            n3 = element2.getElementCount();
            break;
        }
        if (n2 > -1 && n3 > -1) {
            this.htmlPane.setCaretPosition(n2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<TR>");
            for (int i = 0; i < n3; ++i) {
                stringBuffer.append("<TD></TD>");
            }
            stringBuffer.append("</TR>");
            ActionEvent actionEvent = new ActionEvent(this.htmlPane, 0, "insertTableRow");
            new HTMLEditorKit.InsertHTMLTextAction("insertTableRow", stringBuffer.toString(), HTML.Tag.TABLE, HTML.Tag.TR).actionPerformed(actionEvent);
            this.refreshOnUpdate();
            this.htmlPane.setCaretPosition(n);
        }
    }

    private void insertTableColumn() {
        Element element;
        int n;
        int n2 = this.htmlPane.getCaretPosition();
        Element element2 = this.htmlDoc.getCharacterElement(this.htmlPane.getCaretPosition());
        Element element3 = element2.getParentElement();
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (element3 != null && !element3.getName().equals("body")) {
            if (element3.getName().equals("table")) {
                n3 = element3.getStartOffset();
                n4 = element3.getElementCount();
                break;
            }
            if (element3.getName().equals("tr")) {
                int n6 = element3.getStartOffset();
                int n7 = element3.getElementCount();
                for (n = 0; n < n7; ++n) {
                    element = element3.getElement(n);
                    if (this.htmlPane.getCaretPosition() < element.getStartOffset() || this.htmlPane.getCaretPosition() > element.getEndOffset()) continue;
                    n5 = n;
                }
                element3 = element3.getParentElement();
                continue;
            }
            element3 = element3.getParentElement();
        }
        if (n3 > -1 && n4 > -1) {
            this.htmlPane.setCaretPosition(n3);
            String string = "<TD></TD>";
            ActionEvent actionEvent = new ActionEvent(this.htmlPane, 0, "insertTableCell");
            for (n = 0; n < n4; ++n) {
                element = element3.getElement(n);
                Element element4 = element.getElement(n5);
                this.htmlPane.setCaretPosition(element4.getStartOffset());
                new HTMLEditorKit.InsertHTMLTextAction("insertTableCell", string, HTML.Tag.TR, HTML.Tag.TD, HTML.Tag.TH, HTML.Tag.TD).actionPerformed(actionEvent);
            }
            this.refreshOnUpdate();
            this.htmlPane.setCaretPosition(n2);
        }
    }

    private void insertTableCell() {
        String string = "<TD></TD>";
        ActionEvent actionEvent = new ActionEvent(this.htmlPane, 0, "insertTableCell");
        new HTMLEditorKit.InsertHTMLTextAction("insertTableCell", string, HTML.Tag.TR, HTML.Tag.TD, HTML.Tag.TH, HTML.Tag.TD).actionPerformed(actionEvent);
        this.refreshOnUpdate();
    }

    private void deleteTableRow() throws BadLocationException {
        int n = this.htmlPane.getCaretPosition();
        Element element = this.htmlDoc.getCharacterElement(this.htmlPane.getCaretPosition());
        int n2 = -1;
        int n3 = -1;
        for (Element element2 = element.getParentElement(); element2 != null && !element2.getName().equals("body"); element2 = element2.getParentElement()) {
            if (!element2.getName().equals("tr")) continue;
            n2 = element2.getStartOffset();
            n3 = element2.getEndOffset();
            break;
        }
        if (n2 > -1 && n3 > n2) {
            this.htmlDoc.remove(n2, n3 - n2);
            this.htmlPane.setDocument(this.htmlDoc);
            this.registerDocument(this.htmlDoc);
            this.refreshOnUpdate();
            if (n >= this.htmlDoc.getLength()) {
                n = this.htmlDoc.getLength() - 1;
            }
            this.htmlPane.setCaretPosition(n);
        }
    }

    private void deleteTableColumn() throws BadLocationException {
        int n = this.htmlPane.getCaretPosition();
        Element element = this.htmlDoc.getCharacterElement(this.htmlPane.getCaretPosition());
        Element element2 = null;
        Element element3 = null;
        Element element4 = null;
        for (Element element5 = element.getParentElement(); element5 != null && !element5.getName().equals("body"); element5 = element5.getParentElement()) {
            if (element5.getName().equals("td")) {
                element2 = element5;
                continue;
            }
            if (element5.getName().equals("tr")) {
                element3 = element5;
                continue;
            }
            if (!element5.getName().equals("table")) continue;
            element4 = element5;
        }
        int n2 = -1;
        if (element2 != null && element3 != null && element4 != null) {
            int n3;
            for (n3 = 0; n3 < element3.getElementCount(); ++n3) {
                if (element2 != element3.getElement(n3)) continue;
                n2 = n3;
            }
            if (n2 > -1) {
                for (n3 = 0; n3 < element4.getElementCount(); ++n3) {
                    element3 = element4.getElement(n3);
                    element2 = element3.getElementCount() > n2 ? element3.getElement(n2) : element3.getElement(element3.getElementCount() - 1);
                    int n4 = element2.getStartOffset();
                    int n5 = element2.getEndOffset();
                    this.htmlDoc.remove(n4, n5 - n4);
                }
                this.htmlPane.setDocument(this.htmlDoc);
                this.registerDocument(this.htmlDoc);
                this.refreshOnUpdate();
                if (n >= this.htmlDoc.getLength()) {
                    n = this.htmlDoc.getLength() - 1;
                }
                this.htmlPane.setCaretPosition(n);
            }
        }
    }

    private void insertBreak() throws IOException, BadLocationException, RuntimeException {
        int n = this.htmlPane.getCaretPosition();
        this.htmlKit.insertHTML(this.htmlDoc, n, "<BR>", 0, 0, HTML.Tag.BR);
        this.htmlPane.setCaretPosition(n + 1);
    }

    private void insertNonbreakingSpace() throws IOException, BadLocationException, RuntimeException {
        int n = this.htmlPane.getCaretPosition();
        this.htmlDoc.insertString(n, "\u00a0", this.htmlPane.getInputAttributes());
        this.htmlPane.setCaretPosition(n + 1);
    }

    private void insertFormElement(HTML.Tag tag, String string, Hashtable hashtable, String[] stringArray, String[] stringArray2, String[] stringArray3, boolean bl) throws IOException, BadLocationException, RuntimeException {
        Object object;
        Object object2;
        int n = this.htmlPane.getCaretPosition();
        StringBuffer stringBuffer = new StringBuffer("<" + string);
        if (hashtable != null && hashtable.size() > 0) {
            object2 = hashtable.keys();
            while (object2.hasMoreElements()) {
                object = object2.nextElement();
                Object v = hashtable.get(object);
                if (v == null || v == "") continue;
                stringBuffer.append(" " + object + "=" + '\"' + v + '\"');
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            object2 = new PropertiesDialog(this, stringArray, stringArray2, stringArray3, this.translatrix.getTranslationString("FormDialogTitle"), true);
            object = ((PropertiesDialog)object2).getDecisionValue();
            if (((String)object).equals(this.translatrix.getTranslationString("DialogCancel"))) {
                ((Window)object2).dispose();
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = ((PropertiesDialog)object2).getFieldValue(string2);
                if (string3 == null || string3.length() <= 0) continue;
                if (string2.equals("checked")) {
                    if (!string3.equals("true")) continue;
                    stringBuffer.append(" " + string2 + "=" + '\"' + string3 + '\"');
                    continue;
                }
                stringBuffer.append(" " + string2 + "=" + '\"' + string3 + '\"');
            }
            ((Window)object2).dispose();
        }
        if (string.equals("form")) {
            stringBuffer.append(" bgcolor=\"#cccccc\"");
        }
        stringBuffer.append(">");
        if (bl) {
            stringBuffer.append("</" + string + ">");
        }
        if (tag == HTML.Tag.FORM) {
            stringBuffer.append("<P>&nbsp;</P>");
        }
        this.htmlKit.insertHTML(this.htmlDoc, n, stringBuffer.toString(), 0, 0, tag);
        this.refreshOnUpdate();
    }

    private void insertFormElement(HTML.Tag tag, String string, Hashtable hashtable, String[] stringArray, String[] stringArray2, boolean bl) throws IOException, BadLocationException, RuntimeException {
        this.insertFormElement(tag, string, hashtable, stringArray, stringArray2, new String[stringArray.length], bl);
    }

    @Override
    public void manageListElement(Element element) {
        Element element2 = this.htmlUtils.getListItemParent();
        Element element3 = element2.getParentElement();
        if (element2 != null) {
            this.htmlUtils.removeTag(element2, true);
        }
    }

    private void doSearch(String string, String string2, boolean bl, boolean bl2, boolean bl3, String string3) {
        boolean bl4 = false;
        JTextPane jTextPane = this.htmlPane;
        if (this.srcScrollPane.isShowing() || this.srcPane.hasFocus()) {
            jTextPane = this.srcPane;
        }
        if (string3.equals("find") || string3.equals("replace")) {
            SearchDialog searchDialog = new SearchDialog(this, this.translatrix.getTranslationString("SearchDialogTitle"), true, bl, bl2, bl3, string, string2);
            string = searchDialog.getFindTerm();
            string2 = searchDialog.getReplaceTerm();
            bl2 = searchDialog.getCaseSensitive();
            bl3 = searchDialog.getStartAtTop();
            bl4 = searchDialog.getReplaceAll();
        }
        if (!(string == null || bl && string2 == null)) {
            if (bl4) {
                int n = this.findText(string, string2, bl2, 0);
                int n2 = 0;
                if (n > -1) {
                    while (n > -1) {
                        n = this.findText(string, string2, bl2, n2 += string2.length());
                    }
                } else {
                    SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this, "", true, this.translatrix.getTranslationString("ErrorNoOccurencesFound") + ":\n" + string, 2);
                }
            } else {
                int n = this.findText(string, string2, bl2, bl3 ? 0 : jTextPane.getCaretPosition());
                if (n == -1) {
                    SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this, "", true, this.translatrix.getTranslationString("ErrorNoMatchFound") + ":\n" + string, 2);
                }
            }
            this.lastSearchFindTerm = new String(string);
            this.lastSearchReplaceTerm = string2 != null ? new String(string2) : (String)null;
            this.lastSearchCaseSetting = bl2;
            this.lastSearchTopSetting = bl3;
        }
    }

    private int findText(String string, String string2, boolean bl, int n) {
        JTextPane jTextPane = this.srcScrollPane.isShowing() || this.srcPane.hasFocus() ? this.srcPane : this.htmlPane;
        int n2 = -1;
        try {
            Document document = jTextPane.getDocument();
            n2 = bl ? document.getText(0, document.getLength()).indexOf(string, n) : document.getText(0, document.getLength()).toLowerCase().indexOf(string.toLowerCase(), n);
            if (n2 > -1) {
                if (string2 != null) {
                    AttributeSet attributeSet = null;
                    if (document instanceof HTMLDocument) {
                        Element element = ((HTMLDocument)document).getCharacterElement(n2);
                        attributeSet = element.getAttributes();
                    }
                    document.remove(n2, string.length());
                    document.insertString(n2, string2, attributeSet);
                    jTextPane.setCaretPosition(n2 + string2.length());
                    jTextPane.requestFocus();
                    jTextPane.select(n2, n2 + string2.length());
                } else {
                    jTextPane.setCaretPosition(n2 + string.length());
                    jTextPane.requestFocus();
                    jTextPane.select(n2, n2 + string.length());
                }
            }
        }
        catch (BadLocationException badLocationException) {
            log.error("BadLocationException in actionPerformed method: " + badLocationException.fillInStackTrace());
            SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this, this.translatrix.getTranslationString("Error"), true, this.translatrix.getTranslationString("ErrorBadLocationException"), 0);
        }
        return n2;
    }

    protected void insertLocalImage(File file) throws IOException, BadLocationException, RuntimeException {
        if (file == null) {
            file = this.getImageFromChooser(".", MutableFilter.EXT_IMG, this.translatrix.getTranslationString("FiletypeIMG"));
        }
        if (file != null) {
            int n = this.htmlPane.getCaretPosition();
            this.htmlKit.insertHTML(this.htmlDoc, n, "<IMG SRC=\"" + file + "\">", 0, 0, HTML.Tag.IMG);
            this.htmlPane.setCaretPosition(n + 1);
            this.refreshOnUpdate();
        }
    }

    @Override
    public String insertFile() {
        String string = null;
        if (this.kafenioConfig.getServletUrl() != null) {
            try {
                Vector<NameValuePair> vector = new Vector<NameValuePair>();
                if (this.kafenioConfig.getServletMode().equalsIgnoreCase("cgi")) {
                    String string2;
                    Vector vector2 = new Vector();
                    String string3 = this.kafenioConfig.getServletUrl().indexOf("?") >= 0 ? "&" : "?";
                    URL uRL = new URL(this.kafenioConfig.getServletUrl() + string3 + "GetFiles=true&FileExtensions=" + treepilotProperties.getString("ValidFileExtensions"));
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setAllowUserInteraction(true);
                    uRLConnection.setDoOutput(false);
                    uRLConnection.setDoInput(true);
                    uRLConnection.setUseCaches(false);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                    this.kafenioConfig.setFileDir(bufferedReader.readLine());
                    while ((string2 = bufferedReader.readLine()) != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
                        Vector<String> vector3 = new Vector<String>();
                        while (stringTokenizer.hasMoreTokens()) {
                            vector3.add(stringTokenizer.nextToken());
                        }
                        if (vector3.size() == 2) {
                            vector.add(new NameValuePair(vector3.get(0).toString(), vector3.get(1).toString()));
                            continue;
                        }
                        if (vector3.size() != 1) continue;
                        vector.add(new NameValuePair(vector3.get(0).toString()));
                    }
                    bufferedReader.close();
                    int n = this.htmlPane.getCaretPosition();
                    if (vector != null && vector.size() > 0) {
                        FileDialog fileDialog = new FileDialog(this, this.kafenioConfig.getFileDir() + this.kafenioConfig.getTreePilotSystemID(), vector, "File Chooser", true);
                        string = fileDialog.getSelectedFile();
                        fileDialog.dispose();
                    }
                } else if (this.kafenioConfig.getServletMode().equalsIgnoreCase("java")) {
                    String[] stringArray = null;
                    URL uRL = new URL(this.kafenioConfig.getServletUrl() + "?GetFiles=" + this.kafenioConfig.getTreePilotSystemID() + "&FileExtensions=" + treepilotProperties.getString("ValidFileExtensions"));
                    URLConnection uRLConnection = uRL.openConnection();
                    ObjectInputStream objectInputStream = new ObjectInputStream(uRLConnection.getInputStream());
                    stringArray = (String[])objectInputStream.readObject();
                    int n = this.htmlPane.getCaretPosition();
                    if (stringArray != null && stringArray.length > 0) {
                        FileDialog fileDialog = new FileDialog(this, this.kafenioConfig.getFileDir() + this.kafenioConfig.getTreePilotSystemID(), stringArray, "File Chooser", true);
                        string = fileDialog.getSelectedFile();
                        fileDialog.dispose();
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                log.error("MalFormedURLException during insertFile: " + malformedURLException);
            }
            catch (IOException iOException) {
                log.error("IOException during insertFile: " + iOException);
            }
            catch (Exception exception) {
                log.error("Exception during insertFile: " + exception);
            }
        }
        return string;
    }

    protected void writeOut(File file) throws IOException, BadLocationException {
        if (file == null) {
            file = this.getFileFromChooser(".", 1, MutableFilter.EXT_HTML, this.translatrix.getTranslationString("FiletypeHTML"));
        }
        if (file != null) {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(this.getDocumentText(), 0, this.getDocumentText().length());
            fileWriter.flush();
            fileWriter.close();
            currentFile = file;
            this.updateTitle();
            this.refreshOnUpdate();
        }
    }

    private void writeOutFragment(String string) throws IOException, BadLocationException {
        File file = this.getFileFromChooser(".", 1, MutableFilter.EXT_HTML, this.translatrix.getTranslationString("FiletypeHTML"));
        if (file != null) {
            FileWriter fileWriter = new FileWriter(file);
            String string2 = this.getSubText("body", this.srcPane.getText());
            fileWriter.write(string2, 0, string2.length());
            fileWriter.flush();
            fileWriter.close();
            this.refreshOnUpdate();
        }
    }

    private void writeOutRTF(StyledDocument styledDocument) throws IOException, BadLocationException {
        File file = this.getFileFromChooser(".", 1, MutableFilter.EXT_RTF, this.translatrix.getTranslationString("FiletypeRTF"));
        if (file != null) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            RTFEditorKit rTFEditorKit = new RTFEditorKit();
            rTFEditorKit.write(fileOutputStream, (Document)styledDocument, 0, styledDocument.getLength());
            fileOutputStream.flush();
            fileOutputStream.close();
            this.refreshOnUpdate();
        }
    }

    private void writeOutBase64(String string) throws IOException, BadLocationException {
        File file = this.getFileFromChooser(".", 1, MutableFilter.EXT_BASE64, this.translatrix.getTranslationString("FiletypeB64"));
        if (file != null) {
            String string2 = Base64Codec.encode(string);
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string2, 0, string2.length());
            fileWriter.flush();
            fileWriter.close();
            this.refreshOnUpdate();
        }
    }

    protected void openDocument(File file) throws IOException, BadLocationException {
        if (file == null) {
            file = this.getFileFromChooser(".", 0, MutableFilter.EXT_HTML, this.translatrix.getTranslationString("FiletypeHTML"));
        }
        if (file != null) {
            try {
                this.loadDocument(file, null);
            }
            catch (ChangedCharSetException changedCharSetException) {
                int n;
                String string = changedCharSetException.getCharSetSpec().toLowerCase();
                if (n == -1) {
                    throw changedCharSetException;
                }
                for (n = string.indexOf("charset"); n < string.length() && string.charAt(n) != '='; ++n) {
                }
                String string2 = string.substring(++n).trim();
                this.loadDocument(file, string2);
            }
            this.refreshOnUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDocument(File file, String string) throws IOException, BadLocationException {
        Reader reader = null;
        currentFile = file;
        this.htmlDoc = (ExtendedHTMLDocument)this.htmlKit.createDefaultDocument();
        try {
            if (string == null) {
                reader = new InputStreamReader(new FileInputStream(file));
            } else {
                reader = new InputStreamReader((InputStream)new FileInputStream(file), string);
                this.htmlDoc.putProperty("IgnoreCharsetDirective", new Boolean(true));
            }
            this.htmlKit.read(reader, (Document)this.htmlDoc, 0);
            reader.close();
            this.registerDocument(this.htmlDoc);
            this.srcPane.setText(this.htmlPane.getText());
            this.updateTitle();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openDocumentBase64(File file) throws IOException, BadLocationException {
        if (file == null) {
            file = this.getFileFromChooser(".", 0, MutableFilter.EXT_BASE64, this.translatrix.getTranslationString("FiletypeB64"));
        }
        if (file != null) {
            FileReader fileReader = new FileReader(file);
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            try {
                while ((n = fileReader.read()) != -1) {
                    stringBuffer.append((char)n);
                }
                fileReader.close();
                this.setDocumentText(this.addURLPrefixToImagePath(Base64Codec.decode(stringBuffer.toString())));
                this.registerDocument((ExtendedHTMLDocument)this.htmlPane.getDocument());
            }
            finally {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
        }
    }

    private void openStyleSheet(File file) throws IOException {
        if (file == null) {
            file = this.getFileFromChooser(".", 0, MutableFilter.EXT_CSS, this.translatrix.getTranslationString("FiletypeCSS"));
        }
        if (file != null) {
            String string = this.htmlPane.getText();
            this.htmlDoc = (ExtendedHTMLDocument)this.htmlKit.createDefaultDocument();
            this.styleSheet = this.htmlDoc.getStyleSheet();
            URL uRL = file.toURL();
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            this.styleSheet.loadRules(bufferedReader, uRL);
            bufferedReader.close();
            this.htmlDoc = new ExtendedHTMLDocument(this.styleSheet);
            this.registerDocument(this.htmlDoc);
            this.setDocumentText(string);
            this.refreshOnUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStyleSheets(String[] stringArray, String string) throws IOException {
        if (stringArray != null) {
            String string2 = this.htmlPane.getText();
            this.htmlDoc = (ExtendedHTMLDocument)this.htmlKit.createDefaultDocument();
            this.styleSheet = this.htmlDoc.getStyleSheet();
            for (int i = 0; i < stringArray.length; ++i) {
                log.debug("loading stylesheet file: " + stringArray[i]);
                boolean bl = false;
                InputStream inputStream = null;
                InputStreamReader inputStreamReader = null;
                BufferedReader bufferedReader = null;
                try {
                    URL uRL = new URL(stringArray[i]);
                    inputStream = uRL.openStream();
                    inputStreamReader = new InputStreamReader(inputStream);
                    bufferedReader = new BufferedReader(inputStreamReader);
                    this.styleSheet.loadRules(bufferedReader, uRL);
                    bufferedReader.close();
                    continue;
                }
                catch (Exception exception) {
                    log.debug("file could not be found, trying again using codebase: " + exception.fillInStackTrace());
                    try {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        try {
                            inputStreamReader.close();
                        }
                        catch (Exception exception3) {
                            // empty catch block
                        }
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception4) {
                            // empty catch block
                        }
                        log.debug("done closing streams");
                        URL uRL = new URL(string + stringArray[i]);
                        inputStream = uRL.openStream();
                        inputStreamReader = new InputStreamReader(inputStream);
                        bufferedReader = new BufferedReader(inputStreamReader);
                        this.styleSheet.loadRules(bufferedReader, uRL);
                        log.debug("done loading css file...");
                        continue;
                    }
                    catch (Exception exception5) {
                        log.warn("file could not be found: " + exception5.fillInStackTrace());
                        continue;
                    }
                    finally {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception6) {}
                        try {
                            inputStreamReader.close();
                        }
                        catch (Exception exception7) {}
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception8) {}
                    }
                }
                finally {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {}
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception exception) {}
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                    log.debug("done closing streams");
                }
            }
            this.htmlDoc = this.styleSheet == null ? new ExtendedHTMLDocument() : new ExtendedHTMLDocument(this.styleSheet);
            if (this.htmlDoc == null) {
                this.htmlDoc = new ExtendedHTMLDocument();
            }
            this.registerDocument(this.htmlDoc);
            this.setDocumentText(string2);
            this.refreshOnUpdate();
        }
    }

    @Override
    public void serializeOut(HTMLDocument hTMLDocument) throws IOException {
        File file = this.getFileFromChooser(".", 1, MutableFilter.EXT_SER, this.translatrix.getTranslationString("FiletypeSer"));
        if (file != null) {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(hTMLDocument);
            objectOutputStream.flush();
            objectOutputStream.close();
            this.refreshOnUpdate();
        }
    }

    @Override
    public void serializeIn() throws IOException, ClassNotFoundException {
        File file = this.getFileFromChooser(".", 0, MutableFilter.EXT_SER, this.translatrix.getTranslationString("FiletypeSer"));
        if (file != null) {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            this.htmlDoc = (ExtendedHTMLDocument)objectInputStream.readObject();
            objectInputStream.close();
            this.registerDocument(this.htmlDoc);
            this.refreshOnUpdate();
        }
    }

    private File getFileFromChooser(String string, int n, String[] stringArray, String string2) {
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setDialogType(n);
        jFileChooser.setFileFilter(new MutableFilter(stringArray, string2));
        int n2 = 1;
        n2 = n == 0 ? jFileChooser.showOpenDialog(this) : (n == 1 ? jFileChooser.showSaveDialog(this) : jFileChooser.showOpenDialog(this));
        if (n2 == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    protected File getImageFromChooser(String string, String[] stringArray, String string2) {
        ImageFileChooser imageFileChooser = new ImageFileChooser(string);
        imageFileChooser.setDialogType(2);
        imageFileChooser.setFileFilter(new MutableFilter(stringArray, string2));
        imageFileChooser.setDialogTitle(this.translatrix.getTranslationString("ImageDialogTitle"));
        int n = 1;
        n = imageFileChooser.showDialog(this, this.translatrix.getTranslationString("Insert"));
        if (n == 0) {
            return imageFileChooser.getSelectedFile();
        }
        return null;
    }

    private void describeDocument(StyledDocument styledDocument) {
        Element[] elementArray = styledDocument.getRootElements();
        for (int i = 0; i < elementArray.length; ++i) {
            this.indent = 4;
            for (int j = 0; j < this.indent; ++j) {
                log.debug(" ");
            }
            log.debug(elementArray[i].toString());
            this.traverseElement(elementArray[i]);
            log.debug("");
        }
    }

    public static String[] tokenize(String string) {
        String[] stringArray = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
        }
        return stringArray;
    }

    private void traverseElement(Element element) {
        this.indent += 4;
        for (int i = 0; i < element.getElementCount(); ++i) {
            for (int j = 0; j < this.indent; ++j) {
                log.debug(" ");
            }
            log.debug(element.getElement(i).toString());
            this.traverseElement(element.getElement(i));
        }
        this.indent -= 4;
    }

    private Element locateElementInDocument(StyledDocument styledDocument, String string) {
        Element[] elementArray = styledDocument.getRootElements();
        for (int i = 0; i < elementArray.length; ++i) {
            if (elementArray[i].getName().equalsIgnoreCase(string)) {
                return elementArray[i];
            }
            Element element = this.locateChildElementInDocument(elementArray[i], string);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    private Element locateChildElementInDocument(Element element, String string) {
        for (int i = 0; i < element.getElementCount(); ++i) {
            if (!element.getElement(i).getName().equalsIgnoreCase(string)) continue;
            return element.getElement(i);
        }
        return null;
    }

    @Override
    public JScrollPane getHTMLScrollPane() {
        return this.htmlScrollPane;
    }

    @Override
    public JScrollPane getSrcScrollPane() {
        return this.srcScrollPane;
    }

    @Override
    public JTextPane getTextPane() {
        return this.htmlPane;
    }

    @Override
    public JTextPane getSourcePane() {
        return this.srcPane;
    }

    @Override
    public Frame getFrame() {
        return this.frameHandler;
    }

    public static File getCurrentFile() {
        return currentFile;
    }

    @Override
    public String getAppName() {
        return APP_NAME;
    }

    @Override
    public String getDocumentText() {
        String string = null;
        this.updateBeforeSave();
        string = this.kafenioConfig.isUnicode() ? HTMLTranslate.decode(this.srcPane.getText()) : this.srcPane.getText();
        if (Utils.checkNullOrEmpty(this.getConfig().getCodeBase()) == null) {
            return string;
        }
        return this.replaceAbsoluteUrls(string);
    }

    private void updateBeforeSave() {
        if (!this.srcPane.isShowing()) {
            this.srcPane.setText(this.htmlPane.getText());
        }
    }

    private String getSubText(String string, String string2) {
        if (string2 != null) {
            if (this.kafenioConfig.isUnicode()) {
                string2 = HTMLTranslate.decode(string2);
            }
            String string3 = string2.toLowerCase();
            int n = string3.indexOf("<" + string.toLowerCase());
            int n2 = string3.indexOf(">", n) + 1;
            String string4 = "</" + string.toLowerCase() + ">";
            int n3 = string3.indexOf(string4);
            if (n2 < 0) {
                n2 = 0;
            }
            if (n3 < 0 || n3 > string3.length()) {
                n3 = string3.length();
            }
            return string2.substring(n2, n3);
        }
        return "";
    }

    protected void setAsConfirmedAndQuit() {
        this.documentConfirmed = true;
        this.getKafenioParent().hide();
    }

    @Override
    public boolean postContentBody() {
        return this.postContent(this.getDocumentBody());
    }

    public boolean postContent(String string) {
        String string2 = null;
        try {
            if ("base64".equalsIgnoreCase(this.getConfig().getOutputmode())) {
                string2 = Base64Codec.encode(string);
            } else {
                try {
                    string2 = URLEncoder.encode(string, "UTF-8");
                }
                catch (Throwable throwable) {
                    string2 = URLEncoder.encode(string);
                }
            }
            this.urlFetcher.setPOSTData(this.getConfig().getContentParameter() + "=" + string2);
            this.urlFetcher.setURL(new URL(this.getConfig().getPostUrl()));
            this.urlFetcher.fetch();
            if (this.urlFetcher.getHTTPStatusCode() != 200) {
                log.warn("Posting content to " + this.getConfig().getPostUrl() + " failed. Server Status Code was: " + this.urlFetcher.getResponseStatus());
                return false;
            }
            log.info("Content successfully posted to: " + this.getConfig().getPostUrl() + ". Server Status Code was: " + this.urlFetcher.getResponseStatus());
            return true;
        }
        catch (Exception exception) {
            log.error("an error occured while posting content to: " + this.getConfig().getPostUrl());
            return false;
        }
    }

    @Override
    public String getDocumentBody() {
        log.debug("codebase: " + this.getConfig().getCodeBase());
        this.updateBeforeSave();
        if (Utils.checkNullOrEmpty(this.getConfig().getCodeBase()) == null) {
            return this.getSubText("body", this.srcPane.getText());
        }
        return this.replaceAbsoluteUrls(this.getSubText("body", this.srcPane.getText()));
    }

    private String replaceAbsoluteUrls(String string) {
        try {
            if (this.codeBasePattern == null && this.getConfig().getCodeBase() != null) {
                this.codeBasePattern = new RE((Object)("\"" + this.getConfig().getCodeBase()));
            }
            log.debug("replacing codebase: \"" + this.getConfig().getCodeBase());
            return this.codeBasePattern.substituteAll((Object)string, "\"");
        }
        catch (Exception exception) {
            log.warn("An error ocurred while creating relative urls: " + exception.fillInStackTrace());
            return string;
        }
    }

    @Override
    public void setDocumentText(String string) {
        try {
            if (System.getProperty("java.version").substring(0, 3).equals("1.4")) {
                if (this.pattern1 == null) {
                    this.pattern1 = new RE((Object)"(&\\w+;|&#\\d+;)(\\s|&#160;|&nbsp;)(?=<|&\\w+;|&#\\d+;)");
                }
                string = this.pattern1.substituteAll((Object)string, "$1&#160;$3");
                if (this.pattern2 == null) {
                    this.pattern2 = new RE((Object)"<(/[^>])>(\\s|&#160;|&nbsp;|\\n\\s+)(?!&#160;)(&\\w+;|&#\\d+;)");
                }
                string = this.pattern2.substituteAll((Object)string, "<$1>&#160;$3$4");
            }
        }
        catch (REException rEException) {
            log.error("gnu.regexp.REException in setDocumentText: " + rEException.fillInStackTrace());
        }
        this.htmlPane.setText(HTMLTranslate.decode(this.addURLPrefixToImagePath(string)));
        this.srcPane.setText(this.htmlPane.getText());
    }

    private void updateTitle() {
        this.frameHandler.setTitle(APP_NAME + (currentFile == null ? "" : " - " + currentFile.getName()));
    }

    @Override
    public void purgeUndos() {
        if (this.undoManager != null) {
            this.undoManager.discardAllEdits();
            this.undoAction.updateUndoState();
            this.redoAction.updateRedoState();
        }
    }

    @Override
    public void refreshOnUpdate() {
        this.setDocumentText(this.addURLPrefixToImagePath(this.htmlPane.getText()));
        this.validate();
    }

    @Override
    public void dispose() {
        this.quitApp();
    }

    @Override
    public ImageIcon getKafenioIcon(String string) {
        log.debug("trying to fetch icon: " + string);
        return new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/" + string + "HK.gif")));
    }

    @Override
    public ImageIcon getMenuIcon(String string) {
        if (this.kafenioConfig.isShowMenuIcons()) {
            return this.getKafenioIcon(string);
        }
        return null;
    }

    @Override
    public void toggleSourceWindow() {
        if (!this.srcScrollPane.isShowing()) {
            this.srcPane.setText(this.htmlPane.getText());
            this.mainPane.removeAll();
            this.mainPane.add((Component)this.srcScrollPane, "Center");
        } else {
            this.setDocumentText(this.addURLPrefixToImagePath(this.srcPane.getText()));
            this.mainPane.removeAll();
            this.mainPane.add((Component)this.htmlScrollPane, "Center");
        }
        this.repaint();
        this.validate();
        this.kafenioMenuBar.getViewSourceItem().setSelected(this.srcScrollPane.isShowing());
    }

    private String findStyle(Element element) {
        AttributeSet attributeSet = element.getAttributes();
        if (attributeSet == null) {
            return null;
        }
        Object object = attributeSet.getAttribute(HTML.Attribute.CLASS);
        if (object != null && object instanceof String) {
            return (String)object;
        }
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            AttributeSet attributeSet2;
            Object obj = enumeration.nextElement();
            if (!(obj instanceof HTML.Tag) || (attributeSet2 = (AttributeSet)attributeSet.getAttribute(obj)) == null || (object = attributeSet2.getAttribute(HTML.Attribute.CLASS)) == null) continue;
            return (String)object;
        }
        return null;
    }

    private void handleCaretPositionChange(CaretEvent caretEvent) {
        int n = caretEvent.getDot();
        Element element = this.htmlDoc.getCharacterElement(n);
        if (element == null) {
            return;
        }
        String string = null;
        Vector<Element> vector = new Vector<Element>();
        while (element != null) {
            if (string == null) {
                string = this.findStyle(element);
            }
            vector.add(element);
            element = element.getParentElement();
        }
        int n2 = -1;
        if (string != null) {
            for (int i = 0; i < this.kafenioToolBar1.getStyleSelector().getItemCount(); ++i) {
                String string2 = (String)this.kafenioToolBar1.getStyleSelector().getItemAt(i);
                if (!string2.equalsIgnoreCase(string)) continue;
                n2 = i;
                break;
            }
        }
        if (n2 > -1) {
            Action action = this.kafenioToolBar1.getStyleSelector().getAction();
            action.setEnabled(false);
            this.kafenioToolBar1.getStyleSelector().setSelectedIndex(n2);
            action.setEnabled(true);
        } else {
            try {
                this.kafenioToolBar1.getStyleSelector().setSelectedIndex(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ExtendedHTMLDocument getExtendedHtmlDoc() {
        return this.htmlDoc;
    }

    public ExtendedHTMLEditorKit getExtendedHtmlKit() {
        return this.htmlKit;
    }

    @Override
    public HTMLEditorKit getHTMLEditorKit() {
        return this.htmlKit;
    }

    @Override
    public int getCaretPosition() {
        return this.htmlPane.getCaretPosition();
    }

    @Override
    public void setCaretPosition(int n) {
        boolean bl = true;
        do {
            bl = true;
            try {
                this.htmlPane.setCaretPosition(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = false;
                --n;
            }
        } while (!bl && n >= 0);
    }

    @Override
    public Container getKafenioParent() {
        return this.kafenioParent;
    }

    @Override
    public void setKafenioParent(Window window) {
        this.kafenioParent = window;
    }

    public RedoAction getRedoAction() {
        return this.redoAction;
    }

    public UndoAction getUndoAction() {
        return this.undoAction;
    }

    @Override
    public Clipboard getSysClipboard() {
        return this.sysClipboard;
    }

    public KafenioPanelConfiguration getConfig() {
        return this.kafenioConfig;
    }

    @Override
    public String getTranslation(String string) {
        try {
            return this.translatrix.getTranslationString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public KafenioPanelActions getKafenioActions() {
        return this.kafenioActions;
    }

    @Override
    public void quitApp() {
        if (this.undoManager.canUndo()) {
            if (JOptionPane.showConfirmDialog(this.getParent(), this.translatrix.getTranslationString("QuitWithoutSave"), "", 0, 3) == 0) {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    static {
        currentFile = null;
    }

    class CustomUndoableEditListener
    implements UndoableEditListener {
        CustomUndoableEditListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            KafenioPanel.this.undoManager.addEdit(undoableEditEvent.getEdit());
            KafenioPanel.this.undoAction.updateUndoState();
            KafenioPanel.this.redoAction.updateRedoState();
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(KafenioPanel.this.translatrix.getTranslationString("Redo"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                KafenioPanel.this.undoManager.redo();
            }
            catch (CannotUndoException cannotUndoException) {
                log.warn("Exception while performing redo: " + cannotUndoException.fillInStackTrace());
            }
            this.updateRedoState();
            KafenioPanel.this.undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (KafenioPanel.this.undoManager.canRedo()) {
                this.setEnabled(true);
                this.putValue("ShortDescription", KafenioPanel.this.undoManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("ShortDescription", KafenioPanel.this.translatrix.getTranslationString("Redo"));
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(KafenioPanel.this.translatrix.getTranslationString("Undo"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                KafenioPanel.this.undoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                log.warn("Exception while performing undo: " + cannotUndoException.fillInStackTrace());
            }
            this.updateUndoState();
            KafenioPanel.this.redoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (KafenioPanel.this.undoManager.canUndo()) {
                this.setEnabled(true);
                this.putValue("ShortDescription", KafenioPanel.this.undoManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("ShortDescription", KafenioPanel.this.translatrix.getTranslationString("Undo"));
            }
        }
    }
}

