/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio;

import de.xeinfach.kafenio.SplashScreen;
import de.xeinfach.kafenio.interfaces.KafenioContainerInterface;
import de.xeinfach.kafenio.interfaces.KafenioPanelConfigurationInterface;
import de.xeinfach.kafenio.interfaces.KafenioPanelInterface;
import de.xeinfach.kafenio.util.LeanLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Kafenio
extends JFrame
implements WindowListener,
KafenioContainerInterface {
    private KafenioPanelConfigurationInterface config;
    private KafenioPanelInterface kafenioPanel;
    private File currentFile = null;
    private SplashScreen splash;
    private static LeanLogger log = new LeanLogger("Kafenio.class");

    public Kafenio(KafenioPanelConfigurationInterface kafenioPanelConfigurationInterface) {
        this.showSplash();
        this.config = kafenioPanelConfigurationInterface;
        this.config.setKafenioParent(this);
        try {
            Class<?> clazz = Class.forName("de.xeinfach.kafenio.KafenioPanel");
            Class[] classArray = new Class[]{KafenioPanelConfigurationInterface.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            this.kafenioPanel = (KafenioPanelInterface)constructor.newInstance(this.config);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)((JPanel)((Object)this.kafenioPanel)), "Center");
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.updateTitle();
        this.pack();
        this.show();
        this.splash.destroy();
    }

    public static void main(String[] stringArray) {
        KafenioPanelConfigurationInterface kafenioPanelConfigurationInterface = null;
        try {
            kafenioPanelConfigurationInterface = (KafenioPanelConfigurationInterface)Class.forName("de.xeinfach.kafenio.KafenioPanelConfiguration").newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        kafenioPanelConfigurationInterface.setImageDir("file://");
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-t")) {
                    kafenioPanelConfigurationInterface.setShowToolbar(true);
                    kafenioPanelConfigurationInterface.setShowToolbar2(true);
                    continue;
                }
                if (stringArray[i].equals("-T")) {
                    kafenioPanelConfigurationInterface.setShowToolbar(false);
                    kafenioPanelConfigurationInterface.setShowToolbar2(false);
                    continue;
                }
                if (stringArray[i].equals("-s")) {
                    kafenioPanelConfigurationInterface.setShowViewSource(true);
                    continue;
                }
                if (stringArray[i].equals("-S")) {
                    kafenioPanelConfigurationInterface.setShowViewSource(false);
                    continue;
                }
                if (stringArray[i].equals("-m")) {
                    kafenioPanelConfigurationInterface.setShowMenuIcons(true);
                    continue;
                }
                if (stringArray[i].equals("-M")) {
                    kafenioPanelConfigurationInterface.setShowMenuIcons(false);
                    continue;
                }
                if (stringArray[i].equals("-b")) {
                    kafenioPanelConfigurationInterface.setBase64(true);
                    continue;
                }
                if (stringArray[i].equals("-B")) {
                    kafenioPanelConfigurationInterface.setBase64(false);
                    continue;
                }
                if (stringArray[i].equals("-8")) {
                    kafenioPanelConfigurationInterface.setUnicode(true);
                    continue;
                }
                if (stringArray[i].startsWith("-f")) {
                    kafenioPanelConfigurationInterface.setDocument(stringArray[i].substring(2, stringArray[i].length()));
                    continue;
                }
                if (stringArray[i].startsWith("-c")) {
                    kafenioPanelConfigurationInterface.setStyleSheet(stringArray[i].substring(2, stringArray[i].length()));
                    continue;
                }
                if (stringArray[i].startsWith("-r")) {
                    kafenioPanelConfigurationInterface.setRawDocument(stringArray[i].substring(2, stringArray[i].length()));
                    continue;
                }
                if (stringArray[i].startsWith("-u")) {
                    try {
                        kafenioPanelConfigurationInterface.setUrlStyleSheet(new URL(stringArray[i].substring(2, stringArray[i].length())));
                    }
                    catch (Throwable throwable) {
                        log.warn("Exception caught while trying to setURLStylesheet: " + throwable.fillInStackTrace());
                    }
                    continue;
                }
                if (stringArray[i].startsWith("-l")) {
                    if (stringArray[i].indexOf(95) <= -1) continue;
                    kafenioPanelConfigurationInterface.setLanguage(stringArray[i].substring(2, stringArray[i].indexOf(95)));
                    kafenioPanelConfigurationInterface.setCountry(stringArray[i].substring(stringArray[i].indexOf(95) + 1, stringArray[i].length()));
                    continue;
                }
                if (stringArray[i].equals("-d")) {
                    kafenioPanelConfigurationInterface.setDebugMode(true);
                    continue;
                }
                if (!stringArray[i].equals("-D")) continue;
                kafenioPanelConfigurationInterface.setDebugMode(false);
            }
        }
        new Kafenio(kafenioPanelConfigurationInterface);
    }

    private void updateTitle() {
        this.setTitle(this.kafenioPanel.getAppName() + (this.currentFile == null ? "" : " - " + this.currentFile.getName()));
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.kafenioPanel.quitApp();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void detachFrame() {
    }

    private void showSplash() {
        this.splash = new SplashScreen(30);
        log.info("Info: Displaying splash image for max. 30 seconds.");
        new Thread(this.splash).start();
    }
}

