/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.structurepanel;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.general.ChapterDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ScenesListDataControl;
import es.eucm.eadventure.editor.control.tools.structurepanel.AddElementTool;
import es.eucm.eadventure.editor.gui.DataControlsPanel;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.structurepanel.StructureControl;
import es.eucm.eadventure.editor.gui.structurepanel.StructureElement;
import es.eucm.eadventure.editor.gui.structurepanel.StructureElementRenderer;
import es.eucm.eadventure.editor.gui.structurepanel.StructureListElement;
import es.eucm.eadventure.editor.gui.structurepanel.StructureListElementLayout;
import es.eucm.eadventure.editor.gui.structurepanel.StructurePanelLayout;
import es.eucm.eadventure.editor.gui.structurepanel.structureelements.AdaptationControllerStructureElement;
import es.eucm.eadventure.editor.gui.structurepanel.structureelements.AdvancedFeaturesListStructureElement;
import es.eucm.eadventure.editor.gui.structurepanel.structureelements.AssessmentControllerStructureElement;
import es.eucm.eadventure.editor.gui.structurepanel.structureelements.AtrezzoListStructureElement;
import es.eucm.eadventure.editor.gui.structurepanel.structureelements.BooksListStructureElement;
import es.eucm.eadventure.editor.gui.structurepanel.structureelements.ChapterStructureElement;
import es.eucm.eadventure.editor.gui.structurepanel.structureelements.ConversationsListStructureElement;
import es.eucm.eadventure.editor.gui.structurepanel.structureelements.CutscenesListStructureElement;
import es.eucm.eadventure.editor.gui.structurepanel.structureelements.ItemsListStructureElement;
import es.eucm.eadventure.editor.gui.structurepanel.structureelements.NPCsListStructureElement;
import es.eucm.eadventure.editor.gui.structurepanel.structureelements.PlayerStructureElement;
import es.eucm.eadventure.editor.gui.structurepanel.structureelements.ScenesListStructureElement;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class StructurePanel
extends JPanel
implements DataControlsPanel {
    private static final long serialVersionUID = -1768584184321389780L;
    public static final int NORMAL_ROW_SIZE = 20;
    public static final int SELECTED_ROW_SIZE = 70;
    private static final int INCREMENT = 5;
    private static final int UNSELECTED_BUTTON_HEIGHT = 35;
    private Container editorContainer;
    protected int selectedElement;
    protected int selectedListItem = -1;
    protected List<StructureListElement> structureElements;
    protected JTable list;
    protected JButton button;
    protected int normalRowSize;
    protected int selectedRowSize;
    private Image image;
    private Image basicImage;
    private Image tempImage;
    private int increment;
    private int top;
    private int bottom;
    private int cont;

    public StructurePanel(Container container) {
        this(container, 20, 70);
    }

    public StructurePanel(Container container, int n, int n2) {
        this.editorContainer = container;
        this.normalRowSize = n;
        this.selectedRowSize = n2;
        this.selectedElement = 0;
        this.setLayout(new StructurePanelLayout());
        this.structureElements = new ArrayList<StructureListElement>();
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (StructurePanel.this.getWidth() > 0 && StructurePanel.this.getHeight() > 0) {
                    StructurePanel.this.basicImage = new BufferedImage(StructurePanel.this.getWidth(), StructurePanel.this.getHeight(), 6);
                }
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        this.update();
    }

    public void recreateElements() {
        ChapterDataControl chapterDataControl = Controller.getInstance().getSelectedChapterDataControl();
        this.structureElements.clear();
        if (chapterDataControl != null) {
            this.structureElements.add(new ChapterStructureElement(chapterDataControl));
            this.structureElements.add(new ScenesListStructureElement(chapterDataControl.getScenesList()));
            this.structureElements.add(new CutscenesListStructureElement(chapterDataControl.getCutscenesList()));
            this.structureElements.add(new BooksListStructureElement(chapterDataControl.getBooksList()));
            this.structureElements.add(new ItemsListStructureElement(chapterDataControl.getItemsList()));
            this.structureElements.add(new AtrezzoListStructureElement(chapterDataControl.getAtrezzoList()));
            this.structureElements.add(new PlayerStructureElement(chapterDataControl.getPlayer()));
            this.structureElements.add(new NPCsListStructureElement(chapterDataControl.getNPCsList()));
            this.structureElements.add(new ConversationsListStructureElement(chapterDataControl.getConversationsList()));
            this.structureElements.add(new AdvancedFeaturesListStructureElement(Controller.getInstance().getAdvancedFeaturesController()));
            this.structureElements.add(new AdaptationControllerStructureElement(Controller.getInstance().getAdaptationController()));
            this.structureElements.add(new AssessmentControllerStructureElement(Controller.getInstance().getAssessmentController()));
        }
        this.setMinimumSize(new Dimension(0, 545));
        this.update();
    }

    public void update(int n, final int n2) {
        if (n != n2 && n != -1) {
            this.setEnabled(false);
            this.setCursor(new Cursor(3));
            this.increment = 10;
            this.top = 0;
            this.bottom = 0;
            this.cont = 0;
            this.calculateTranslateConstants(n2, n);
            if (this.getHeight() > 0 && this.getWidth() > 0 && this.increment != 0 && this.cont != 0) {
                this.image = this.basicImage;
                this.paint(this.image.getGraphics());
                if (this.bottom - this.top > 0) {
                    this.tempImage = new BufferedImage(this.getWidth(), this.bottom - this.top, 6);
                    this.tempImage.getGraphics().drawImage(this.image, 0, 0, this.getWidth(), this.bottom - this.top, 0, this.top, this.getWidth(), this.bottom, null);
                } else {
                    this.image = null;
                    this.cont = 0;
                }
            }
            this.selectedElement = n2;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    StructurePanel.this.removeAll();
                    StructurePanel.this.setIgnoreRepaint(true);
                    for (int i = 0; i < StructurePanel.this.cont; ++i) {
                        Graphics2D graphics2D = (Graphics2D)StructurePanel.this.getGraphics();
                        Graphics graphics = StructurePanel.this.image.getGraphics();
                        graphics.setColor(StructurePanel.this.getBackground());
                        if (i > 0) {
                            graphics.fillRect(0, StructurePanel.this.top + StructurePanel.this.increment * (i - 1), StructurePanel.this.getWidth(), StructurePanel.this.bottom - StructurePanel.this.top);
                        }
                        graphics.drawImage(StructurePanel.this.tempImage, 0, StructurePanel.this.top + StructurePanel.this.increment * i, null);
                        graphics2D.drawImage(StructurePanel.this.image, 0, 0, null);
                        graphics2D.finalize();
                        try {
                            Thread.sleep(400 / StructurePanel.this.cont);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    StructurePanel.this.image = null;
                    StructurePanel.this.update();
                    StructurePanel.this.list.requestFocusInWindow();
                    StructurePanel.this.setEnabled(true);
                    StructurePanel.this.setIgnoreRepaint(false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StructurePanel.this.setCursor(new Cursor(0));
                        }
                    });
                }
            }).start();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (StructurePanel.this.editorContainer != null) {
                        StructurePanel.this.editorContainer.removeAll();
                        StructurePanel.this.editorContainer.add(StructurePanel.this.structureElements.get(n2).getEditPanel());
                        StructureControl.getInstance().visitDataControl(StructurePanel.this.structureElements.get(n2).getDataControl());
                        StructurePanel.this.editorContainer.validate();
                        StructurePanel.this.editorContainer.repaint();
                    }
                }
            });
        } else {
            this.update();
            this.selectedElement = n2;
            if (this.editorContainer != null) {
                this.editorContainer.removeAll();
                this.editorContainer.add(this.structureElements.get(n2).getEditPanel());
                StructureControl.getInstance().visitDataControl(this.structureElements.get(n2).getDataControl());
                this.editorContainer.validate();
                this.editorContainer.repaint();
            }
        }
    }

    private void calculateTranslateConstants(int n, int n2) {
        if (n > n2) {
            if (this.structureElements.get(n2).getDataControl().getAddableElements().length > 0) {
                this.increment = -5;
                if (this.structureElements.get(n).getDataControl().getAddableElements().length > 0) {
                    this.bottom = this.getHeight() - 35 * (this.structureElements.size() - n - 1);
                    this.top = this.bottom - 35 * (n - n2);
                    int n3 = 35 * (n2 + 1);
                    this.cont = -(this.top - n3) / this.increment;
                } else {
                    this.bottom = this.getHeight();
                    this.top = this.bottom - 35 * (this.structureElements.size() - n2 - 1);
                    int n4 = 35 * (n2 + 1);
                    this.cont = -(this.top - n4) / this.increment;
                }
            } else if (this.structureElements.get(n).getDataControl().getAddableElements().length > 0) {
                this.increment = 5;
                this.top = 35 * n + 40;
                this.bottom = this.top + 35 * (this.structureElements.size() - n - 1);
                int n5 = this.getHeight() - 35 * (this.structureElements.size() - n + 1);
                this.cont = -(this.top - n5) / this.increment;
            } else {
                this.cont = 0;
            }
        } else if (this.structureElements.get(n2).getDataControl().getAddableElements().length > 0) {
            if (this.structureElements.get(n).getDataControl().getAddableElements().length > 0) {
                this.increment = 5;
                this.top = 35 * n + 35;
                this.bottom = this.top + 35 * (n2 - n - 1) + 40;
                int n6 = this.getHeight() - 35 * (this.structureElements.size() - n);
                this.cont = -(this.top - n6) / this.increment;
            } else {
                this.increment = -5;
                this.top = this.getHeight() - 35 * (this.structureElements.size() - n2 - 1);
                this.bottom = this.getHeight();
                int n7 = 35 * (n2 + 1);
                this.cont = -(this.top - n7) / this.increment;
            }
        } else if (this.structureElements.get(n).getDataControl().getAddableElements().length > 0) {
            this.increment = 5;
            this.top = 35 * n + 35;
            this.bottom = 35 * this.structureElements.size() - 35 + 40;
            int n8 = this.getHeight() - 35 * (this.structureElements.size() - n);
            this.cont = -(this.top - n8) / this.increment;
        } else {
            this.cont = 0;
        }
    }

    public void update() {
        int n = 0;
        this.removeAll();
        for (StructureListElement structureListElement : this.structureElements) {
            if (n == this.selectedElement) {
                this.add((Component)this.createSelectedElementPanel(structureListElement, n), new Integer(structureListElement.getChildCount() != 0 || structureListElement.getDataControl().getAddableElements().length > 0 ? -1 : 40));
            } else {
                this.button = new JButton(structureListElement.getName(), structureListElement.getIcon());
                this.button.setHorizontalAlignment(2);
                Border border = BorderFactory.createRaisedBevelBorder();
                Border border2 = BorderFactory.createEmptyBorder(3, 10, 3, 10);
                this.button.setBorder(BorderFactory.createCompoundBorder(border, border2));
                this.button.setContentAreaFilled(false);
                this.button.addActionListener(new ElementButtonActionListener(n));
                this.button.setFocusable(false);
                if (n < this.selectedElement) {
                    this.add((Component)this.button, new Integer(35));
                } else if (n > this.selectedElement) {
                    this.add((Component)this.button, new Integer(35));
                }
            }
            ++n;
        }
        this.updateUI();
    }

    protected JPanel createSelectedElementPanel(final StructureListElement structureListElement, final int n) {
        JComponent jComponent;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new StructureListElementLayout());
        this.button = new JButton(structureListElement.getName(), structureListElement.getIcon());
        this.button.setHorizontalAlignment(2);
        Border border = BorderFactory.createLineBorder(Color.GRAY, 3);
        Border border2 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.button.setBorder(BorderFactory.createCompoundBorder(border, border2));
        this.button.setContentAreaFilled(false);
        this.button.addActionListener(new ElementButtonActionListener(n));
        this.button.setFont(new Font("SansSerif", 1, 15));
        this.button.setFocusable(false);
        jPanel.add((Component)this.button, "title");
        AbstractTableModel abstractTableModel = new AbstractTableModel(){
            private static final long serialVersionUID = 3895333816471270996L;

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public int getRowCount() {
                return structureListElement.getChildCount();
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return structureListElement.getChild(n);
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return StructurePanel.this.list.getSelectedRow() == n;
            }
        };
        this.list = new JTable(abstractTableModel);
        this.list.setSelectionMode(0);
        StructureElementRenderer structureElementRenderer = new StructureElementRenderer(structureListElement);
        this.list.getColumnModel().getColumn(0).setCellRenderer(structureElementRenderer);
        this.list.getColumnModel().getColumn(0).setCellEditor(structureElementRenderer);
        this.list.setCellSelectionEnabled(true);
        this.list.setShowHorizontalLines(true);
        this.list.setRowHeight(this.normalRowSize);
        this.list.setTableHeader(null);
        this.list.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                StructurePanel.this.setCursor(new Cursor(3));
                if (StructurePanel.this.list.getSelectedRow() >= 0) {
                    StructurePanel.this.list.setRowHeight(StructurePanel.this.normalRowSize);
                    StructurePanel.this.list.setRowHeight(StructurePanel.this.list.getSelectedRow(), StructurePanel.this.selectedRowSize);
                    StructurePanel.this.list.editCellAt(StructurePanel.this.list.getSelectedRow(), 0);
                    if (StructurePanel.this.editorContainer != null) {
                        StructurePanel.this.editorContainer.removeAll();
                        StructurePanel.this.editorContainer.add(((StructureElement)StructurePanel.this.list.getValueAt(StructurePanel.this.list.getSelectedRow(), 0)).getEditPanel());
                        StructureControl.getInstance().visitDataControl(((StructureElement)StructurePanel.this.list.getValueAt(StructurePanel.this.list.getSelectedRow(), 0)).getDataControl());
                        StructurePanel.this.editorContainer.validate();
                        StructurePanel.this.editorContainer.repaint();
                    }
                } else if (StructurePanel.this.editorContainer != null) {
                    StructurePanel.this.editorContainer.removeAll();
                    StructurePanel.this.editorContainer.add(StructurePanel.this.structureElements.get(n).getEditPanel());
                    StructureControl.getInstance().visitDataControl(StructurePanel.this.structureElements.get(n).getDataControl());
                    StructurePanel.this.editorContainer.validate();
                    StructurePanel.this.editorContainer.repaint();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StructurePanel.this.setCursor(new Cursor(0));
                    }
                });
            }
        });
        if (structureListElement.getDataControl() != null && structureListElement.getDataControl().getAddableElements().length > 0) {
            jComponent = new JButton(new ImageIcon("img/icons/addNode.png"));
            ((AbstractButton)jComponent).setContentAreaFilled(false);
            ((AbstractButton)jComponent).setMargin(new Insets(0, 0, 0, 0));
            jComponent.setBorder(BorderFactory.createEmptyBorder());
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Controller.getInstance().addTool(new AddElementTool(structureListElement, StructurePanel.this.list));
                }
            });
            jComponent.setToolTipText(TC.get((String)"GeneralText.AddNew"));
            jPanel.add((Component)jComponent, "addButton");
            jPanel.setComponentZOrder(jComponent, 0);
            jComponent.setFocusable(false);
        }
        jComponent = new JScrollPane(this.list);
        jPanel.add((Component)jComponent, "list");
        boolean bl = structureListElement.getDataControl() instanceof ScenesListDataControl;
        if (!bl) {
            Controller.gc();
        }
        return jPanel;
    }

    public void updateElementPanel() {
        boolean bl = false;
        if (this.editorContainer != null && this.editorContainer.getComponentCount() == 1 && this.editorContainer.getComponent(0) instanceof Updateable) {
            bl = ((Updateable)((Object)this.editorContainer.getComponent(0))).updateFields();
        }
        if (!bl) {
            this.reloadElementPanel();
        }
    }

    public void reloadElementPanel() {
        if (this.editorContainer != null) {
            this.editorContainer.removeAll();
            if (this.selectedElement >= 0 && this.selectedElement < this.structureElements.size()) {
                if (this.list == null || this.list.getSelectedRow() == -1) {
                    this.editorContainer.add(this.structureElements.get(this.selectedElement).getEditPanel());
                    StructureControl.getInstance().visitDataControl(this.structureElements.get(this.selectedElement).getDataControl());
                } else {
                    this.editorContainer.add(this.structureElements.get(this.selectedElement).getChild(this.list.getSelectedRow()).getEditPanel());
                }
            }
            this.editorContainer.validate();
            this.editorContainer.repaint();
        }
        Controller.gc();
    }

    @Override
    public void setSelectedItem(List<Searchable> list) {
        int n;
        boolean bl = true;
        while (list.size() > 0 && bl) {
            bl = false;
            for (n = 0; n < this.structureElements.size() && !bl; ++n) {
                if (this.structureElements.get(n).getDataControl() != list.get(list.size() - 1)) continue;
                this.selectedElement = n;
                this.selectedListItem = -1;
                bl = true;
            }
            if (!bl) continue;
            list.remove(list.size() - 1);
        }
        this.update();
        if (this.structureElements.get(this.selectedElement).getChildCount() > 0 && list.size() > 0) {
            bl = false;
            for (n = 0; n < this.structureElements.get(this.selectedElement).getChildCount() && !bl; ++n) {
                if (this.structureElements.get(this.selectedElement).getChild(n).getDataControl() != list.get(list.size() - 1)) continue;
                this.selectedListItem = n;
                list.remove(list.size() - 1);
                bl = true;
            }
        }
        if (this.editorContainer != null) {
            this.editorContainer.removeAll();
            if (this.selectedListItem == -1) {
                this.editorContainer.add(this.structureElements.get(this.selectedElement).getEditPanel());
                StructureControl.getInstance().visitDataControl(this.structureElements.get(this.selectedElement).getDataControl());
            } else {
                this.list.changeSelection(this.selectedListItem, 0, false, false);
            }
            if (this.editorContainer.getComponent(0) instanceof DataControlsPanel) {
                ((DataControlsPanel)((Object)this.editorContainer.getComponent(0))).setSelectedItem(list);
            }
            this.editorContainer.validate();
            this.editorContainer.repaint();
            this.list.requestFocusInWindow();
        }
        Controller.gc();
    }

    private class ElementButtonActionListener
    implements ActionListener {
        private int index;

        public ElementButtonActionListener(int n) {
            this.index = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StructurePanel.this.update(StructurePanel.this.selectedElement, this.index);
        }
    }
}

