/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.structurepanel;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.structurepanel.DuplicateElementTool;
import es.eucm.eadventure.editor.control.tools.structurepanel.RemoveElementTool;
import es.eucm.eadventure.editor.control.tools.structurepanel.RenameElementTool;
import es.eucm.eadventure.editor.gui.structurepanel.StructureElement;
import es.eucm.eadventure.editor.gui.structurepanel.StructureListElement;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class StructureElementCell
extends JPanel {
    private static final long serialVersionUID = -2096132139472242178L;
    private StructureElement value;
    private JTable table;
    private boolean renaming;
    private boolean isSelected;
    private JTextField name;
    private StructureListElement parent;

    public StructureElementCell(StructureElement structureElement, JTable jTable, boolean bl, StructureListElement structureListElement) {
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.value = structureElement;
        this.table = jTable;
        this.isSelected = bl;
        this.parent = structureListElement;
        this.setLayout(new GridLayout(0, 1));
        this.recreate();
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (StructureElementCell.this.name != null && !StructureElementCell.this.name.hasFocus()) {
                            StructureElementCell.this.name.selectAll();
                            StructureElementCell.this.name.requestFocusInWindow();
                        }
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
    }

    public void recreate() {
        this.removeAll();
        if (this.isSelected && !this.renaming && !this.value.isJustCreated()) {
            JLabel jLabel = this.value.getIcon() == null ? new JLabel(" " + this.value.getName(), 0) : new JLabel(this.value.getName(), this.value.getIcon(), 0);
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            this.add(jLabel);
            this.setBorder(BorderFactory.createLineBorder(Color.blue, 2));
            boolean bl = false;
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.WHITE);
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            if (this.value.isCanRename()) {
                this.addRenameButton(gridBagConstraints, jPanel);
                bl = true;
            }
            if (this.value.canBeDuplicated()) {
                this.addDuplicateButton(gridBagConstraints, jPanel);
                bl = true;
            }
            if (this.value.canBeRemoved()) {
                this.addRemoveButton(gridBagConstraints, jPanel);
                bl = true;
            }
            if (bl) {
                this.add(jPanel);
            }
            this.setMinimumSize(new Dimension(this.getWidth(), 60));
        } else if (this.isSelected && (this.renaming || this.value.isJustCreated())) {
            this.name = new JTextField(this.value.getName());
            this.name.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StructureElementCell.this.acceptRename();
                }
            });
            this.name.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    StructureElementCell.this.cancelRename();
                }
            });
            this.add(this.name);
            this.name.requestFocusInWindow();
            this.setBorder(BorderFactory.createLineBorder(Color.blue, 2));
            JPanel jPanel = this.createOKCancelButtons();
            this.add(jPanel);
            this.setMinimumSize(new Dimension(this.getWidth(), 60));
        } else {
            this.renaming = false;
            if (this.value != null) {
                JLabel jLabel = this.value.getIcon() == null ? new JLabel(" " + this.value.getName(), 2) : new JLabel(this.value.getName(), this.value.getIcon(), 2);
                this.add(jLabel);
            }
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setMinimumSize(new Dimension(this.getWidth(), 20));
        }
    }

    private JPanel createOKCancelButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0));
        jPanel.setBackground(Color.WHITE);
        JButton jButton = new JButton(TC.get((String)"GeneralText.OK"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructureElementCell.this.acceptRename();
            }
        });
        jButton.setFocusable(false);
        jPanel.add(jButton);
        JButton jButton2 = new JButton(TC.get((String)"GeneralText.Cancel"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructureElementCell.this.cancelRename();
            }
        });
        jButton2.setFocusable(false);
        jPanel.add(jButton2);
        return jPanel;
    }

    private void addRemoveButton(GridBagConstraints gridBagConstraints, JPanel jPanel) {
        JButton jButton = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setToolTipText(TC.get((String)"GeneralText.Delete"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Controller.getInstance().addTool(new RemoveElementTool(StructureElementCell.this.table, StructureElementCell.this.value));
            }
        });
        jButton.setFocusable(false);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jButton, gridBagConstraints);
    }

    private void addDuplicateButton(GridBagConstraints gridBagConstraints, JPanel jPanel) {
        JButton jButton = new JButton(new ImageIcon("img/icons/duplicateNode.png"));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setToolTipText(TC.get((String)"GeneralText.Duplicate"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Controller.getInstance().addTool(new DuplicateElementTool(StructureElementCell.this.value, StructureElementCell.this.table, StructureElementCell.this.parent));
            }
        });
        jButton.setFocusable(false);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
    }

    private void addRenameButton(GridBagConstraints gridBagConstraints, JPanel jPanel) {
        JButton jButton = new JButton(TC.get((String)"GeneralText.Rename"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructureElementCell.this.renaming = true;
                StructureElementCell.this.recreate();
                StructureElementCell.this.repaint();
                StructureElementCell.this.updateUI();
            }
        });
        jButton.setFocusable(false);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        jPanel.add((Component)jButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
    }

    private void acceptRename() {
        Controller.getInstance().addTool(new RenameElementTool(this.value.getDataControl(), this.name.getText()));
        this.value.setJustCreated(false);
        this.renaming = false;
        this.recreate();
        this.repaint();
        this.updateUI();
    }

    private void cancelRename() {
        this.renaming = false;
        this.recreate();
        this.repaint();
        this.updateUI();
        if (this.value.isJustCreated()) {
            this.value.setJustCreated(false);
            this.value.delete(false);
            this.table.clearSelection();
            Controller.getInstance().updateStructure();
        }
    }

    public Object getValue() {
        return this.value;
    }
}

