/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.structurepanel;

import es.eucm.eadventure.common.data.HasId;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.gui.structurepanel.EditPanelFactory;
import es.eucm.eadventure.editor.gui.structurepanel.StructureListElement;
import javax.swing.Icon;
import javax.swing.JComponent;

public class StructureElement {
    protected Icon icon;
    protected String name;
    private DataControl dataControl;
    private StructureListElement parent;

    public StructureElement(DataControl dataControl, StructureListElement structureListElement) {
        this.dataControl = dataControl;
        this.parent = structureListElement;
        this.name = null;
    }

    public StructureElement(String string, DataControl dataControl, StructureListElement structureListElement) {
        this(dataControl, structureListElement);
        this.name = string;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return ((HasId)this.dataControl.getContent()).getId();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public JComponent getEditPanel() {
        return EditPanelFactory.getEditPanel(this.dataControl);
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public boolean isCanRename() {
        return this.dataControl.canBeRenamed();
    }

    public boolean canBeRemoved() {
        return this.dataControl.canBeDeleted();
    }

    public DataControl getDataControl() {
        return this.dataControl;
    }

    public boolean delete(boolean bl) {
        if (this.getDataControl().canBeDeleted() && this.parent.getDataControl().deleteElement(this.getDataControl(), bl)) {
            Controller.getInstance().updateVarFlagSummary();
            return true;
        }
        return false;
    }

    public void setJustCreated(boolean bl) {
        this.dataControl.setJustCreated(bl);
    }

    public boolean isJustCreated() {
        return this.dataControl.isJustCreated();
    }

    public boolean canBeDuplicated() {
        return this.dataControl.canBeDuplicated();
    }
}

