/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.structurepanel;

import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.gui.structurepanel.EffectsStructurePanel;
import es.eucm.eadventure.editor.gui.structurepanel.StructurePanel;
import java.util.ArrayList;
import java.util.List;

public class StructureControl {
    private static StructureControl instance;
    private StructurePanel structurePanel;
    private StructurePanel pastStructure;
    private List<DataControl> backList = new ArrayList<DataControl>();
    private List<DataControl> forwardList = new ArrayList<DataControl>();

    public static StructureControl getInstance() {
        if (instance == null) {
            instance = new StructureControl();
        }
        return instance;
    }

    private StructureControl() {
    }

    public void setStructurePanel(StructurePanel structurePanel) {
        if (structurePanel instanceof EffectsStructurePanel) {
            this.pastStructure = structurePanel;
        }
        this.structurePanel = structurePanel;
    }

    public void resetStructurePanel() {
        this.structurePanel = this.pastStructure;
    }

    public void changeDataControl(Searchable searchable) {
        List<Searchable> list;
        if (searchable != null && (list = Controller.getInstance().getSelectedChapterDataControl().getPath(searchable)) != null) {
            this.structurePanel.setSelectedItem(list);
        }
    }

    public void visitDataControl(DataControl dataControl) {
        if (this.backList.size() > 0) {
            if (dataControl != this.backList.get(this.backList.size() - 1)) {
                this.backList.add(dataControl);
            }
        } else {
            this.backList.add(dataControl);
        }
        this.forwardList.clear();
    }

    public void goBack() {
        if (this.backList.size() > 1) {
            DataControl dataControl = this.backList.remove(this.backList.size() - 1);
            DataControl dataControl2 = this.backList.get(this.backList.size() - 1);
            ArrayList<DataControl> arrayList = new ArrayList<DataControl>();
            arrayList.addAll(this.backList);
            ArrayList<DataControl> arrayList2 = new ArrayList<DataControl>();
            arrayList2.addAll(this.forwardList);
            this.changeDataControl(dataControl2);
            this.backList = arrayList;
            this.forwardList = arrayList2;
            this.forwardList.add(dataControl);
        }
    }

    public void goForward() {
        if (this.forwardList.size() > 0) {
            DataControl dataControl = this.forwardList.get(this.forwardList.size() - 1);
            this.forwardList.remove(dataControl);
            ArrayList<DataControl> arrayList = new ArrayList<DataControl>();
            arrayList.addAll(this.backList);
            ArrayList<DataControl> arrayList2 = new ArrayList<DataControl>();
            arrayList2.addAll(this.forwardList);
            this.changeDataControl(dataControl);
            this.backList = arrayList;
            this.backList.add(dataControl);
            this.forwardList = arrayList2;
        }
    }
}

