/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.structurepanel;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.gui.editdialogs.SelectEffectsDialog;
import es.eucm.eadventure.editor.gui.structurepanel.EffectInfoPanel;
import es.eucm.eadventure.editor.gui.structurepanel.StructureListElement;
import es.eucm.eadventure.editor.gui.structurepanel.StructurePanel;
import es.eucm.eadventure.editor.gui.structurepanel.structureelements.Effects.ChangesInSceneStructureListElement;
import es.eucm.eadventure.editor.gui.structurepanel.structureelements.Effects.EffectsStructureListElement;
import es.eucm.eadventure.editor.gui.structurepanel.structureelements.Effects.FeedbackStructureListElement;
import es.eucm.eadventure.editor.gui.structurepanel.structureelements.Effects.GameStateStructureListElement;
import es.eucm.eadventure.editor.gui.structurepanel.structureelements.Effects.MainStructureListElement;
import es.eucm.eadventure.editor.gui.structurepanel.structureelements.Effects.MiscelaneousStructureListElement;
import es.eucm.eadventure.editor.gui.structurepanel.structureelements.Effects.MultimediaStructureListElement;
import es.eucm.eadventure.editor.gui.structurepanel.structureelements.Effects.TriggerStructureListElement;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EffectsStructurePanel
extends StructurePanel {
    private static final long serialVersionUID = 1L;
    private static final String ACTIVATE_URL = "effects_short/Effects_Activate.html";
    private static final String DEACTIVATE_URL = "effects_short/Effects_Deactivate.html";
    private static final String INCR_URL = "effects_short/Effects_Increment.html";
    private static final String DECR_URL = "effects_short/Effects_Decrement.html";
    private static final String SET_URL = "effects_short/Effects_Setvar.html";
    private static final String MACRO_URL = "effects_short/Effects_Macro.html";
    private static final String CONSUME_URL = "effects_short/Effects_Consume.html";
    private static final String GENERATE_URL = "effects_short/Effects_Generate.html";
    private static final String CANCEL_URL = "effects_short/Effects_Cancel.html";
    private static final String SP_PLAYER_URL = "effects_short/Effects_SP_Player.html";
    private static final String SP_NPC_URL = "effects_short/Effects_SP_NPC.html";
    private static final String BOOK_URL = "effects_short/Effects_Book.html";
    private static final String SOUND_URL = "effects_short/Effects_Audio.html";
    private static final String ANIMATION_URL = "effects_short/Effects_Animation.html";
    private static final String MV_PLAYER_URL = "effects_short/Effects_MV_Player.html";
    private static final String MV_NPC_URL = "effects_short/Effects_MV_NPC.html";
    private static final String CONV_URL = "effects_short/Effects_Conversation.html";
    private static final String CUTSCENE_URL = "effects_short/Effects_Cutscene.html";
    private static final String SCENE_URL = "effects_short/Effects_Scene.html";
    private static final String LAST_SCENE_URL = "effects_short/Effects_LastScene.html";
    private static final String RAMDON_URL = "effects_short/Effects_Random.html";
    private static final String TEXT_URL = "effects_short/Effects_ShowText.html";
    private static final String TIME_URL = "effects_short/Effects_WaitTime.html";
    private static final String HIGHLIGHT_URL = "effects_short/Effects_HighlightItem.html";
    private static final String MOVE_OBJECT_URL = "effects_short/Effects_MoveObject.html";
    private EffectInfoPanel infoPanel;
    private boolean showAll;
    private SelectEffectsDialog dialog;
    public static final int ICON_SIZE_SMALL = 0;
    public static final int ICON_SIZE_MEDIUM = 1;
    public static final int ICON_SIZE_LARGE = 2;
    public static final int ICON_SIZE_LARGE_HOT = 3;

    private static String getIconBasePath(int n) {
        if (n == 0) {
            return "img/icons/effects/16x16/";
        }
        if (n == 2) {
            return "img/icons/effects/64x64/";
        }
        if (n == 3) {
            return "img/icons/effects/64x64-hot/";
        }
        return "img/icons/effects/32x32/";
    }

    public static Icon getEffectIcon(String string, int n) {
        ImageIcon imageIcon = null;
        imageIcon = string.equals(TC.get((String)"Effect.Activate")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "activate.png") : (string.equals(TC.get((String)"Effect.Deactivate")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "deactivate.png") : (string.equals(TC.get((String)"Effect.SetValue")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "set-value.png") : (string.equals(TC.get((String)"Effect.IncrementVar")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "increment.png") : (string.equals(TC.get((String)"Effect.DecrementVar")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "decrement.png") : (string.equals(TC.get((String)"Effect.MacroReference")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "macro.png") : (string.equals(TC.get((String)"Effect.ConsumeObject")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "consume-object.png") : (string.equals(TC.get((String)"Effect.GenerateObject")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "generate-object.png") : (string.equals(TC.get((String)"Effect.CancelAction")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "cancel-action.png") : (string.equals(TC.get((String)"Effect.SpeakPlayer")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "speak-player.png") : (string.equals(TC.get((String)"Effect.SpeakCharacter")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "speak-npc.png") : (string.equals(TC.get((String)"Effect.TriggerBook")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "trigger-book.png") : (string.equals(TC.get((String)"Effect.PlaySound")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "play-sound.png") : (string.equals(TC.get((String)"Effect.PlayAnimation")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "play-animation.png") : (string.equals(TC.get((String)"Effect.MovePlayer")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "move-player.png") : (string.equals(TC.get((String)"Effect.MoveCharacter")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "move-npc.png") : (string.equals(TC.get((String)"Effect.TriggerConversation")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "trigger-conversation.png") : (string.equals(TC.get((String)"Effect.TriggerCutscene")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "trigger-cutscene.png") : (string.equals(TC.get((String)"Effect.TriggerScene")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "trigger-scene.png") : (string.equals(TC.get((String)"Effect.TriggerLastScene")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "trigger-last-scene.png") : (string.equals(TC.get((String)"Effect.RandomEffect")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "random-effect.png") : (string.equals(TC.get((String)"Effect.ShowText")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "show-text.png") : (string.equals(TC.get((String)"Effect.WaitTime")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "wait.png") : (string.equals(TC.get((String)"Effect.HighlightItem")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "highlight-item.png") : (string.equals(TC.get((String)"Effect.MoveObject")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "move-object.png") : (string.equals(TC.get((String)"EffectsGroup.GameState")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "game-state.png") : (string.equals(TC.get((String)"EffectsGroup.Multimedia")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "multimedia.png") : (string.equals(TC.get((String)"EffectsGroup.Miscellaneous")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "miscellaneous.png") : (string.equals(TC.get((String)"EffectsGroup.Trigger")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "trigger-events.png") : (string.equals(TC.get((String)"EffectsGroup.Feedback")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "feedback.png") : (string.equals(TC.get((String)"EffectsGroup.ChangeInScene")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "changes-in-scene.png") : (string.equals(TC.get((String)"EffectsGroup.Main")) ? new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "effects") : new ImageIcon(EffectsStructurePanel.getIconBasePath(n) + "effects"))))))))))))))))))))))))))))))));
        return imageIcon;
    }

    public EffectsStructurePanel(boolean bl, SelectEffectsDialog selectEffectsDialog) {
        super(null, 30, 55);
        this.showAll = bl;
        this.dialog = selectEffectsDialog;
        this.infoPanel = new EffectInfoPanel();
        this.recreateElements();
        this.changeEffectEditPanel(((EffectsStructureListElement)this.structureElements.get(0)).getPath());
    }

    public String getSelectedEffect() {
        if (this.list.getSelectedRow() == -1) {
            return null;
        }
        return ((StructureListElement)this.structureElements.get(this.selectedElement)).getChild(this.list.getSelectedRow()).getName();
    }

    @Override
    public void recreateElements() {
        this.structureElements.clear();
        if (this.showAll) {
            this.structureElements.add(new MainStructureListElement());
        } else {
            this.structureElements.add(new GameStateStructureListElement());
            this.structureElements.add(new MultimediaStructureListElement());
            this.structureElements.add(new FeedbackStructureListElement());
            this.structureElements.add(new TriggerStructureListElement());
            this.structureElements.add(new ChangesInSceneStructureListElement());
            this.structureElements.add(new MiscelaneousStructureListElement());
        }
        this.update();
    }

    @Override
    public void update() {
        super.update();
        int n = 0;
        this.removeAll();
        for (StructureListElement structureListElement : this.structureElements) {
            if (n == this.selectedElement) {
                this.add((Component)this.createSelectedElementPanel(structureListElement, n), new Integer(structureListElement.getChildCount() != 0 ? -1 : 40));
            } else {
                this.button = new JButton(structureListElement.getName(), structureListElement.getIcon());
                this.button.setHorizontalAlignment(2);
                Border border = BorderFactory.createRaisedBevelBorder();
                Border border2 = BorderFactory.createEmptyBorder(3, 10, 3, 10);
                this.button.setBorder(BorderFactory.createCompoundBorder(border, border2));
                this.button.setContentAreaFilled(false);
                this.button.addActionListener(new ListElementButtonActionListener(n));
                this.button.setFocusable(false);
                if (n < this.selectedElement) {
                    this.add((Component)this.button, new Integer(35));
                } else if (n > this.selectedElement) {
                    this.add((Component)this.button, new Integer(35));
                }
            }
            ++n;
        }
        this.updateUI();
    }

    @Override
    protected JPanel createSelectedElementPanel(StructureListElement structureListElement, final int n) {
        JPanel jPanel = super.createSelectedElementPanel(structureListElement, n);
        this.button.addActionListener(new ListElementButtonActionListener(n));
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    EffectsStructurePanel.this.dialog.setOk(true);
                }
            }
        });
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (EffectsStructurePanel.this.list.getSelectedRow() >= 0) {
                    EffectsStructurePanel.this.list.setRowHeight(20);
                    EffectsStructurePanel.this.list.setRowHeight(EffectsStructurePanel.this.list.getSelectedRow(), 30);
                    EffectsStructurePanel.this.list.editCellAt(EffectsStructurePanel.this.list.getSelectedRow(), 0);
                    EffectsStructurePanel.this.changeEffectEditPanel(EffectsStructurePanel.this.getSelectedEffect());
                } else {
                    EffectsStructurePanel.this.changeEffectEditPanel(((EffectsStructureListElement)EffectsStructurePanel.this.structureElements.get(n)).getPath());
                }
            }
        });
        return jPanel;
    }

    public EffectInfoPanel getInfoPanel() {
        return this.infoPanel;
    }

    public void setInfoPanel(EffectInfoPanel effectInfoPanel) {
        this.infoPanel = effectInfoPanel;
    }

    private void changeEffectEditPanel(String string) {
        String string2 = null;
        string2 = string.equals(TC.get((String)"Effect.Activate")) ? ACTIVATE_URL : (string.equals(TC.get((String)"Effect.Deactivate")) ? DEACTIVATE_URL : (string.equals(TC.get((String)"Effect.SetValue")) ? SET_URL : (string.equals(TC.get((String)"Effect.IncrementVar")) ? INCR_URL : (string.equals(TC.get((String)"Effect.DecrementVar")) ? DECR_URL : (string.equals(TC.get((String)"Effect.MacroReference")) ? MACRO_URL : (string.equals(TC.get((String)"Effect.ConsumeObject")) ? CONSUME_URL : (string.equals(TC.get((String)"Effect.GenerateObject")) ? GENERATE_URL : (string.equals(TC.get((String)"Effect.CancelAction")) ? CANCEL_URL : (string.equals(TC.get((String)"Effect.SpeakPlayer")) ? SP_PLAYER_URL : (string.equals(TC.get((String)"Effect.SpeakCharacter")) ? SP_NPC_URL : (string.equals(TC.get((String)"Effect.TriggerBook")) ? BOOK_URL : (string.equals(TC.get((String)"Effect.PlaySound")) ? SOUND_URL : (string.equals(TC.get((String)"Effect.PlayAnimation")) ? ANIMATION_URL : (string.equals(TC.get((String)"Effect.MovePlayer")) ? MV_PLAYER_URL : (string.equals(TC.get((String)"Effect.MoveCharacter")) ? MV_NPC_URL : (string.equals(TC.get((String)"Effect.TriggerConversation")) ? CONV_URL : (string.equals(TC.get((String)"Effect.TriggerCutscene")) ? CUTSCENE_URL : (string.equals(TC.get((String)"Effect.TriggerScene")) ? SCENE_URL : (string.equals(TC.get((String)"Effect.TriggerLastScene")) ? LAST_SCENE_URL : (string.equals(TC.get((String)"Effect.RandomEffect")) ? RAMDON_URL : (string.equals(TC.get((String)"Effect.ShowText")) ? TEXT_URL : (string.equals(TC.get((String)"Effect.WaitTime")) ? TIME_URL : (string.equals(TC.get((String)"Effect.HighlightItem")) ? HIGHLIGHT_URL : (string.equals(TC.get((String)"Effect.MoveObject")) ? MOVE_OBJECT_URL : string))))))))))))))))))))))));
        this.infoPanel.setHTMLText(string2);
    }

    private class ListElementButtonActionListener
    implements ActionListener {
        private int index;

        public ListElementButtonActionListener(int n) {
            this.index = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EffectsStructurePanel.this.selectedElement = this.index;
            EffectsStructurePanel.this.update();
            EffectsStructurePanel.this.changeEffectEditPanel(((EffectsStructureListElement)EffectsStructurePanel.this.structureElements.get(EffectsStructurePanel.this.selectedElement)).getPath());
            EffectsStructurePanel.this.list.requestFocusInWindow();
        }
    }
}

