/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.startdialog;

import es.eucm.eadventure.common.auxiliar.ReleaseFolders;
import es.eucm.eadventure.common.data.adventure.DescriptorData;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.common.loader.InputStreamCreator;
import es.eucm.eadventure.common.loader.Loader;
import es.eucm.eadventure.editor.auxiliar.filefilters.EADAndFolderFileFilter;
import es.eucm.eadventure.editor.auxiliar.filefilters.JARFileFilter;
import es.eucm.eadventure.editor.auxiliar.filefilters.ZIPFileFilter;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.config.ConfigData;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.gui.startdialog.DescriptorDataPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class StartDialog
extends JFileChooser {
    private static final long serialVersionUID = -544319646379939561L;
    private int option;
    private JDialog dialog;
    public static final int NO_CUSTOM_OPTION = -2;
    public static final int NEW_FILE_OPTION = 4;
    public static final int OPEN_FILE_OPTION = 0;
    public static final int RECENT_FILE_OPTION = 5;
    public static final int APROVE_SELECTION = 6;
    public static final int NEW_TAB = 0;
    public static final int OPEN_TAB = 1;
    private File recentFile;
    private int fileType;
    private JList list;
    private JEditorPane helpText;
    private JTable todayTable;
    private JTable yesterdayTable;
    private JTable beforeTable;
    private DescriptorDataPanel descriptorDataPanel;
    private JButton buttonCancel;
    private JButton buttonNew;
    private JButton openRecentsButton;
    private JTabbedPane tab;

    public int getFileType() {
        return this.fileType;
    }

    public void setFileType(int n) {
        this.fileType = n;
    }

    public StartDialog(int n) {
        this();
        this.tab.setSelectedIndex(n);
    }

    public StartDialog() {
        this.setFileFilter((FileFilter)((Object)new ZIPFileFilter()));
        this.setFileFilter((FileFilter)((Object)new JARFileFilter()));
        this.setFileFilter((FileFilter)((Object)new EADAndFolderFileFilter(this)));
        this.setCurrentDirectory((File)ReleaseFolders.projectsFolder());
        this.setMultiSelectionEnabled(false);
        this.setFileSelectionMode(2);
        this.option = -2;
        this.recentFile = null;
        this.fileType = -2;
        ImageIcon imageIcon = new ImageIcon("img/logo-editor.png");
        JLabel jLabel = new JLabel(imageIcon);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.tab = new JTabbedPane();
        this.tab.insertTab(TC.get((String)"GeneralText.New"), null, this.createNewFilePanel(), "", 0);
        this.tab.insertTab(TC.get((String)"GeneralText.Open"), null, this.createOpenFilePanel(), "", 1);
        this.tab.insertTab(TC.get((String)"StartDialog.Recent"), null, this.createRecentFilesPanel(), "", 2);
        this.tab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (((JTabbedPane)changeEvent.getSource()).getSelectedIndex() == 1) {
                    StartDialog.this.option = -2;
                }
            }
        });
        this.setLayout(new BorderLayout());
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.tab, gridBagConstraints);
        this.add(jPanel);
        this.setSize(new Dimension(690, 600));
        this.setMinimumSize(new Dimension(690, 600));
        this.setPreferredSize(new Dimension(690, 600));
    }

    private JPanel createNewFilePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JScrollPane jScrollPane = new JScrollPane(22, 30);
        this.helpText = new JEditorPane();
        this.updateHelpText();
        this.helpText.setBorder(BorderFactory.createEtchedBorder());
        jScrollPane.setViewportView(this.helpText);
        jScrollPane.setBackground(this.getBackground());
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"GeneralText.Information")));
        jScrollPane.setMaximumSize(new Dimension(320, 200));
        jScrollPane.setMinimumSize(new Dimension(320, 200));
        JScrollPane jScrollPane2 = new JScrollPane(22, 30);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setPreferredSize(new Dimension(67, 67));
        jPanel2.add((Component)new JLabel(new ImageIcon("img/newAdventureNormalMode65.png")), "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setPreferredSize(new Dimension(67, 67));
        jPanel3.add((Component)new JLabel(new ImageIcon("img/newAdventureTransparentMode65.png")), "Center");
        this.list = new JList();
        this.list.setVisibleRowCount(-20);
        this.list.setBorder(BorderFactory.createEtchedBorder());
        this.list.setListData(new JPanel[]{jPanel2, jPanel3});
        this.list.setSelectedIndex(0);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (StartDialog.this.list.getSelectedIndex() == 0) {
                    StartDialog.this.fileType = 1;
                    StartDialog.this.buttonNew.setEnabled(true);
                } else if (StartDialog.this.list.getSelectedIndex() == 1) {
                    StartDialog.this.fileType = 0;
                    StartDialog.this.buttonNew.setEnabled(true);
                } else if (StartDialog.this.list.getSelectedIndex() == 2) {
                    StartDialog.this.fileType = 2;
                    StartDialog.this.buttonNew.setEnabled(false);
                } else if (StartDialog.this.list.getSelectedIndex() == 3) {
                    StartDialog.this.fileType = 3;
                    StartDialog.this.buttonNew.setEnabled(false);
                }
                StartDialog.this.updateHelpText();
            }
        });
        this.list.setCellRenderer(new CellRenderer());
        this.list.setMinimumSize(new Dimension(150, 200));
        this.list.setPreferredSize(new Dimension(150, 200));
        jScrollPane2.setViewportView(this.list);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"StartDialog.DocumentTypes"));
        titledBorder.setTitlePosition(2);
        jScrollPane2.setBackground(this.list.getBackground());
        jScrollPane2.setBorder(titledBorder);
        jScrollPane2.setBackground(this.getBackground());
        jScrollPane2.setMaximumSize(new Dimension(150, 200));
        jScrollPane2.setMinimumSize(new Dimension(150, 200));
        this.list.setBorder(BorderFactory.createEtchedBorder());
        this.list.setLayoutOrientation(2);
        this.buttonNew = new JButton(TC.get((String)"StartDialog.CreateNew"));
        this.buttonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartDialog.this.option = 4;
                if (StartDialog.this.fileType == -2) {
                    StartDialog.this.fileType = 1;
                }
                StartDialog.this.approveSelection();
            }
        });
        this.buttonCancel = new JButton(TC.get((String)"GeneralText.Cancel"));
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartDialog.this.option = -2;
                StartDialog.this.cancelSelection();
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        jPanel4.add(this.buttonNew);
        jPanel4.add(Box.createHorizontalStrut(2));
        jPanel4.add(this.buttonCancel);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        return jPanel;
    }

    private JPanel createOpenFilePanel() {
        JPanel jPanel;
        block3: {
            LayoutManager layoutManager;
            block2: {
                jPanel = new JPanel();
                layoutManager = this.getLayout();
                if (!(layoutManager instanceof BorderLayout)) break block2;
                jPanel.setLayout(new BorderLayout());
                BorderLayout borderLayout = (BorderLayout)this.getLayout();
                for (Component component : this.getComponents()) {
                    jPanel.add(component, borderLayout.getConstraints(component));
                }
                break block3;
            }
            if (!(layoutManager instanceof BoxLayout)) break block3;
            BoxLayout boxLayout = (BoxLayout)this.getLayout();
            jPanel.setLayout(new BoxLayout(jPanel, boxLayout.getAxis()));
            for (Component component : this.getComponents()) {
                jPanel.add(component);
            }
        }
        return jPanel;
    }

    private JPanel createRecentFilesPanel() {
        this.todayTable = new JTable();
        this.yesterdayTable = new JTable();
        this.beforeTable = new JTable();
        JScrollPane jScrollPane = new JScrollPane(20, 31);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"StartDialog.Recent.OpenedToday"));
        titledBorder.setTitleJustification(2);
        JTable[] jTableArray = new JTable[]{this.yesterdayTable, this.beforeTable};
        RecentFilesTableModel recentFilesTableModel = new RecentFilesTableModel(1, 0, this.todayTable, jTableArray);
        this.todayTable.setModel(recentFilesTableModel);
        this.todayTable.setSelectionMode(0);
        this.todayTable.getColumnModel().getColumn(0).setPreferredWidth(32);
        this.todayTable.getColumnModel().getColumn(0).setMaxWidth(32);
        this.todayTable.getColumnModel().getColumn(0).setMinWidth(32);
        this.todayTable.getColumnModel().getColumn(0).setCellRenderer(new TableRenderer());
        this.todayTable.setRowHeight(32);
        this.todayTable.addMouseListener(recentFilesTableModel);
        jScrollPane.setViewportView(this.todayTable);
        jScrollPane.setBorder(titledBorder);
        JScrollPane jScrollPane2 = new JScrollPane(20, 31);
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"StartDialog.Recent.OpenedYesterday"));
        titledBorder2.setTitleJustification(2);
        JTable[] jTableArray2 = new JTable[]{this.todayTable, this.beforeTable};
        RecentFilesTableModel recentFilesTableModel2 = new RecentFilesTableModel(2, 1, this.yesterdayTable, jTableArray2);
        this.yesterdayTable.setModel(recentFilesTableModel2);
        this.yesterdayTable.getColumnModel().getColumn(0).setPreferredWidth(32);
        this.yesterdayTable.getColumnModel().getColumn(0).setMaxWidth(32);
        this.yesterdayTable.getColumnModel().getColumn(0).setMinWidth(32);
        this.yesterdayTable.setRowHeight(32);
        this.yesterdayTable.setSelectionMode(0);
        this.yesterdayTable.addMouseListener(recentFilesTableModel2);
        this.yesterdayTable.getColumnModel().getColumn(0).setCellRenderer(new TableRenderer());
        jScrollPane2.setViewportView(this.yesterdayTable);
        jScrollPane2.setBorder(titledBorder2);
        JScrollPane jScrollPane3 = new JScrollPane(20, 31);
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"StartDialog.Recent.OpenedOlder"));
        titledBorder3.setTitleJustification(2);
        jScrollPane3.setBorder(titledBorder3);
        JTable[] jTableArray3 = new JTable[]{this.yesterdayTable, this.todayTable};
        RecentFilesTableModel recentFilesTableModel3 = new RecentFilesTableModel(2, this.beforeTable, jTableArray3);
        this.beforeTable.setModel(recentFilesTableModel3);
        this.beforeTable.setSelectionMode(0);
        this.beforeTable.getColumnModel().getColumn(0).setPreferredWidth(32);
        this.beforeTable.getColumnModel().getColumn(0).setMaxWidth(32);
        this.beforeTable.getColumnModel().getColumn(0).setMinWidth(32);
        this.beforeTable.getColumnModel().getColumn(0).setCellRenderer(new TableRenderer());
        this.beforeTable.setRowHeight(32);
        this.beforeTable.addMouseListener(recentFilesTableModel3);
        jScrollPane3.setViewportView(this.beforeTable);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        this.openRecentsButton = new JButton(TC.get((String)"GeneralText.Open"));
        this.openRecentsButton.setEnabled(false);
        this.openRecentsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartDialog.this.option = 5;
                StartDialog.this.approveSelection();
            }
        });
        JButton jButton = new JButton(TC.get((String)"GeneralText.Cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartDialog.this.option = -2;
                StartDialog.this.cancelSelection();
            }
        });
        jPanel.add(this.openRecentsButton);
        jPanel.add(Box.createHorizontalStrut(1));
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        jScrollPane2.setPreferredSize(new Dimension(100, 100));
        jScrollPane3.setPreferredSize(new Dimension(100, 100));
        if (this.todayTable.getRowCount() == 0) {
            jScrollPane.removeAll();
            jScrollPane.setPreferredSize(new Dimension(100, 1));
        }
        jPanel2.add(jScrollPane);
        if (this.yesterdayTable.getRowCount() == 0) {
            jScrollPane2.removeAll();
            jScrollPane2.setPreferredSize(new Dimension(100, 1));
        }
        jPanel2.add(jScrollPane2);
        if (this.beforeTable.getRowCount() == 0) {
            jScrollPane3.removeAll();
            jScrollPane3.setPreferredSize(new Dimension(100, 1));
        }
        jPanel2.add(jScrollPane3);
        jPanel2.add(jPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        jPanel2.setMinimumSize(new Dimension(400, 300));
        jPanel2.setPreferredSize(new Dimension(300, 300));
        jPanel3.add(jPanel2);
        this.descriptorDataPanel = new DescriptorDataPanel(null, null);
        this.descriptorDataPanel.setMinimumSize(new Dimension(200, 300));
        this.descriptorDataPanel.setPreferredSize(new Dimension(200, 300));
        jPanel3.add(this.descriptorDataPanel);
        return jPanel3;
    }

    private void updateHelpText() {
        File file;
        String string = null;
        string = this.fileType == 0 ? "startDialog/FirstPerson.html" : (this.fileType == 1 ? "startDialog/ThirdPerson.html" : (this.fileType == 2 ? "" : "startDialog/Description.html"));
        String string2 = "help/" + Controller.getInstance().getLanguage() + "/";
        File file2 = new File(string2);
        if (!file2.exists()) {
            string2 = "help/" + Controller.getInstance().getDefaultLanguage() + "/";
        }
        if ((file = new File(string2 + string)).exists()) {
            try {
                this.helpText.setPage(file.toURI().toURL());
                this.helpText.setEditable(false);
            }
            catch (MalformedURLException malformedURLException) {
                this.writeFileNotFound(string2 + string);
            }
            catch (IOException iOException) {
                this.writeFileNotFound(string2 + string);
            }
        } else {
            this.writeFileNotFound(string2 + string);
        }
        this.helpText.updateUI();
    }

    private void writeFileNotFound(String string) {
        this.helpText.add(new JLabel(TC.get((String)"HelpDialog.FileNotFound") + " " + string));
    }

    @Override
    public int showDialog(Component component, String string) {
        int n = super.showDialog(component, string);
        if (this.option == -2) {
            return n;
        }
        return this.option;
    }

    @Override
    protected JDialog createDialog(Component component) throws HeadlessException {
        this.dialog = super.createDialog(component);
        this.dialog.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        ArrayList<Image> arrayList = new ArrayList<Image>();
        arrayList.add(AssetsController.getImage("img/Icono-Editor-16x16.png"));
        arrayList.add(AssetsController.getImage("img/Icono-Editor-32x32.png"));
        arrayList.add(AssetsController.getImage("img/Icono-Editor-64x64.png"));
        arrayList.add(AssetsController.getImage("img/Icono-Editor-128x128.png"));
        this.dialog.setIconImages(arrayList);
        this.dialog.setTitle(TC.get((String)"StartDialog.Title"));
        return this.dialog;
    }

    public File getRecentFile() {
        return this.recentFile;
    }

    public void setRecentFile(File file) {
        this.recentFile = file;
    }

    public boolean isOpenOption() {
        return this.tab.getSelectedIndex() == 1;
    }

    public int getOption() {
        return this.option;
    }

    private class CellRenderer
    implements ListCellRenderer {
        private CellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JPanel jPanel = (JPanel)object;
            if (!bl || jPanel.getComponentCount() == 0) {
                jPanel.setBackground(jList.getBackground());
                jPanel.setForeground(jList.getForeground());
            } else {
                jPanel.setBackground(jList.getSelectionBackground());
                jPanel.setForeground(jList.getSelectionForeground());
            }
            return jPanel;
        }
    }

    private class TableRenderer
    implements TableCellRenderer {
        private TableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 0) {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                try {
                    String string = (String)object;
                    DescriptorData descriptorData = Loader.loadDescriptorData((InputStreamCreator)AssetsController.getInputStreamCreator(string));
                    if (descriptorData.getPlayerMode() == 0) {
                        return new JLabel(new ImageIcon("img/TransparentAdventure32.png"));
                    }
                    if (descriptorData.getPlayerMode() == 1) {
                        return new JLabel(new ImageIcon("img/NormalAdventure32.png"));
                    }
                    return jPanel;
                }
                catch (Exception exception) {
                    return jPanel;
                }
            }
            return null;
        }
    }

    private class RecentFilesTableModel
    extends AbstractTableModel
    implements MouseListener {
        private static final long serialVersionUID = -4878543735587447453L;
        private String[][] info;
        private JTable table;
        private JTable[] otherTables;

        public RecentFilesTableModel(int n, int n2, JTable jTable, JTable[] jTableArray) {
            this.info = ConfigData.getRecentFilesInfo(n, n2);
            this.table = jTable;
            this.otherTables = jTableArray;
        }

        public RecentFilesTableModel(int n, JTable jTable, JTable[] jTableArray) {
            this.info = ConfigData.getRecentFilesInfo(n);
            this.table = jTable;
            this.otherTables = jTableArray;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.info.length;
        }

        @Override
        public String getColumnName(int n) {
            return TC.get((String)("StartDialog.Recent.ColumnHeader" + n));
        }

        @Override
        public Object getValueAt(int n, int n2) {
            int n3 = this.info.length - n - 1;
            if (n2 == 1) {
                String string = this.info[n3][0];
                int n4 = string.lastIndexOf("\\");
                if (n4 > 0 && n4 < string.length()) {
                    return string.substring(n4 + 1, string.length());
                }
                n4 = string.lastIndexOf("/");
                if (n4 > 0 && n4 < string.length()) {
                    return string.substring(n4 + 1, string.length());
                }
                return "";
            }
            if (n2 == 0) {
                return this.info[n3][0];
            }
            return "";
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                StartDialog.this.option = 5;
                StartDialog.this.approveSelection();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = this.info.length - this.table.getSelectedRow() - 1;
            if (n >= 0) {
                StartDialog.this.openRecentsButton.setEnabled(true);
                StartDialog.this.recentFile = new File(this.info[n][0]);
                try {
                    StartDialog.this.descriptorDataPanel.update(Loader.loadDescriptorData((InputStreamCreator)AssetsController.getInputStreamCreator(StartDialog.this.recentFile.getAbsolutePath())), StartDialog.this.recentFile.getAbsolutePath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (JTable jTable : this.otherTables) {
                    jTable.clearSelection();
                }
            } else {
                StartDialog.this.openRecentsButton.setEnabled(false);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

