/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.startdialog;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.gui.ProjectFolderChooser;
import es.eucm.eadventure.editor.gui.startdialog.StartDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFrame;

public class FrameForInitialDialogs {
    private int option;
    private boolean isStartDialog;
    private JFrame frame;
    private StartDialog fileChooser;
    private ProjectFolderChooser projectChooser;

    public FrameForInitialDialogs(boolean bl) {
        this.isStartDialog = bl;
        if (this.isStartDialog) {
            this.fileChooser = new StartDialog();
        } else {
            this.projectChooser = new ProjectFolderChooser(false, false);
        }
    }

    public FrameForInitialDialogs(int n) {
        this.fileChooser = new StartDialog(n);
        this.isStartDialog = true;
    }

    public synchronized int showStartDialog() {
        this.frame = new JFrame(TC.get((String)"StartDialog.Title"));
        this.frame.setDefaultCloseOperation(3);
        ArrayList<Image> arrayList = new ArrayList<Image>();
        arrayList.add(AssetsController.getImage("img/Icono-Editor-16x16.png"));
        arrayList.add(AssetsController.getImage("img/Icono-Editor-32x32.png"));
        arrayList.add(AssetsController.getImage("img/Icono-Editor-64x64.png"));
        arrayList.add(AssetsController.getImage("img/Icono-Editor-128x128.png"));
        this.frame.setIconImages(arrayList);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("ApproveSelection")) {
                    FrameForInitialDialogs.this.getOptionFromChooser();
                } else if (string.equals("CancelSelection")) {
                    FrameForInitialDialogs.this.getOptionFromChooser(1);
                }
                FrameForInitialDialogs.this.finish();
            }
        };
        if (this.isStartDialog) {
            this.fileChooser.addActionListener(actionListener);
            this.frame.add((Component)this.fileChooser, "Center");
        } else {
            this.projectChooser.addActionListener(actionListener);
            this.frame.add((Component)this.projectChooser, "Center");
        }
        this.frame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.frame.getSize();
        this.frame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.frame.setVisible(true);
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.option;
    }

    private void getOptionFromChooser(int n) {
        this.option = n;
    }

    private void getOptionFromChooser() {
        if (this.isStartDialog) {
            this.option = this.fileChooser.getOption();
            if (this.fileChooser.isOpenOption()) {
                this.option = 0;
            }
        } else {
            this.option = 6;
        }
    }

    public void remove() {
        this.frame.dispose();
    }

    public synchronized void finish() {
        this.notify();
        if (this.isStartDialog) {
            this.frame.setVisible(false);
        }
    }

    public int getFileType() {
        return this.fileChooser.getFileType();
    }

    public File getRecentFile() {
        return this.fileChooser.getRecentFile();
    }

    public File getSelectedFile() {
        if (this.isStartDialog) {
            return this.fileChooser.getSelectedFile();
        }
        return this.projectChooser.getSelectedFile();
    }
}

