/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.startdialog;

import es.eucm.eadventure.common.data.adventure.DescriptorData;
import es.eucm.eadventure.common.gui.TC;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DescriptorDataPanel
extends JPanel {
    private static final long serialVersionUID = -4705653880828167412L;
    private DescriptorData currentDescriptor = null;
    private JTextField titleTextField;
    private JTextArea descriptionTextArea;
    private JTextArea playerModeDescription;
    private JTextField playerMode;
    private JTextField pathTextField;
    private String absoultePath;

    public DescriptorDataPanel(DescriptorData descriptorData, String string) {
        this.currentDescriptor = descriptorData;
        this.absoultePath = string;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Adventure.Title")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout());
        this.titleTextField = this.currentDescriptor != null ? new JTextField(this.currentDescriptor.getTitle()) : new JTextField("");
        this.titleTextField.setEditable(false);
        jPanel2.add(this.titleTextField);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Adventure.AdventureTitle")));
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        this.pathTextField = string != null ? new JTextField(this.absoultePath) : new JTextField("");
        this.pathTextField.setEditable(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout());
        jPanel3.add(this.pathTextField);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Adventure.CompletePath")));
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout());
        this.descriptionTextArea = this.currentDescriptor != null ? new JTextArea(descriptorData.getDescription(), 4, 0) : new JTextArea("", 4, 0);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(true);
        jPanel4.add(new JScrollPane(this.descriptionTextArea, 22, 31));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Adventure.AdventureDescription")));
        this.descriptionTextArea.setEditable(false);
        jPanel.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.gridy = 3;
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 22;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 0.5;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weighty = 0.35;
        gridBagConstraints2.gridy = 0;
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Adventure.AdventureDescription")));
        this.playerMode = null;
        this.playerModeDescription = new JTextArea();
        this.playerModeDescription.setEditable(false);
        this.playerModeDescription.setWrapStyleWord(true);
        this.playerModeDescription.setBackground(jPanel5.getBackground());
        this.playerModeDescription.setBorder(BorderFactory.createEtchedBorder());
        this.playerModeDescription.setLineWrap(true);
        if (descriptorData == null) {
            this.playerMode = new JTextField("");
            this.playerModeDescription.setText("");
        } else if (descriptorData.getPlayerMode() == 0) {
            this.playerMode = new JTextField(TC.get((String)"Adventure.ModePlayerTransparent.Name"));
            this.playerModeDescription.setText(TC.get((String)"Adventure.ModePlayerTransparent.Description"));
        } else {
            this.playerMode = new JTextField(TC.get((String)"Adventure.ModePlayerVisible.Name"));
            this.playerModeDescription.setText(TC.get((String)"Adventure.ModePlayerVisible.Description"));
        }
        this.playerMode.setEditable(false);
        this.playerMode.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Adventure.CurrentPlayerMode")));
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 21;
        jPanel5.add((Component)this.playerMode, gridBagConstraints2);
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.65;
        gridBagConstraints2.anchor = 10;
        jPanel5.add((Component)this.playerModeDescription, gridBagConstraints2);
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Adventure.PlayerMode")));
        jPanel.add((Component)jPanel5, gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
    }

    public DescriptorData getCurrentDescriptor() {
        return this.currentDescriptor;
    }

    public void update(DescriptorData descriptorData, String string) {
        this.currentDescriptor = descriptorData;
        this.absoultePath = string;
        if (descriptorData == null) {
            this.playerMode.setText("");
            this.playerModeDescription.setText("");
        } else if (descriptorData.getPlayerMode() == 0) {
            this.playerMode.setText(TC.get((String)"Adventure.ModePlayerTransparent.Name"));
            this.playerModeDescription.setText(TC.get((String)"Adventure.ModePlayerTransparent.Description"));
        } else {
            this.playerMode.setText(TC.get((String)"Adventure.ModePlayerVisible.Name"));
            this.playerModeDescription.setText(TC.get((String)"Adventure.ModePlayerVisible.Description"));
        }
        if (descriptorData != null) {
            this.descriptionTextArea.setText(descriptorData.getDescription());
        } else {
            this.descriptionTextArea.setText("");
        }
        if (descriptorData != null) {
            this.titleTextField.setText(descriptorData.getTitle());
        } else {
            this.titleTextField.setText("");
        }
        if (string != null) {
            this.pathTextField.setText(this.absoultePath);
        } else {
            this.pathTextField.setText("");
        }
    }
}

