/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.otherpanels.scenelistelements;

import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.data.chapter.effects.AbstractEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerConversationEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerSceneEffect;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.config.SceneLinksConfigData;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.character.NPCDataControl;
import es.eucm.eadventure.editor.control.controllers.conversation.ConversationDataControl;
import es.eucm.eadventure.editor.control.controllers.general.ActionDataControl;
import es.eucm.eadventure.editor.control.controllers.item.ItemDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreaDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ElementReferenceDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ExitDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.gui.otherpanels.SceneLinksPanel;
import es.eucm.eadventure.editor.gui.otherpanels.scenelistelements.ActiveAreaElement;
import es.eucm.eadventure.editor.gui.otherpanels.scenelistelements.ExitElement;
import es.eucm.eadventure.editor.gui.otherpanels.scenelistelements.ItemReferenceElement;
import es.eucm.eadventure.editor.gui.otherpanels.scenelistelements.NPCReferenceElement;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.ImageIcon;

public class SceneElement {
    private SceneDataControl sceneDataControl;
    private List<ExitElement> exitElements;
    private List<ActiveAreaElement> activeAreaElements;
    private List<ItemReferenceElement> itemReferenceElements;
    private List<NPCReferenceElement> npcReferenceElements;
    private int posX;
    private int posY;
    private Image image;
    private Color color;
    private boolean showName;
    private boolean visible;
    private static Image tempImage = null;

    public SceneElement(SceneDataControl sceneDataControl, int n) {
        Object object;
        this.sceneDataControl = sceneDataControl;
        this.visible = true;
        String string = sceneDataControl.getPreviewBackground();
        tempImage = AssetsController.getImage(string);
        int n2 = 800;
        int n3 = 600;
        if (tempImage == null) {
            object = new ImageIcon("img/icons/noImageFrame.png");
            tempImage = new BufferedImage(800, 600, 6);
            tempImage.getGraphics().drawImage(((ImageIcon)object).getImage(), 0, 0, 800, 600, null);
        } else {
            n2 = tempImage.getWidth(null);
            n3 = tempImage.getHeight(null);
        }
        this.image = new BufferedImage(n2 / SceneLinksPanel.DEFAULT_SCALE, n3 / SceneLinksPanel.DEFAULT_SCALE, 5);
        this.image.getGraphics().drawImage(tempImage, 0, 0, n2 / SceneLinksPanel.DEFAULT_SCALE, n3 / SceneLinksPanel.DEFAULT_SCALE, null);
        tempImage = null;
        this.color = Controller.generateColor(n);
        this.exitElements = new ArrayList<ExitElement>();
        this.activeAreaElements = new ArrayList<ActiveAreaElement>();
        this.itemReferenceElements = new ArrayList<ItemReferenceElement>();
        object = (Graphics2D)this.image.getGraphics();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
        ((Graphics2D)object).setComposite(alphaComposite);
        ((Graphics)object).setColor(this.color);
        for (ExitDataControl exitDataControl : sceneDataControl.getExitsList().getExits()) {
            int n4 = exitDataControl.getX() / SceneLinksPanel.DEFAULT_SCALE;
            int n5 = exitDataControl.getY() / SceneLinksPanel.DEFAULT_SCALE;
            int n6 = exitDataControl.getWidth() / SceneLinksPanel.DEFAULT_SCALE;
            int n7 = exitDataControl.getHeight() / SceneLinksPanel.DEFAULT_SCALE;
            ((Graphics)object).fillRect(n4, n5, n6, n7);
            this.exitElements.add(new ExitElement(exitDataControl));
        }
        this.getActiveAreaNextScene((Graphics2D)object);
        this.getItemNextScene((Graphics2D)object);
        this.getNPCNextScene((Graphics2D)object);
        this.posX = new Random().nextInt(780);
        this.posY = new Random().nextInt(580);
    }

    private void getActiveAreaNextScene(Graphics2D graphics2D) {
        for (ActiveAreaDataControl activeAreaDataControl : this.sceneDataControl.getActiveAreasList().getActiveAreas()) {
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ActionDataControl actionDataControl : activeAreaDataControl.getActionsList().getActions()) {
                for (AbstractEffect abstractEffect : actionDataControl.getEffects().getEffects()) {
                    List<String> list;
                    TriggerSceneEffect triggerSceneEffect;
                    if (abstractEffect.getType() == 14) {
                        triggerSceneEffect = (TriggerSceneEffect)abstractEffect;
                        arrayList.add(triggerSceneEffect.getTargetId());
                        bl = true;
                    }
                    if (abstractEffect.getType() != 12 || (list = this.getConversationSceneIds((triggerSceneEffect = (TriggerConversationEffect)abstractEffect).getTargetId())) == null || list.isEmpty()) continue;
                    arrayList.addAll(list);
                    bl = true;
                }
            }
            if (!bl) continue;
            int n = activeAreaDataControl.getX() / SceneLinksPanel.DEFAULT_SCALE;
            int n2 = activeAreaDataControl.getY() / SceneLinksPanel.DEFAULT_SCALE;
            int n3 = activeAreaDataControl.getWidth() / SceneLinksPanel.DEFAULT_SCALE;
            int n4 = activeAreaDataControl.getHeight() / SceneLinksPanel.DEFAULT_SCALE;
            graphics2D.fillRect(n, n2, n3, n4);
            this.activeAreaElements.add(new ActiveAreaElement(activeAreaDataControl, arrayList));
        }
    }

    private void getItemNextScene(Graphics2D graphics2D) {
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.6f);
        graphics2D.setComposite(alphaComposite);
        for (ElementReferenceDataControl elementReferenceDataControl : this.sceneDataControl.getReferencesList().getItemReferences()) {
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ActionDataControl actionDataControl : ((ItemDataControl)elementReferenceDataControl.getReferencedElementDataControl()).getActionsList().getActions()) {
                for (AbstractEffect abstractEffect : actionDataControl.getEffects().getEffects()) {
                    List<String> list;
                    TriggerSceneEffect triggerSceneEffect;
                    if (abstractEffect.getType() == 14) {
                        triggerSceneEffect = (TriggerSceneEffect)abstractEffect;
                        arrayList.add(triggerSceneEffect.getTargetId());
                        bl = true;
                    }
                    if (abstractEffect.getType() != 12 || (list = this.getConversationSceneIds((triggerSceneEffect = (TriggerConversationEffect)abstractEffect).getTargetId())) == null || list.isEmpty()) continue;
                    arrayList.addAll(list);
                    bl = true;
                }
            }
            if (!bl) continue;
            String string = Controller.getInstance().getElementImagePath(elementReferenceDataControl.getElementId());
            Image image = string != null ? AssetsController.getImage(string) : new ImageIcon("img/assets/EmptyImage.png").getImage();
            int n = (int)(elementReferenceDataControl.getElementScale() * (float)image.getWidth(null)) / SceneLinksPanel.DEFAULT_SCALE;
            int n2 = (int)(elementReferenceDataControl.getElementScale() * (float)image.getHeight(null)) / SceneLinksPanel.DEFAULT_SCALE;
            int n3 = elementReferenceDataControl.getElementX() / SceneLinksPanel.DEFAULT_SCALE - n / 2;
            int n4 = elementReferenceDataControl.getElementY() / SceneLinksPanel.DEFAULT_SCALE - n2;
            graphics2D.drawImage(image, n3, n4, n, n2, null);
            this.itemReferenceElements.add(new ItemReferenceElement(elementReferenceDataControl, n2, arrayList));
        }
    }

    private List<String> getConversationSceneIds(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ConversationDataControl conversationDataControl : Controller.getInstance().getSelectedChapterDataControl().getConversationsList().getConversations()) {
            if (!conversationDataControl.getId().equals(string)) continue;
            ArrayList<ConversationNodeView> arrayList2 = new ArrayList<ConversationNodeView>();
            arrayList2.add(conversationDataControl.getRootNode());
            for (int i = 0; i < arrayList2.size(); ++i) {
                ConversationNodeView conversationNodeView = (ConversationNodeView)arrayList2.get(i);
                for (int j = 0; j < conversationNodeView.getChildCount(); ++j) {
                    if (arrayList2.contains(conversationNodeView.getChildView(j))) continue;
                    arrayList2.add(conversationNodeView.getChildView(j));
                }
                for (AbstractEffect abstractEffect : ((ConversationNode)conversationNodeView).getEffects().getEffects()) {
                    if (abstractEffect.getType() != 14) continue;
                    TriggerSceneEffect triggerSceneEffect = (TriggerSceneEffect)abstractEffect;
                    arrayList.add(triggerSceneEffect.getTargetId());
                }
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    private void getNPCNextScene(Graphics2D graphics2D) {
        for (ElementReferenceDataControl elementReferenceDataControl : this.sceneDataControl.getReferencesList().getNPCReferences()) {
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ActionDataControl actionDataControl : ((NPCDataControl)elementReferenceDataControl.getReferencedElementDataControl()).getActionsList().getActions()) {
                for (AbstractEffect abstractEffect : actionDataControl.getEffects().getEffects()) {
                    if (abstractEffect.getType() != 14) continue;
                    TriggerSceneEffect triggerSceneEffect = (TriggerSceneEffect)abstractEffect;
                    arrayList.add(triggerSceneEffect.getTargetId());
                    bl = true;
                }
            }
            if (!bl) continue;
            String string = Controller.getInstance().getElementImagePath(elementReferenceDataControl.getElementId());
            Image image = string != null ? AssetsController.getImage(string) : new ImageIcon("img/assets/EmptyImage.png").getImage();
            int n = (int)(elementReferenceDataControl.getElementScale() * (float)image.getWidth(null)) / SceneLinksPanel.DEFAULT_SCALE;
            int n2 = (int)(elementReferenceDataControl.getElementScale() * (float)image.getHeight(null)) / SceneLinksPanel.DEFAULT_SCALE;
            int n3 = elementReferenceDataControl.getElementX() / SceneLinksPanel.DEFAULT_SCALE - n / 2;
            int n4 = elementReferenceDataControl.getElementY() / SceneLinksPanel.DEFAULT_SCALE - n2;
            graphics2D.drawImage(image, n3, n4, n, n2, null);
            this.itemReferenceElements.add(new ItemReferenceElement(elementReferenceDataControl, n2, arrayList));
        }
    }

    private void setColor() {
        switch (new Random().nextInt(9)) {
            case 0: {
                this.color = Color.CYAN;
                break;
            }
            case 1: {
                this.color = Color.BLUE;
                break;
            }
            case 2: {
                this.color = Color.RED;
                break;
            }
            case 3: {
                this.color = Color.GREEN;
                break;
            }
            case 4: {
                this.color = Color.MAGENTA;
                break;
            }
            case 5: {
                this.color = Color.ORANGE;
                break;
            }
            case 6: {
                this.color = Color.PINK;
                break;
            }
            case 7: {
                this.color = Color.WHITE;
                break;
            }
            case 8: {
                this.color = Color.YELLOW;
            }
        }
    }

    public Image getImage() {
        return this.image;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public Color getColor() {
        return this.color;
    }

    public int getWidth() {
        return this.image.getWidth(null);
    }

    public int getHeight() {
        return this.image.getHeight(null);
    }

    public String getId() {
        return this.sceneDataControl.getId();
    }

    public List<ExitElement> getExitElements() {
        return this.exitElements;
    }

    public void changePosition(int n, int n2) {
        this.posX = n < 0 ? 0 : (n > 780 ? 780 : n);
        this.posY = n2 < 0 ? 0 : (n2 > 580 ? 580 : n2);
        SceneLinksConfigData.setSceneX(this.getId(), n);
        SceneLinksConfigData.setSceneY(this.getId(), n2);
    }

    public DataControl getDataControl() {
        return this.sceneDataControl;
    }

    public void setShowName(boolean bl) {
        this.showName = bl;
    }

    public boolean isShowName() {
        return this.showName;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        SceneLinksConfigData.setSceneVisible(this.getId(), bl);
    }

    public List<ActiveAreaElement> getActiveAreaElements() {
        return this.activeAreaElements;
    }

    public List<ItemReferenceElement> getItemReferenceElements() {
        return this.itemReferenceElements;
    }

    public List<NPCReferenceElement> getNPCReferenceElements() {
        return this.npcReferenceElements;
    }
}

